/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.i18n;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.i18n.MinuteFormat;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class LocalizationImpl
implements Localization {
    private static final I18nMessages I18N = new I18nMessages("com.inet.helpdesk.i18n.LanguageResources", LocalizationImpl.class);
    private final Locale currentLocale;
    private static final Localization STATIC_INSTANCE = new LocalizationImpl(null);

    public LocalizationImpl(Locale currentLocale) {
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        this.currentLocale = currentLocale;
    }

    public static Localization getStaticInstance() {
        return STATIC_INSTANCE;
    }

    @Override
    public Format getFormatInstance(int type) {
        return this.getFormatInstance(type, this.currentLocale);
    }

    @Override
    public Format getFormatInstance(int type, Locale locale) {
        Format format = null;
        switch (type) {
            case 1: {
                format = DateFormat.getDateInstance(3, locale);
                break;
            }
            case 2: {
                format = DateFormat.getDateInstance(2, locale);
                break;
            }
            case 3: {
                format = DateFormat.getDateInstance(1, locale);
                break;
            }
            case 4: {
                format = DateFormat.getDateInstance(0, locale);
                break;
            }
            case 5: {
                format = DateFormat.getTimeInstance(3, locale);
                break;
            }
            case 6: {
                format = DateFormat.getTimeInstance(2, locale);
                break;
            }
            case 7: {
                format = DateFormat.getTimeInstance(0, locale);
                break;
            }
            case 8: {
                format = DateFormat.getDateTimeInstance(3, 3, locale);
                break;
            }
            case 9: {
                format = new SimpleDateFormat(this.getTranslation("DatumZeitPatternKurz"), locale);
                break;
            }
            case 10: {
                format = new SimpleDateFormat(this.getTranslation("DatumZeitPattern"), locale);
                break;
            }
            case 11: {
                format = new SimpleDateFormat(this.getTranslation("DatumZeitPatternYear"), locale);
                break;
            }
            case 12: {
                format = NumberFormat.getIntegerInstance();
                break;
            }
            case 13: {
                format = new DecimalFormat();
                break;
            }
            case 15: {
                format = NumberFormat.getPercentInstance(locale);
                break;
            }
            case 16: {
                format = new MinuteFormat();
            }
        }
        return format;
    }

    @Override
    public String getTranslation(String msgID) {
        return this.getTranslation(msgID, (Object[])null, I18N);
    }

    @Override
    public String getTranslation(String msgID, Object ... params) {
        return this.getTranslation(msgID, params, I18N);
    }

    @Override
    public String getTranslation(String msgID, Object[] msgParameter, I18nMessages resBun) {
        String msg;
        block5: {
            msg = msgID;
            if (resBun == null) {
                resBun = I18N;
            }
            try {
                if (resBun.hasMsg(msg, this.currentLocale)) {
                    msg = resBun.getMsg(this.currentLocale, msg, new Object[0]);
                    if (msgParameter != null) {
                        msg = MessageFormat.format(msg, msgParameter);
                    }
                    break block5;
                }
                return HDFieldDisplayNameProvider.MSG.getMsg(this.currentLocale, msg, msgParameter);
            }
            catch (Exception e) {
                HDLogger.error(e.getMessage());
            }
        }
        return msg;
    }

    @Override
    public Locale getCurrentLocale() {
        return this.currentLocale;
    }
}

