/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.itil;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.data.itil.ItilLinkCache;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import srv.mail.Mail;

public class ItilLinkManagerImpl
implements ItilLinkManager,
ConnectionCreationListener {
    private static final String SELECT_ITIL_LINK = "Select * From tblItilLinks Where SlaveAufID = ?";
    private final CopyOnWriteArrayList<ItilLinkManager.ItilLinkChangeListener> listeners = new CopyOnWriteArrayList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private ItilLinkCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionCreated() {
        try {
            this.writeLock.lock();
            this.cache = new ItilLinkCache();
            try (Connection con = this.getConnection();
                 Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery("Select * From tblItilLinks");){
                while (rs.next()) {
                    int masterID = rs.getInt("MasterAufID");
                    int slaveID = rs.getInt("SlaveAufID");
                    this.cache.addLink(masterID, slaveID);
                }
            }
            catch (SQLException ex) {
                HDLogger.fatal(ex);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void registerListener(ItilLinkManager.ItilLinkChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(ItilLinkManager.ItilLinkChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(Map<Integer, Integer> changedTicketLinkCountDiff) {
        HashMap<Integer, ItilLinkManager.ItilCountChange> changedItils = new HashMap<Integer, ItilLinkManager.ItilCountChange>();
        for (Map.Entry<Integer, Integer> en : changedTicketLinkCountDiff.entrySet()) {
            if (en.getValue() == 0) continue;
            Integer ticketId = en.getKey();
            int newCount = this.getItilLinkCount(ticketId);
            int oldCount = newCount - en.getValue();
            changedItils.put(ticketId, new ItilLinkManager.ItilCountChange(oldCount, newCount));
        }
        ItilLinkManager.ItilLinkChangeEvent event = new ItilLinkManager.ItilLinkChangeEvent(changedItils);
        for (ItilLinkManager.ItilLinkChangeListener l : this.listeners) {
            try {
                l.dataChanged(event);
            }
            catch (Throwable t) {
                HDLogger.error(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int linkItilSlavesToItilMaster(int itilMasterID, @Nonnull Set<Integer> itilSlaveIDs, @Nonnull String producerEmail) {
        boolean primaryHasWriteAccesElseRead = this.checkItilIsMaster(itilMasterID);
        this.checkItilsAreSlave(itilSlaveIDs, primaryHasWriteAccesElseRead);
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement(SELECT_ITIL_LINK, 1005, 1008);){
                for (int slaveID : itilSlaveIDs) {
                    pstmSelect.setInt(1, slaveID);
                    ResultSet rs = pstmSelect.executeQuery();
                    try {
                        boolean alreadyLinkedToMaster = rs.next();
                        if (alreadyLinkedToMaster) {
                            int previousMasterID = rs.getInt("MasterAufID");
                            if (previousMasterID == itilMasterID) continue;
                            rs.updateInt("MasterAufID", itilMasterID);
                            rs.updateRow();
                            this.storeItilCountDiff(previousMasterID, -1, changedTicketLinkCountDiff);
                            this.storeItilCountDiff(itilMasterID, 1, changedTicketLinkCountDiff);
                            this.cache.removeLink(previousMasterID, slaveID);
                            this.cache.addLink(itilMasterID, slaveID);
                            changes = true;
                            continue;
                        }
                        rs.moveToInsertRow();
                        rs.updateInt("MasterAufID", itilMasterID);
                        rs.updateInt("SlaveAufID", slaveID);
                        rs.insertRow();
                        this.storeItilCountDiff(itilMasterID, 1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(slaveID, 1, changedTicketLinkCountDiff);
                        this.cache.addLink(itilMasterID, slaveID);
                        changes = true;
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                if (changes) {
                    try {
                        Hashtable<String, String> ht = new Hashtable<String, String>();
                        ht.put("aufid", String.valueOf(itilMasterID));
                        Mail.send(ht, 15, producerEmail);
                    }
                    catch (Exception ex) {
                        HDLogger.error(ex);
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    private void checkItilsAreSlave(Set<Integer> itilSlaveIDs, boolean primaryHasWriteAccesElseRead) {
        for (Integer slaveId : itilSlaveIDs) {
            TicketVO ticket = TicketManager.getReader().getTicket(slaveId);
            if (ticket == null) {
                throw new IllegalArgumentException("Ticket with id #" + slaveId + " does not exist");
            }
            ItilVO itilVO = (ItilVO)ItilManager.getInstance().get(ticket.getItilID());
            if (itilVO.isMasterType()) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("itilLink.isMasterNotSlave", new Object[]{ticket.getID()}));
            }
            if (ticket.isSlaveInBundle()) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("itilLink.isSlaveTicket", new Object[]{ticket.getID()}));
            }
            TicketAttribute processAttribute = Tickets.getAttributeByKey("process.activity");
            if (processAttribute != null && (ticket.getAttribute(processAttribute) != null || ticket.getAttribute(Tickets.getAttributeByKey("process.mainticketid")) != null)) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("itilLink.isInProcess", new Object[]{ticket.getID()}));
            }
            if (primaryHasWriteAccesElseRead) {
                TicketPermissionContext info = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(slaveId);
                if (info != null && info.hasSupporterAccessToTicket()) continue;
                throw new AccessDeniedException(Tickets.MSG.getMsg("itilLink.accessDenied", new Object[0]));
            }
            ActionCheckError error = TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-15), ticket.getID());
            if (error == null) continue;
            throw new AccessDeniedException(error.getErrorMessage(), error.getErrorCode());
        }
    }

    private boolean checkItilIsMaster(int masterId) {
        TicketVO ticket = TicketManager.getReader().getTicket(masterId);
        if (ticket == null) {
            throw new IllegalArgumentException("Ticket with id #" + masterId + " does not exist");
        }
        ItilVO itilVO = (ItilVO)ItilManager.getInstance().get(ticket.getItilID());
        if (!itilVO.isMasterType()) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("itilLink.isSlaveNotMaster", new Object[]{ticket.getID()}));
        }
        if (ticket.isSlaveInBundle()) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("itilLink.isSlaveTicket", new Object[]{ticket.getID()}));
        }
        ActionCheckError error = TicketManager.getTicketActionChecker().checkAction((ActionVO)ActionManager.getInstance().get(-15), ticket.getID());
        if (error != null) {
            TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(masterId);
            if (ticketPermissionInfo != null && ticketPermissionInfo.hasResourceAccessToTicket()) {
                return false;
            }
            throw new AccessDeniedException(error.getErrorMessage(), error.getErrorCode());
        }
        return true;
    }

    private void storeItilCountDiff(int ticketId, int diffChange, Map<Integer, Integer> changedTicketLinkCountDiff) {
        Integer diff = changedTicketLinkCountDiff.get(ticketId);
        if (diff == null) {
            diff = 0;
        }
        diff = diff + diffChange;
        changedTicketLinkCountDiff.put(ticketId, diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeLinkFromItilSlaveToItilMaster(int itilSlaveID) {
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement(SELECT_ITIL_LINK, 1005, 1008);){
                pstmSelect.setInt(1, itilSlaveID);
                try (ResultSet rs = pstmSelect.executeQuery();){
                    if (rs.next()) {
                        int itilMasterID = rs.getInt("MasterAufID");
                        rs.deleteRow();
                        this.storeItilCountDiff(itilMasterID, -1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(itilSlaveID, -1, changedTicketLinkCountDiff);
                        this.cache.removeLink(itilMasterID, itilSlaveID);
                        changes = true;
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllLinksToItilMaster(int itilMasterID) {
        int retVal = 0;
        boolean changes = false;
        HashMap<Integer, Integer> changedTicketLinkCountDiff = new HashMap<Integer, Integer>();
        try {
            this.writeLock.lock();
            try (Connection con = this.getConnection();
                 PreparedStatement pstmSelect = con.prepareStatement("Select * From tblItilLinks Where MasterAufID = ?", 1005, 1008);){
                pstmSelect.setInt(1, itilMasterID);
                try (ResultSet rs = pstmSelect.executeQuery();){
                    while (rs.next()) {
                        int itilSlaveID = rs.getInt("SlaveAufID");
                        rs.deleteRow();
                        this.storeItilCountDiff(itilSlaveID, -1, changedTicketLinkCountDiff);
                        this.storeItilCountDiff(itilMasterID, -1, changedTicketLinkCountDiff);
                        this.cache.removeLink(itilMasterID, itilSlaveID);
                        changes = true;
                    }
                }
            }
            catch (SQLException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (changes) {
            this.notifyListeners(changedTicketLinkCountDiff);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItilLinkCount(int ticketID) {
        boolean locked = false;
        try {
            locked = this.readLock.tryLock();
            int n = this.cache.getItilLinkCount(ticketID);
            return n;
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }

    @Override
    public Set<Integer> getItilMastersLinkedToSlaves() {
        boolean locked = false;
        try {
            locked = this.readLock.tryLock();
            Set<Integer> set = this.cache.getItilMastersLinkedToSlaves();
            return set;
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Integer> getItilSlavesLinkedTo(int itilMasterID) {
        boolean locked = false;
        try {
            locked = this.readLock.tryLock();
            Set<Integer> set = this.cache.getItilSlavesLinkedTo(itilMasterID);
            return set;
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        ConnectionFactory conFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        return conFactory.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getItilMasterOf(int ticketId) {
        boolean locked = false;
        try {
            locked = this.readLock.tryLock();
            Integer n = this.cache.getItilMasterOf(ticketId);
            return n;
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }
}

