/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.UserReadOnly;
import javax.annotation.Nonnull;
import srv.controller.ticket.attributes.User;

public class UserModelAdapter
implements UserReadOnly {
    private final User hdUser;

    public UserModelAdapter(User hdUser) {
        if (hdUser == null) {
            throw new IllegalArgumentException("hdUser must not be null");
        }
        this.hdUser = hdUser;
    }

    @Override
    @Nonnull
    public String getUserName() {
        String value = this.getValue(Field.USERDATA_USERNAME, String.class);
        if (value != null) {
            return value.toString();
        }
        throw new NullPointerException("UserName is null");
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        String value = this.getValue(Field.USERDATA_DISPLAYNAME, String.class);
        if (value != null) {
            return value.toString();
        }
        throw new NullPointerException("DisplayName is null");
    }

    @Override
    public int getUserID() {
        Integer value = this.getValue(Field.USERDATA_USERID, Integer.class);
        if (value != null) {
            return value;
        }
        throw new NullPointerException("UserID is null");
    }

    @Override
    public <T> T getValue(Field field, Class<T> dataClass) {
        return (T)this.getValue(field);
    }

    private Object getValue(Field field) {
        switch (field) {
            case USERDATA_USERID: {
                return this.hdUser.getUsrID();
            }
            case USERDATA_USERNAME: {
                return this.hdUser.getUsername();
            }
            case USERDATA_FIRSTNAME: {
                return this.hdUser.getVorname();
            }
            case USERDATA_LASTNAME: {
                return this.hdUser.getNachname();
            }
            case USERDATA_COMPUTERNAME: {
                return this.hdUser.getComputername();
            }
            case USERDATA_LANGUAGE: {
                return this.hdUser.getSprache();
            }
            case USERDATA_DISPLAYNAME: {
                return this.createDisplayName();
            }
            case USERDATA_EMAIL: {
                String[] allEmailAddresses = this.hdUser.getAllEmailAddresses();
                if (allEmailAddresses != null && allEmailAddresses.length > 0) {
                    return allEmailAddresses;
                }
                return null;
            }
            case USERDATA_LOCATION: {
                LocationVO location = this.hdUser.getLocation();
                if (location != null) {
                    return location.getId();
                }
                return null;
            }
            case USERDATA_LOCATION_DISPLAYNAME: {
                LocationVO geb = this.hdUser.getLocation();
                if (geb != null) {
                    return geb.getDisplayValue();
                }
                return null;
            }
            case USERDATA_GROUP: {
                UserClassVO benutzergruppe = this.hdUser.getBenutzergruppe();
                if (benutzergruppe != null) {
                    return benutzergruppe.getId();
                }
                return null;
            }
            case USERDATA_GROUP_DISPLAYNAME: {
                UserClassVO bgr = this.hdUser.getBenutzergruppe();
                if (bgr != null) {
                    return bgr.getDisplayValue();
                }
                return null;
            }
        }
        return null;
    }

    private String createDisplayName() {
        String firstName = this.getValue(Field.USERDATA_FIRSTNAME, String.class);
        String lastName = this.getValue(Field.USERDATA_LASTNAME, String.class);
        if (firstName != null && lastName != null && firstName.length() > 0 && lastName.length() > 0) {
            return firstName + " " + lastName;
        }
        if (lastName != null && lastName.trim().length() > 0) {
            return lastName;
        }
        return this.getUserName();
    }
}

