/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.resource.Resource;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ImageScaler;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.SuppressFBWarnings;

public class ImagesConnectorImpl
implements ImagesConnector {
    @Override
    public URL getMimetypeImageByFileName(String filename, int size) {
        return this.resolveImageURL("mimetypes/" + MimeTypeMapper.getImageByFilename(filename, size), size);
    }

    @Override
    public URL getMimetypeImage(String mimetype, int size) {
        return this.resolveImageURL("mimetypes/" + MimeTypeMapper.getImageByMimetype(mimetype, size), size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public URL getDataImage(int typeID, String key, int size) {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        ServerValuesConnector serverValuesConnector = (ServerValuesConnector)serverPluginManager.getSingleInstance(ServerValuesConnector.class);
        Resource entry = new Resource(typeID, -1, null, 0, 0);
        entry.setStringKey(key);
        try {
            entry.setId(Integer.parseInt(key));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (typeID == 1) {
            UserGroupInfo resource;
            if (entry.getId() == -1 && !StringFunctions.isEmpty((String)entry.getStringKey())) {
                try {
                    entry.setId(HDUsersAndGroups.getResourceId(GUID.valueOf((String)entry.getStringKey())));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((resource = HDUsersAndGroups.getResource(entry.getId())) == null) {
                return null;
            }
            entry.setDeleted(!resource.isActive());
            boolean readable = true;
            UserAccount account = UserManager.getInstance().getCurrentUserAccount();
            if (account != null) {
                int userIdInt = HDUsersAndGroups.getUserID(account);
                entry.setWriteable(serverValuesConnector.isResourceWritable(entry.getId(), userIdInt, 0));
                boolean isDispacher = SystemPermissionChecker.checkAccess((Permission)HdPermissions.DISPATCHER);
                int[] memberRes = this.getResources(userIdInt, isDispacher);
                if (memberRes != null) {
                    readable = false;
                    for (int memberRe : memberRes) {
                        if (memberRe != entry.getId()) continue;
                        readable = true;
                    }
                }
            }
            entry.setReadable(readable);
        } else if (typeID == 5) {
            LocationVO location = (LocationVO)LocationManager.getInstance().get(entry.getId());
            if (location == null) {
                if (entry.getId() != -1) return null;
                entry.setDeleted(true);
            } else if (location.isDeleted()) {
                entry.setDeleted(true);
            }
        } else if (typeID == 6) {
            UserClassVO usergroup = (UserClassVO)UserClassManager.getInstance().get(entry.getId());
            if (usergroup == null) {
                return null;
            }
            if (usergroup.isDeleted()) {
                entry.setDeleted(true);
            }
        }
        String nodeImageName = serverValuesConnector.getNodeImageName(entry);
        if (nodeImageName != null && nodeImageName.length() != 0) return this.resolveImageURL(nodeImageName, size);
        return null;
    }

    private int[] getResources(int usrid, boolean allResources) {
        return ResourceManager.getInstance().getResources(HDUsersAndGroups.getUserAccount(usrid), allResources);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN"}, justification="Images are read from defined local locations. Relative path are defined in code.")
    public URL resolveImageURL(String relativePath, int size) {
        if (StringFunctions.isEmpty((String)relativePath)) return null;
        if (relativePath.contains("..")) {
            return null;
        }
        URL urlToServe = null;
        try {
            urlToServe = new URL(relativePath);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file;
                if (urlToServe == null) {
                    urlToServe = TicketValuesImageResolver.getInstance().resolveDataImage(relativePath, size);
                }
                if (urlToServe != null) return urlToServe;
                try {
                    file = new File(AppDataLocation.getClientImageDirectoryPath().toFile(), relativePath);
                    if (!file.isFile()) {
                        file = new File(AppDataLocation.getBaseLocationPath().toFile(), relativePath);
                    }
                }
                catch (Exception exc) {
                    file = null;
                }
                if (file != null && file.isFile()) {
                    urlToServe = file.toURI().toURL();
                } else {
                    String resPath = "com/inet/helpdesk/images/" + relativePath;
                    urlToServe = this.getClass().getClassLoader().getResource(resPath);
                    if (urlToServe != null && urlToServe.toString().endsWith("/")) {
                        urlToServe = null;
                    }
                    if (urlToServe == null) {
                        LogManager.getApplicationLogger().debug((Object)("Image not found: " + relativePath));
                    }
                }
                if (urlToServe == null) return urlToServe;
                if (size == 16) return urlToServe;
                try (InputStream inputStream = urlToServe.openStream();){
                    ImageScaler.ImageScalerResult result = ImageScaler.scale((InputStream)inputStream, (int)size);
                    if (result == null) return urlToServe;
                    if (result.getImageData() == null) return urlToServe;
                    URL uRL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(result.getImageData()) + (result.isScaled() ? "#scaled" : ""));
                    return uRL;
                }
                catch (Throwable t) {
                    HDLogger.error(t);
                    return urlToServe;
                }
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
            return urlToServe;
        }
    }

    @Override
    public URL getDeviceTypeImage(int deviceID, int size) {
        AssetTypeVO assetType = (AssetTypeVO)AssetTypeManager.getInstance().get(deviceID);
        if (assetType != null) {
            String image = assetType.getSymbol();
            if (image == null) {
                return null;
            }
            return this.resolveImageURL(image, size);
        }
        return null;
    }

    @Override
    public URL getFieldTypeImage(String fieldType, int size) {
        if (fieldType == null) {
            return null;
        }
        if ((fieldType = fieldType.toLowerCase().trim()).length() == 0) {
            return null;
        }
        URL urlToServe = null;
        String addSizeToName = this.addSizeToName(fieldType, size);
        String resPath = "com/inet/helpdesk/images/fieldtypes/" + addSizeToName;
        urlToServe = this.getClass().getClassLoader().getResource(resPath);
        if (urlToServe != null && urlToServe.toString().endsWith("/")) {
            urlToServe = null;
        }
        if (urlToServe == null) {
            LogManager.getApplicationLogger().debug((Object)("Image not found: " + addSizeToName));
        }
        return urlToServe;
    }

    private String addSizeToName(String name, int size) {
        if (size <= 16) {
            return name + "_16.png";
        }
        if (size <= 32) {
            return name + "_32.png";
        }
        if (size <= 64) {
            return name + "_64.png";
        }
        return name + "_128.png";
    }

    private static enum MimeTypeMapper {
        apk(""),
        avi("video/x-msvideo"),
        bmp("image/bmp", "image/x-bmp", "image/x-ms-bmp"),
        cfg(""),
        conf(""),
        css("text/css"),
        csv("text/comma-separated-values"),
        doc("application/msword"),
        docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
        dot(""),
        eml(""),
        file("application/x-unknown"),
        gif("image/gif"),
        gz("application/gzip"),
        htm("text/html"),
        html(""),
        ini("application/octet-stream"),
        ipa(""),
        iso(""),
        jar("application/java-archive"),
        java("application/x-java-jnlp-file"),
        jnlp(""),
        jpeg(""),
        jpg("image/jpeg"),
        js("application/javascript"),
        json("application/json"),
        less(""),
        log(""),
        mim("message/rfc822"),
        mp3("audio/mpeg"),
        mp4("audio/mp4", "video/mp4"),
        mpeg("video/mpeg"),
        msg(""),
        odp("application/vnd.oasis.opendocument.presentation"),
        ods("application/vnd.oasis.opendocument.spreadsheet"),
        ogg("audio/ogg"),
        ogv("video/ogg"),
        pdf("application/pdf"),
        php("application/x-httpd-php"),
        pl(""),
        png("image/png"),
        ppt("application/mspowerpoint"),
        pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
        properties(""),
        ps("application/postscript"),
        rar("application/x-rar-compressed", "application/x-rar", "application/rar"),
        rpt(""),
        rtf("application/rtf"),
        svg("image/svg+xml"),
        sql(""),
        tar("application/x-tar"),
        tex("application/x-latex"),
        tgz(""),
        tif("image/tiff"),
        tiff(""),
        txt("text/plain"),
        vcf("text/x-vcard"),
        wav("audio/wav"),
        weba("audio/webm"),
        webm("video/webm"),
        webp("image/webp"),
        xls("application/vnd.ms-excel"),
        xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
        xml("text/xml"),
        zip("application/x-zip-compressed", "application/zip", "multipart/x-zip");

        private static final HashMap<String, String> EXTENSION_MAP;
        private HashSet<String> mimetypes = new HashSet();

        private MimeTypeMapper(String ... mimetypes) {
            if (mimetypes != null) {
                for (String mimetype : mimetypes) {
                    this.mimetypes.add(mimetype);
                }
            }
        }

        private static String getDefaultFileIcon(int size) {
            if (size <= 16) {
                return "file_16.png";
            }
            if (size <= 32) {
                return "file_32.png";
            }
            if (size <= 64) {
                return "file_64.png";
            }
            return "file_128.png";
        }

        private static String getImageByMimetype(String mimetype, int size) {
            if (mimetype == null) {
                return MimeTypeMapper.getDefaultFileIcon(size);
            }
            if ((mimetype = mimetype.trim()).length() == 0) {
                return MimeTypeMapper.getDefaultFileIcon(size);
            }
            for (MimeTypeMapper ext : MimeTypeMapper.values()) {
                if (!ext.mimetypes.contains(mimetype)) continue;
                if (size <= 16) {
                    return ext.name() + "_16.png";
                }
                if (size <= 32) {
                    return ext.name() + "_32.png";
                }
                if (size <= 64) {
                    return ext.name() + "_64.png";
                }
                return ext.name() + "_128.png";
            }
            return MimeTypeMapper.getDefaultFileIcon(size);
        }

        private static String getImageByFilename(String filename, int size) {
            if (filename == null) {
                return MimeTypeMapper.getDefaultFileIcon(size);
            }
            if ((filename = filename.toLowerCase().trim()).length() == 0) {
                return MimeTypeMapper.getDefaultFileIcon(size);
            }
            try {
                String mappedExt;
                String ext = "file";
                int index = filename.lastIndexOf(46);
                if (index > 0 && index < filename.length() - 1) {
                    ext = filename.substring(index + 1);
                }
                if ((mappedExt = EXTENSION_MAP.get(ext)) != null) {
                    ext = mappedExt;
                }
                if (size <= 16) {
                    return MimeTypeMapper.valueOf(ext).name() + "_16.png";
                }
                if (size <= 32) {
                    return MimeTypeMapper.valueOf(ext).name() + "_32.png";
                }
                if (size <= 64) {
                    return MimeTypeMapper.valueOf(ext).name() + "_64.png";
                }
                return MimeTypeMapper.valueOf(ext).name() + "_128.png";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return MimeTypeMapper.getDefaultFileIcon(size);
            }
        }

        static {
            EXTENSION_MAP = new HashMap<String, String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("properties", "prop");
                    this.put("latex", "tex");
                }
            };
        }
    }
}

