/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.shared.communication.DbWriter;
import com.inet.helpdesk.shared.model.user.UserDataSet;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import srv.HdLicenseObserver;

public class DbWriterImpl
extends ProxyPacketHandler
implements DbWriter {
    protected static final String UPDATE_MEMBERSHIP_User_COMMAND = "SELECT * FROM tblRessourcenUser WHERE UsrID = ?";
    protected static final String UPDATE_LABEL_SETTINGS = "UPDATE tblSprachLabels SET LabelText = ? WHERE SetID =? AND SprID = ?";

    @Override
    public UserDataSet writeUserData(UserDataSet data, String computerName, Integer sessionId) throws IOException {
        UserAccount userAccount;
        UserManager userManager = UserManager.getInstance();
        if (data.getUsrId() != -1) {
            userAccount = HDUsersAndGroups.getUserAccount(data.getUsrId());
            if (userAccount == null) {
                throw new IOException("user data not available");
            }
            if (UserManager.MASTER_ACCOUNT_ID.equals((Object)userAccount.getID()) || UserAccountType.Guest.equals((Object)userAccount.getAccountType()) || UserAccountType.Temp.equals((Object)userAccount.getAccountType())) {
                this.readUserDataFromAccount(userAccount, data);
                return data;
            }
            this.writeUserDataToUserAccount(data, userAccount.getID(), userManager);
        } else {
            int currentUserCount = HdLicenseObserver.getCurrentActiveUserCount();
            if (currentUserCount >= 0 && (HdLicenseObserver.getMaxUsers() == -1 || HdLicenseObserver.getMaxUsers() > currentUserCount)) {
                MutableUserData userData = this.getMutableUserDataForUser(data);
                String username = data.getUsername();
                if (username != null && !username.trim().isEmpty()) {
                    LoginSettings login = new LoginSettings("system", username, null);
                    userAccount = userManager.createUserAccount(UserAccountType.Standard, userData, login);
                } else {
                    userAccount = userManager.createUserAccount(UserAccountType.Standard, userData);
                }
                data.setUsrId(HDUsersAndGroups.getUserID(userAccount));
                this.writeUserDataToUserAccount(data, userAccount.getID(), userManager);
            } else {
                throw new IOException("license check failed - current user count " + currentUserCount);
            }
        }
        userAccount = HDUsersAndGroups.getUserAccount(data.getUsrId());
        this.readUserDataFromAccount(userAccount, data);
        return data;
    }

    private void readUserDataFromAccount(UserAccount userAccount, UserDataSet data) {
        data.setUsrId(HDUsersAndGroups.getUserID(userAccount));
        data.setDeleted(!userAccount.isActive());
        data.setUsername(userAccount.getDisplayName());
        data.setUsergroupId((Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID));
        data.setLocationId((Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
        data.setLastname((String)userAccount.getValue((UserField)UsersAndGroups.FIELD_LASTNAME));
        data.setFirstname((String)userAccount.getValue((UserField)UsersAndGroups.FIELD_FIRSTNAME));
        data.setEmail((String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
        data.setTelefon((String)userAccount.getValue((UserField)UsersAndGroups.FIELD_TELEPHONE));
        data.setDepartment((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_DEPARTMENT));
        data.setRoom((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_ROOM));
        data.setCostcenter((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE));
        data.setCustomizationField1((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_1));
        data.setCustomizationField2((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_2));
        data.setCustomizationField3((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_3));
        data.setCustomizationField4((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_4));
        data.setCustomizationField5((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_5));
        data.setCustomizationField6((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_6));
        data.setComputername((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_COMPUTER_NAME));
        data.setLanguageKey((String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE));
        data.setLumpSumValue1((Double)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_1));
        data.setLumpSumValue2((Double)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_2));
        data.setLumpSumValue3((Double)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_3));
    }

    private void writeUserDataToUserAccount(UserDataSet data, GUID userID, UserManager manager) {
        MutableUserData d = this.getMutableUserDataForUser(data);
        manager.updateUserData(userID, d);
        UserAccount userAccount = manager.getUserAccount(userID);
        if (data.isDeleted() && userAccount.isActive()) {
            manager.setUserAccountInactive(userID);
        }
        if (!data.isDeleted() && !userAccount.isActive()) {
            manager.setUserAccountActive(userID);
        }
    }

    private MutableUserData getMutableUserDataForUser(UserDataSet data) {
        MutableUserData d = new MutableUserData();
        this.putNotNull(d, HDUsersAndGroups.FIELD_CLASS_ID, data.getUsergroupId());
        this.putNotNull(d, HDUsersAndGroups.FIELD_LOCATION_ID, data.getLocationId());
        this.putNotNull(d, (UserField)UsersAndGroups.FIELD_LASTNAME, (Object)data.getLastname());
        this.putNotNull(d, (UserField)UsersAndGroups.FIELD_FIRSTNAME, (Object)data.getFirstname());
        this.putNotNull(d, (UserField)UsersAndGroups.FIELD_EMAIL, (Object)DbWriterImpl.normaliseEmailAddress(data));
        this.putNotNull(d, (UserField)UsersAndGroups.FIELD_TELEPHONE, (Object)data.getTelefon());
        this.putNotNull(d, HDUsersAndGroups.FIELD_DEPARTMENT, data.getDepartment());
        this.putNotNull(d, HDUsersAndGroups.FIELD_ROOM, data.getRoom());
        this.putNotNull(d, HDUsersAndGroups.FIELD_COST_CENTRE, data.getCostcenter());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_1, data.getCustomizationField1());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_2, data.getCustomizationField2());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_3, data.getCustomizationField3());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_4, data.getCustomizationField4());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_5, data.getCustomizationField5());
        this.putNotNull(d, HDUsersAndGroups.FIELD_CUSTOM_6, data.getCustomizationField6());
        this.putNotNull(d, HDUsersAndGroups.FIELD_COMPUTER_NAME, data.getComputername());
        this.putNotNull(d, HDUsersAndGroups.FIELD_LANGUAGE, data.getLanguageKey());
        this.putNotNull(d, HDUsersAndGroups.FIELD_LUMP_SUM_1, data.getLumpSumValue1());
        this.putNotNull(d, HDUsersAndGroups.FIELD_LUMP_SUM_2, data.getLumpSumValue2());
        this.putNotNull(d, HDUsersAndGroups.FIELD_LUMP_SUM_3, data.getLumpSumValue3());
        return d;
    }

    private <T> void putNotNull(MutableUserData userData, UserField<T> field, T value) {
        if (value != null) {
            userData.put(field, value);
        }
    }

    private static String normaliseEmailAddress(UserDataSet data) {
        String in = data.getEmail();
        if (in != null) {
            if (in.indexOf(32) > -1) {
                in = in.replace(" ", "");
            }
            if (in.indexOf(44) > -1) {
                in = in.replace(',', ';');
            }
        }
        return in;
    }

    @Override
    public Class<?> getRemoteInterface() {
        return DbWriter.class;
    }

    @Override
    public void changeUsersData(String field, String value, int[] usersToChange, Integer sessionId) throws IOException {
        this.changeUsersData(field, value, usersToChange, sessionId, true);
    }

    private void changeUsersData(String field, String valueAsString, int[] usersToChange, Integer sessionId, boolean isStringValue) throws IOException {
        UserField userField = (UserField)HDFieldLocator.getUserFieldForDBKey(field);
        Class valueType = userField.getValueType();
        Object value = valueAsString;
        if (!String.class.equals((Object)valueType)) {
            try {
                Method valueOf = valueType.getMethod("valueOf", String.class);
                value = valueOf.invoke(null, valueAsString);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                HDLogger.error("Could not change data of the user(s):");
                HDLogger.error(ex);
                throw new IOException("Could not change data of the user(s). See server log for more information.");
            }
        }
        MutableUserData data = new MutableUserData();
        data.put(userField, value);
        for (int userId : usersToChange) {
            GUID accountID;
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
            if (userAccount == null || UserManager.MASTER_ACCOUNT_ID.equals((Object)(accountID = userAccount.getID())) || UserAccountType.Guest.equals((Object)userAccount.getAccountType()) || UserAccountType.Temp.equals((Object)userAccount.getAccountType())) continue;
            UserManager.getInstance().updateUserData(accountID, data);
        }
    }

    @Override
    public int[] deactivateUsers(int[] usersToDeactivate, Integer sessionId) throws IOException {
        ArrayList<Integer> deactivated = new ArrayList<Integer>();
        for (int userId : usersToDeactivate) {
            GUID accountID;
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
            if (userAccount == null || UserManager.MASTER_ACCOUNT_ID.equals((Object)(accountID = userAccount.getID())) || UserAccountType.Guest.equals((Object)userAccount.getAccountType()) || UserAccountType.Temp.equals((Object)userAccount.getAccountType())) continue;
            UserManager.getInstance().setUserAccountInactive(accountID);
            deactivated.add(userId);
        }
        return deactivated.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public void updateLabelSettings(int labelKey, String text, String languageKey) throws IOException {
    }

    @Override
    public void updateSetting(int labelKey) throws IOException {
        if (labelKey == 13) {
            // empty if block
        }
    }
}

