/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.RecoveryConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.data.ImportedDeviceDeletionListener;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.data.DataImportRunner;
import com.inet.helpdesk.data.ServerDataUtil;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import srv.ServerUtilities;
import srv.automatic.GeraeteImporter;
import srv.automatic.LdapUtilities;
import srv.automatic.StringIntHashMap;
import srv.automatic.UserImporter;

public class DataImportConnectorImpl
implements DataImportConnector {
    private static final long JOB_SCHEDULE_INTERVAL_IN_MS = 1800000L;
    private static final RecoveryConfigValue<DeviceImportConfigInfoMap> DEVICE_IMPORT_CONFIG_INFO_MAP = new RecoveryConfigValue(HDConfigKeys.DEVICE_IMPORT_CONFIGS);
    private static final RecoveryConfigValue<UserImportConfigInfoMap> USER_IMPORT_CONFIG_INFO_MAP = new RecoveryConfigValue(HDConfigKeys.USER_IMPORT_CONFIGS);
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
    private static final ConfigValue<DatabaseConfigInfoList> DATABASE_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private static final String SQL_GETUSERIMPORTNAMES = "SELECT DISTINCT ImpName from tblUser";
    private static final String SQL_GETDEVICEIMPORTNAMES = "SELECT DISTINCT ImpName from tblGeraeteBestand";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", DataImportConnectorImpl.class);
    private DataImportRunner runner = new DataImportRunner();
    private static final Logger logger = LogManager.getLogger((String)"Data Import");

    @Override
    public DeviceImportConfigInfoMap getDeviceImports() {
        return (DeviceImportConfigInfoMap)DEVICE_IMPORT_CONFIG_INFO_MAP.get();
    }

    @Override
    public UserImportConfigInfoMap getUserImports() {
        return (UserImportConfigInfoMap)USER_IMPORT_CONFIG_INFO_MAP.get();
    }

    @Override
    public void saveDeviceImports(DeviceImportConfigInfoMap deviceImports) {
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey(), deviceImports.toString());
    }

    @Override
    public void saveUserImports(UserImportConfigInfoMap userImports) {
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.USER_IMPORT_CONFIGS.getKey(), userImports.toString());
    }

    @Override
    public ArrayList<ConnectionEntry> getConnections() {
        ArrayList<ConnectionEntry> entries = new ArrayList<ConnectionEntry>();
        LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
        for (Map.Entry entry : ldapConns.entrySet()) {
            entries.add(new ConnectionEntry(DataImportConnector.ConnectionType.ldap, ((LdapConnectionInfo)entry.getValue()).getName()));
        }
        DatabaseConfigInfoList dbConns = (DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get();
        for (DatabaseConfigInfo dbConnection : dbConns) {
            if ("HDS".equals(dbConnection.getDbName())) continue;
            entries.add(new ConnectionEntry(DataImportConnector.ConnectionType.database, dbConnection.getDbName()));
        }
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<String> getTables(ConnectionEntry connection) throws ServerDataException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Vector<String> vec = new Vector<String>();
            if (connection.getConnectionType() == DataImportConnector.ConnectionType.ldap) {
                LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(connection.getName());
                if (ldapConnectionInfo == null) {
                    throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
                }
                DataImportConnectorImpl.getObjectClasses(vec, ldapConnectionInfo);
            } else if (connection.getConnectionType() == DataImportConnector.ConnectionType.database) {
                Connection dbConnection = this.getDatabaseConnection(connection);
                DatabaseConfigInfo databaseConfigInfo = ((DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get()).get(connection.getName());
                DataImportConnectorImpl.getTables(dbConnection, databaseConfigInfo, vec);
                if (vec.isEmpty()) {
                    ResultSet rs = dbConnection.getMetaData().getProcedures(null, null, null);
                    while (rs.next()) {
                        vec.add("Procedure: " + rs.getString("PROCEDURE_NAME"));
                    }
                }
            }
            for (Object e : vec) {
                list.add(e.toString());
            }
        }
        catch (SQLException | NamingException e) {
            void var5_11;
            String message = e.getMessage() == null ? "" : e.getMessage();
            Throwable throwable = e.getCause();
            while (var5_11 != null) {
                message = var5_11.getMessage();
                Throwable throwable2 = var5_11.getCause();
            }
            throw new ServerDataException(message, e);
        }
        return list;
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="Internal API structure")
    public static void getObjectClasses(Vector<String> data, LdapConnectionInfo ldapConnectionInfo) throws NamingException {
        InitialLdapContext ctx = LdapUtilities.getDirContext(ldapConnectionInfo);
        String[] searchContextValues = LdapUtilities.getSearchContext(ctx, ldapConnectionInfo.getSearchContext());
        StringIntHashMap hm = new StringIntHashMap();
        Attributes attrs = null;
        for (String searchContext : searchContextValues) {
            boolean searchSuccess;
            NamingEnumeration<SearchResult> enumeration = ctx.search(searchContext, "objectClass=*", LdapUtilities.getSearchControls(new String[]{"objectClass"}));
            try {
                searchSuccess = enumeration.hasMore();
            }
            catch (NamingException ex) {
                searchSuccess = false;
            }
            while (searchSuccess) {
                SearchResult si = (SearchResult)enumeration.nextElement();
                attrs = si.getAttributes();
                Attribute objKlasse = attrs.get("objectClass");
                if (objKlasse != null) {
                    int attributeCount = objKlasse.size();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attrValue = attrs.get("objectClass").get(i).toString();
                        if (attrValue.equals("top") || attrValue.equals("person")) continue;
                        hm.putCounter(attrValue);
                    }
                }
                try {
                    searchSuccess = enumeration.hasMore();
                }
                catch (NamingException ex) {
                    searchSuccess = false;
                }
            }
            try {
                enumeration.close();
            }
            catch (NamingException e) {
                logger.error((Throwable)e);
            }
        }
        try {
            ctx.close();
        }
        catch (NamingException e) {
            logger.error((Throwable)e);
        }
        Vector<String> counterVec = new Vector<String>();
        DataImportConnectorImpl.sortElements(hm, data, counterVec);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Table name is quoted")
    public static void getColumns(Connection conlocal, Vector<String> vec, String tabelle) throws SQLException {
        StringIntHashMap hm = new StringIntHashMap();
        String sql = "Select * From " + conlocal.getMetaData().getIdentifierQuoteString() + tabelle + conlocal.getMetaData().getIdentifierQuoteString();
        Statement st = conlocal.createStatement();
        ResultSet rs = st.executeQuery(sql);
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            hm.putCounter(rsMeta.getColumnName(i));
        }
        try {
            rs.close();
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            st.close();
        }
        catch (Throwable i) {
            // empty catch block
        }
        Vector<String> counterVec = new Vector<String>();
        DataImportConnectorImpl.sortElements(hm, vec, counterVec);
    }

    private static void getTables(Connection conlocal, DatabaseConfigInfo dbInfo, Vector<String> vec) throws SQLException {
        String table;
        String schema = null;
        String catalog = null;
        if (dbInfo != null) {
            switch (dbInfo.getDriver()) {
                case inetora: {
                    schema = dbInfo.getUser();
                    break;
                }
                case inetdae7: {
                    catalog = conlocal.getCatalog();
                    break;
                }
                case mysql: 
                case mariadb: {
                    catalog = conlocal.getCatalog();
                    break;
                }
                case odbc: {
                    break;
                }
                default: {
                    catalog = conlocal.getCatalog();
                    schema = conlocal.getSchema();
                }
            }
        }
        String[] types = new String[]{"TABLE", "VIEW"};
        DatabaseMetaData dbmd = conlocal.getMetaData();
        HDLogger.info("DatabaseMetaData " + dbmd.getDatabaseProductName() + "-" + dbmd.getDatabaseProductVersion() + "-" + dbmd.getDriverName() + "-" + dbmd.getDriverVersion());
        ResultSet tables = dbmd.getTables(catalog, schema, null, types);
        HDLogger.info("DatabaseMetaData.getTables " + catalog + " " + schema);
        if (!tables.next()) {
            try {
                tables.close();
            }
            catch (Throwable e) {
                HDLogger.debug(e);
            }
            HDLogger.debug("No tables");
            tables = conlocal.getMetaData().getTables(catalog, schema, null, null);
        } else {
            table = tables.getString(3);
            HDLogger.info("Table: " + table);
            vec.addElement(table);
        }
        while (tables.next()) {
            table = tables.getString(3);
            HDLogger.info("Table: " + table);
            vec.addElement(table);
        }
        HDLogger.info("Number of tables " + vec.size());
        try {
            tables.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Connection getDatabaseConnection(ConnectionEntry connection) throws SQLException, ServerDataException {
        DatabaseConfigInfo dbInfo = ((DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get()).get(connection.getName());
        if (dbInfo == null) {
            throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
        }
        return UserImporter.getConnection(dbInfo);
    }

    @Override
    public synchronized DataImportConnector.ColumnsOrAttributes getColumns(ConnectionEntry connection, String tableName, boolean useUserSyntax, String userSyntax) throws ServerDataException {
        long start = System.currentTimeMillis();
        boolean picturesAvailable = false;
        boolean hideFromAddressListsAvailable = false;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            Vector<String> vec = new Vector<String>();
            if (connection != null) {
                if (connection.getConnectionType() == DataImportConnector.ConnectionType.ldap) {
                    LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(connection.getName());
                    if (ldapConnectionInfo == null) {
                        throw new ServerDataException(new Exception(MSG.getMsg("dataImport.noConnectionFound", new Object[]{connection.getName()})));
                    }
                    UserImporter.getLdapAttributs(vec, ldapConnectionInfo, tableName, useUserSyntax, userSyntax);
                    picturesAvailable = vec.remove("jpegPhoto") || vec.remove("thumbnailPhoto");
                    hideFromAddressListsAvailable = vec.contains("msExchHideFromAddressLists");
                } else if (connection.getConnectionType() == DataImportConnector.ConnectionType.database) {
                    Connection dbConnection = this.getDatabaseConnection(connection);
                    if (tableName.startsWith("Procedure: ")) {
                        String procedureName = tableName.substring("Procedure: ".length());
                        ResultSet rs = dbConnection.getMetaData().getProcedureColumns(null, null, procedureName, null);
                        while (rs.next()) {
                            vec.add(rs.getString("COLUMN_NAME"));
                        }
                    } else {
                        DataImportConnectorImpl.getColumns(dbConnection, vec, tableName);
                    }
                }
                columns.addAll(vec);
            }
        }
        catch (SQLException | NamingException e) {
            throw new ServerDataException(e);
        }
        logger.debug((Object)("Column request: " + (System.currentTimeMillis() - start) + "ms"));
        DataImportConnector.ColumnsOrAttributes result = new DataImportConnector.ColumnsOrAttributes();
        result.setColumnsOrAttributes(columns);
        result.setContainsPicturAttribute(picturesAvailable);
        result.setContainsHideFromAddressListsAttribute(hideFromAddressListsAvailable);
        return result;
    }

    public static void sortElements(StringIntHashMap hm, Vector<String> names, Vector<String> counts) {
        int i;
        int size = hm.size();
        int pos = 0;
        String[][] all = new String[size + 1][3];
        hm.moveToStart();
        while (hm.hasMore()) {
            String theKey = hm.getCurrentKey();
            all[pos][0] = theKey.toLowerCase();
            all[pos][1] = theKey;
            all[pos][2] = String.valueOf(hm.getCurrentValue());
            ++pos;
        }
        for (i = 0; i < size - 1; ++i) {
            for (int n = i + 1; n < size; ++n) {
                if (all[i][0].compareTo(all[n][0]) <= 0) continue;
                for (int z = 0; z < 3; ++z) {
                    all[size][z] = all[i][z];
                    all[i][z] = all[n][z];
                    all[n][z] = all[size][z];
                }
            }
        }
        for (i = 0; i < size; ++i) {
            names.addElement(all[i][1]);
            counts.addElement(all[i][2]);
        }
    }

    @Override
    public void startDeviceImport(DeviceImportConfigInfo deviceConfig, String importName, ConnectionEntry connection) {
        this.runner.executeJob(deviceConfig, importName, connection);
    }

    @Override
    public void startUserImport(UserImportConfigInfo userConfig, String importName, ConnectionEntry connection) {
        this.runner.executeJob(userConfig, importName, connection);
    }

    @Override
    public DataImportJob createJob(String uid) {
        return this.runner.createJob(uid);
    }

    @Override
    public ArrayList<DataImportJob> getJobs(String uid) {
        return this.runner.getJobs(uid);
    }

    @Override
    public List<Map<String, String>> getExamples(DeviceImportConfigInfo dici, String importName) throws ServerDataException {
        try {
            GeraeteImporter.SampleInvoker sampleInvoker = new GeraeteImporter.SampleInvoker();
            DataImportJob job = new DataImportJob();
            new GeraeteImporter(dici, importName, sampleInvoker, job);
            if (job.getError() != null && !job.getError().isEmpty()) {
                throw new ServerDataException(new Exception(job.getError()));
            }
            if (job.getEntriesMissingReference() > 0 && job.getEntriesMissingReference() == job.getEntriesCount()) {
                throw new ServerDataException(new Exception(MSG.getMsg("error.missingNameReference", new Object[0])));
            }
            return sampleInvoker.getResult();
        }
        catch (Exception innerEx) {
            try {
                throw innerEx;
            }
            catch (Exception e) {
                throw new ServerDataException(e);
            }
        }
    }

    @Override
    public List<Map<String, String>> getExamples(UserImportConfigInfo uici) throws ServerDataException {
        UserImporter.ReadRecordStateWithSamples readRecordStateWithSamples;
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get();
        DataImportJob job = new DataImportJob();
        if (uici.isLdap()) {
            LdapConnectionInfo ldapConnectionInfo = ((LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get()).get(uici.getConnectionName());
            readRecordStateWithSamples = (UserImporter.ReadRecordStateWithSamples)new UserImporter(uici).runForLdap(job, new UserImporter.ReadSampleRecordStateFactory(), ldapConnectionInfo);
        } else {
            DatabaseConfigInfo dbConn = list.get(uici.getConnectionName());
            readRecordStateWithSamples = (UserImporter.ReadRecordStateWithSamples)new UserImporter(uici).runForSqlDb(job, new UserImporter.ReadSampleRecordStateFactory(), dbConn);
        }
        if (job.getEntriesError() > 0) {
            logger.warn((Object)("had " + job.getEntriesError() + " issues while importing!"));
        }
        if (job.getError() != null && !job.getError().isEmpty()) {
            throw new ServerDataException(new Exception(job.getError()));
        }
        if (job.getEntriesMissingReference() > 0 && job.getEntriesMissingReference() == job.getEntriesCount()) {
            throw new ServerDataException(new Exception(MSG.getMsg("dataImport.userImport.noUserReference", new Object[0])));
        }
        return readRecordStateWithSamples == null ? null : readRecordStateWithSamples.getSamples();
    }

    @Override
    public boolean isTimeForJob(String uid, DataImportSchedule schedule, Calendar currentCal) {
        ArrayList<DataImportJob> jobs = this.getJobs(uid);
        long timeLastRun = 0L;
        for (DataImportJob job : jobs) {
            timeLastRun = Math.max(timeLastRun, job.getStartTime());
        }
        int endHour = schedule.getEndHour();
        int hourOfDay = schedule.getHourOfDay();
        int startHour = schedule.getStartHour();
        DataImportSchedule.MainTimeOption mainOption = schedule.getMainOption();
        DataImportSchedule.SubTimeOption subOption = schedule.getSubOption();
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(currentCal.getTimeInMillis());
        switch (mainOption) {
            case MANUAL: {
                return false;
            }
            case WEEKLY: {
                startCal.set(7, (1 + subOption.ordinal()) % 7 + 1);
                startCal.set(11, hourOfDay);
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case DAILY: {
                startCal.set(11, hourOfDay);
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case HOURLY: {
                if (startHour <= endHour) {
                    if (startCal.get(11) < startHour && startHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                } else {
                    if (startCal.get(11) > startHour && startHour > 0 && startCal.get(11) < endHour && endHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) < startHour && startHour > 0 && startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                }
                startCal.set(12, 0);
                startCal.set(13, 0);
                break;
            }
            case HALFHOUR: {
                if (startHour <= endHour) {
                    if (startCal.get(11) < startHour && startHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                } else {
                    if (startCal.get(11) > startHour && startHour > 0 && startCal.get(11) < endHour && endHour > 0) {
                        return false;
                    }
                    if (startCal.get(11) < startHour && startHour > 0 && startCal.get(11) >= endHour && endHour > 0) {
                        return false;
                    }
                }
                startCal.set(12, startCal.get(12) >= 30 ? 30 : 0);
                startCal.set(13, 0);
            }
        }
        if (timeLastRun > startCal.getTimeInMillis()) {
            return false;
        }
        long timeSinceStart = currentCal.getTimeInMillis() - startCal.getTimeInMillis();
        return timeSinceStart > 0L && timeSinceStart < 1800000L;
    }

    @Override
    public HashSet<String> getUserImportNamesFromDatabase() throws ServerDataException {
        HashSet<String> importNames = new HashSet<String>();
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = connectionFactory.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(SQL_GETUSERIMPORTNAMES);
            while (rs.next()) {
                String impName = rs.getString(1);
                if (impName == null || impName.length() <= 0) continue;
                importNames.add(impName);
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataUtil.closeAll(con, st, rs);
                throw throwable;
            }
        }
        ServerDataUtil.closeAll(con, st, rs);
        return importNames;
    }

    @Override
    public HashSet<String> getDeviceImportNamesFromDatabase() throws ServerDataException {
        HashSet<String> importNames = new HashSet<String>();
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = connectionFactory.getConnection();
            st = con.createStatement();
            rs = st.executeQuery(SQL_GETDEVICEIMPORTNAMES);
            while (rs.next()) {
                String impName = rs.getString(1);
                if (impName == null || impName.length() <= 0) continue;
                importNames.add(impName);
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataUtil.closeAll(con, st, rs);
                throw throwable;
            }
        }
        ServerDataUtil.closeAll(con, st, rs);
        return importNames;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Parameter is only Integer")
    public void deleteDevicesFromImport(String importName) throws ServerDataException {
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            AssetManager manager = AssetManager.getInstance();
            IndexSearchEngine searchEngine = manager.getSearchEngine();
            Set guids = searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getEntrySearchKey(), SearchCondition.SearchTermOperator.Equals, (Object)importName)}));
            List<Integer> intIds = guids.stream().map(arg_0 -> ((AssetManager)manager).getAsset(arg_0)).filter(Objects::nonNull).map(a -> a.getIntID()).collect(Collectors.toList());
            guids.forEach(g -> manager.maintenance().physicallyDeleteDevice(g));
            ServerPluginManager spm = ServerPluginManager.getInstance();
            for (ImportedDeviceDeletionListener listener : spm.get(ImportedDeviceDeletionListener.class)) {
                listener.devicesDeleted(intIds);
            }
            ServerUtilities.conti.setChanged(15, true);
        }
    }
}

