/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils.sql;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.SuppressFBWarnings;

public class ResultSetIterator<T>
implements Iterator<T> {
    private static final int FETCHSIZE = 10000;
    private ConnectionFactory connectionFactory;
    private ResultSet rs;
    private PreparedStatement st;
    private Connection con;
    private T currentValue;
    private String sql;
    private int min;
    private int max;
    private final boolean ascending;
    private SqlFunction<ResultSet, T> entryFactory;
    private boolean next;

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public static <T> ResultSetIterator<T> create(ConnectionFactory connectionFactory, String minMaxSql, String sql, SqlFunction<ResultSet, T> entryFactory) {
        try {
            int min = 0;
            int max = 0;
            Connection con = connectionFactory.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(minMaxSql);
            if (rs.next()) {
                min = rs.getInt(1);
                max = rs.getInt(2);
            }
            rs.close();
            st.close();
            con.close();
            return new ResultSetIterator<T>(connectionFactory, sql, min, max, entryFactory);
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    public ResultSetIterator(ConnectionFactory connectionFactory, String sql, int min, int max, SqlFunction<ResultSet, T> entryFactory) {
        this.connectionFactory = connectionFactory;
        this.sql = sql;
        if (min <= max) {
            this.min = min;
            this.max = max;
            this.ascending = true;
        } else {
            this.min = max;
            this.max = min;
            this.ascending = false;
        }
        this.entryFactory = entryFactory;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.next = false;
            return this.currentValue;
        }
        throw new NoSuchElementException();
    }

    private void nextResultSet() throws SQLException {
        if (this.ascending) {
            this.st.setInt(1, this.min);
            this.st.setInt(2, this.min + 10000 - 1);
            this.min += 10000;
        } else {
            this.st.setInt(1, this.max - 10000 + 1);
            this.st.setInt(2, this.max);
            this.max -= 10000;
        }
        this.rs = this.st.executeQuery();
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public boolean hasNext() {
        if (this.next) {
            return true;
        }
        try {
            while (this.min <= this.max || this.rs != null) {
                if (this.con == null) {
                    this.con = this.connectionFactory.getConnection();
                    this.st = this.con.prepareStatement(this.sql);
                }
                if (this.rs == null) {
                    this.nextResultSet();
                }
                this.next = this.rs.next();
                if (this.next) {
                    this.currentValue = this.entryFactory.apply(this.rs);
                    return true;
                }
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rs = null;
            }
        }
        catch (SQLException ex) {
            HDLogger.error("min: " + this.min + ", max: " + this.max + ", currentValue: " + String.valueOf(this.currentValue) + ", sql: " + this.sql);
            HDLogger.error(ex);
            this.finalize();
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        this.finalize();
        return false;
    }

    public void finalize() {
        try {
            this.rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.st.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface SqlFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

