/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketview.standardviews.SharedWithMeTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SupervisorTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class GlobalSearchViewDefinition
implements TicketViewFactory {
    public static final String KEY = "globalticketsearch";
    public static final GlobalSearchViewDefinition INSTANCE = new GlobalSearchViewDefinition();

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalsearch";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/ticketsearch.png");
    }

    @Override
    @Nonnull
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale, IndexSearchEngine<Integer> engine) {
        OrSearchExpression topOr = GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, locale);
        if (topOr == null) {
            return new SearchCommand(locale, new SearchExpression[0]);
        }
        return new SearchCommand(locale, new SearchExpression[]{topOr});
    }

    @Nullable
    public static OrSearchExpression getGlobalSearchExpressionForAllVisibleTickets(GUID accountID, Locale locale) {
        SearchExpression searchExpression = GlobalSearchViewDefinition.getGlobalSearchExpressionWithoutAdditionaSharings(accountID, locale);
        if (searchExpression == null) {
            return null;
        }
        OrSearchExpression topOr = new OrSearchExpression();
        topOr.add((Object)searchExpression);
        topOr.add((Object)SharedWithMeTicketViewDefinition.getSharedTickets(accountID));
        return topOr;
    }

    @Nullable
    public static SearchExpression getGlobalSearchExpressionWithoutAdditionaSharings(@Nonnull GUID accountID, @Nonnull Locale locale) {
        try (UserAccountScope scape = UserAccountScope.create((GUID)accountID);){
            AndSearchExpression searchExpression;
            boolean isDispatcher = SystemPermissionChecker.checkAccess((Permission)HdPermissions.DISPATCHER);
            if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ)) {
                if (isDispatcher) {
                    SearchExpression searchExpression2 = null;
                    return searchExpression2;
                }
                SearchCondition searchCondition = new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.StartsWith, (Object)"");
                return searchCondition;
            }
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            AndSearchExpression supervisor = SupervisorTicketViewDefinition.createSearchExpression(accountID, locale);
            if (!isDispatcher && resources.size() == 0) {
                AndSearchExpression and = new AndSearchExpression();
                and.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                CustomTicketViewDefinition.addCondition_forEndUserFromTicketNumber(accountID, and);
                if (supervisor != null) {
                    OrSearchExpression or = new OrSearchExpression();
                    or.add((Object)and);
                    or.add((Object)supervisor);
                    searchExpression = or;
                } else {
                    searchExpression = and;
                }
            } else {
                OrSearchExpression or = new OrSearchExpression();
                or.add((Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                if (isDispatcher) {
                    or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{0, 99}));
                    or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, null));
                }
                if (resources.size() > 0) {
                    or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources));
                }
                if (supervisor != null) {
                    or.add((Object)supervisor);
                }
                if (isDispatcher) {
                    searchExpression = or;
                } else {
                    AndSearchExpression and = new AndSearchExpression();
                    and.add((SearchExpression)or);
                    and.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null)));
                    searchExpression = and;
                }
            }
            AndSearchExpression andSearchExpression = searchExpression;
            return andSearchExpression;
        }
    }
}

