/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class TicketFieldItilId
extends TicketField<Integer>
implements HasSelectOptions {
    public static final String KEY = "itilid";

    public TicketFieldItilId() {
        super(KEY, 0, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Integer> createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), (HasSelectOptions)this);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }

    @Override
    public void validateIsValidValue(Integer value) {
        super.validateIsValidValue(value);
        BasicFieldValidation.throwIfFieldValueDoesNotExist(ItilManager.getInstance().get(value), (Object)value, (String)this.getLabel());
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        Object oldCategoryVO = ItilManager.getInstance().get(fieldValue);
        if (oldCategoryVO != null) {
            return ((FieldVO)oldCategoryVO).getDisplayValue();
        }
        return null;
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -15;
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List<ItilVO> all = ItilManager.getInstance().getAll(!includeDeleted);
        ArrayList<SelectOption> list = new ArrayList<SelectOption>(all.size());
        all.forEach(item -> list.add(new SelectOption(String.valueOf(item.getId()), item.getDisplayValue())));
        return list;
    }
}

