/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.StorageLocationInfo;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.logging.LogManager;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class TicketField<VALUE>
extends Field<VALUE> {
    public static final int DEFAULT_FIELD_PRIORITY = 100;
    private static final AtomicInteger DEFAULT_SORT_COUNTER = new AtomicInteger(100);
    private int defaultSort;
    private MandatoryFieldVO.MandatoryType enduserEditability = MandatoryFieldVO.MandatoryType.HIDDEN;
    private boolean mandatoryForResourceMember;
    private boolean mandatoryForDispatcher;
    private boolean defaultMustBeChangedForResourceMember;
    private boolean defaultMustBeChangedForDispatcher;

    public TicketField(String key) {
        this(key, null);
    }

    public TicketField(String key, VALUE defaultValue) {
        this(key, defaultValue, FieldTypeFactory.auto().withoutSearchTag());
    }

    public TicketField(String key, VALUE defaultValue, FieldTypeFactory factory) {
        super(key, defaultValue, factory);
        this.defaultSort = DEFAULT_SORT_COUNTER.getAndIncrement();
    }

    protected TicketField(@Nonnull String key, VALUE defaultValue, @Nonnull FieldTypeFactory typeFactory, @Nonnull Class<VALUE> valueClass) {
        super(key, defaultValue, typeFactory, valueClass);
    }

    public int getSortPrio() {
        return this.defaultSort;
    }

    @Nullable
    public StorageLocationInfo<VALUE> getStorageLocationInfo() {
        return null;
    }

    @Nonnull
    public abstract TicketVOSingle getValueSourceForSlaveTicketForEnduser(@Nonnull TicketVOSingle var1, @Nonnull TicketVOSingle var2);

    public OperationNewReaStep createStringFieldChangeReaStep(VALUE oldFieldValue, VALUE newFieldValue, @Nullable MutableReaStepData additionalReaStepData, OperationChangedTicket ticket) {
        MutableReaStepData data = new MutableReaStepData();
        data.put(ReaStepVO.FIELD_DESC, this.constructReaStepDescriptionForFieldChange(oldFieldValue, newFieldValue));
        data.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(ticket.getAttributeValue(Tickets.ATTRIBUTE_LAST_CHANGED)));
        if (additionalReaStepData != null) {
            additionalReaStepData.getIncludedFields().forEach(f -> data.put(f, additionalReaStepData.get(f)));
        }
        return ticket.addReaStep(this.getFieldChangeReaStepActionId(), data, MutableReaStepText.empty());
    }

    protected String constructReaStepDescriptionForFieldChange(@Nullable VALUE oldFieldValue, @Nullable VALUE newFieldValue) {
        Object oldValue = oldFieldValue == null ? "" : this.valueToString(oldFieldValue);
        Object newValue = newFieldValue == null ? "" : this.valueToString(newFieldValue);
        Object prefix = this.getFieldChangeReaStepPrefix();
        prefix = prefix != null && !((String)prefix).isEmpty() ? (String)prefix + ": " : "";
        int max = (245 - ((String)prefix).length()) / 2;
        if (((String)oldValue).length() > max) {
            oldValue = ((String)oldValue).substring(0, max - 1) + "...";
        }
        if (((String)newValue).length() > max) {
            newValue = ((String)newValue).substring(0, max - 1) + "...";
        }
        return (String)prefix + (String)oldValue + " -> " + (String)newValue;
    }

    protected String getFieldChangeReaStepPrefix() {
        if (this.getFieldChangeReaStepActionId() == -29) {
            return this.getLabel(Tickets.serverLocale());
        }
        return null;
    }

    public int getFieldChangeReaStepActionId() {
        return -29;
    }

    public String valueToString(@Nonnull VALUE fieldValue) {
        try {
            return this.getFieldType().getDisplayValue(fieldValue);
        }
        catch (ClassCastException ex) {
            HDLogger.debug(ex);
            return null;
        }
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(this.getKey());
    }

    public void setDefaultValue(VALUE value) {
        try {
            this.validate(value);
            super.setDefaultValue(value);
        }
        catch (Exception ex) {
            LogManager.getApplicationLogger().error((Object)("Illegal default value for field " + this.getKey() + ": " + String.valueOf(value)));
            LogManager.getApplicationLogger().error((Throwable)ex);
        }
    }

    public static <T> TicketField<T> valueOf(String string) {
        return Tickets.getFieldByKey(string);
    }

    public void validateIsValidValue(VALUE value) {
        this.validate(value);
    }

    public boolean isMandatoryForResourceMember() {
        return this.mandatoryForResourceMember;
    }

    public void setMandatoryForResourceMember(boolean mandatoryForSupporter) {
        this.mandatoryForResourceMember = mandatoryForSupporter;
    }

    public boolean isMandatoryForDispatcher() {
        return this.mandatoryForDispatcher;
    }

    public void setMandatoryForDispatcher(boolean mandatoryForDispatcher) {
        this.mandatoryForDispatcher = mandatoryForDispatcher;
    }

    @Nonnull
    public final MandatoryFieldVO.MandatoryType getEnduserEditability() {
        return this.enduserEditability;
    }

    public final void setEnduserEditability(@Nonnull MandatoryFieldVO.MandatoryType enduserEditability) {
        Objects.requireNonNull(enduserEditability);
        this.enduserEditability = enduserEditability;
    }

    public boolean isDefaultMustBeChangedForResourceMember() {
        return this.defaultMustBeChangedForResourceMember;
    }

    public void setDefaultMustBeChangedForResourceMember(boolean defaultMustBeChangedForResourceMember) {
        this.defaultMustBeChangedForResourceMember = defaultMustBeChangedForResourceMember;
    }

    public boolean isDefaultMustBeChangedForDispatcher() {
        return this.defaultMustBeChangedForDispatcher;
    }

    public void setDefaultMustBeChangedForDispatcher(boolean defaultMustBeChangedForDispatcher) {
        this.defaultMustBeChangedForDispatcher = defaultMustBeChangedForDispatcher;
    }
}

