/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.shared.model.Status;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class TicketAttributeStatusId
extends TicketAttribute<Integer> {
    public static final String KEY = "statusid";

    public TicketAttributeStatusId() {
        super(KEY, null, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Integer> createFieldType() {
        return new FieldTypeInteger(this.getKey(), () -> this.getLabel()){

            public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return new SearchTag(TicketAttributeStatusId.KEY, SearchDataType.IntegerMap, false, 100, labelProvider){

                    public Map<? extends Comparable<?>, String> getMapData() {
                        return StatusManager.getInstance().getAllAttributeDisplayNames(false);
                    }
                };
            }
        };
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        int slaveStatus = slave.getAttribute(this);
        if (Status.isClosedOrDeletedStatus(slaveStatus)) {
            return slave;
        }
        return master;
    }
}

