/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.lib.i18n.DisplayableMapCache;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class SearchTagTicketTags
extends SearchTag {
    public static final int TAG_BUNDLED = 0;
    public static final int TAG_ITIL_MASTER = 1;
    public static final int TAG_DEADLINE_FAILED = 2;
    public static final int TAG_AUTO_ESCALATED = 3;
    public static final String KEY = "tickettags";
    private static List<TicketTag> ticketTags;

    @Nonnull
    public static List<TicketTag> getTagsForRegistration() {
        ArrayList<TicketTag> ticketTags = new ArrayList<TicketTag>();
        ticketTags.add(new CoreTicketTag(0, ticket -> !ticket.isUnbundled()));
        ticketTags.add(new CoreTicketTag(1, ticket -> {
            ItilVO itilVO = (ItilVO)ItilManager.getInstance().get(ticket.getItilID());
            return itilVO != null && itilVO.isMasterType();
        }));
        ticketTags.add(new CoreTicketTag(2, ticket -> {
            Long deadline = ticket.getDeadline();
            return deadline != null && deadline < System.currentTimeMillis();
        }));
        ticketTags.add(new CoreTicketTag(3, ticket -> ticket.isAutoEscalated()));
        return ticketTags;
    }

    public SearchTagTicketTags() {
        super(KEY, SearchDataType.IntegerMap, false, 100);
    }

    public Map<Integer, String> getMapData() {
        List tags = ticketTags;
        if (tags == null) {
            tags = ticketTags = ServerPluginManager.getInstance().get(TicketTag.class);
        }
        return DisplayableMapCache.getMap(tags, (Object)((Object)this), (int)0);
    }

    private static class CoreTicketTag
    implements TicketTag {
        private Integer key;
        private Function<TicketVO, Boolean> tagChecker;

        public CoreTicketTag(int key, Function<TicketVO, Boolean> tagChecker) {
            this.key = key;
            this.tagChecker = tagChecker;
        }

        public Integer getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName("tickettags." + this.getKey());
        }

        @Override
        public boolean checkFor(TicketVO ticket) {
            return this.tagChecker.apply(ticket);
        }
    }

    public static interface TicketTag
    extends DisplayableKey<Integer> {
        public boolean checkFor(TicketVO var1);
    }
}

