/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAdditionalAccess;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAppointment;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionAutoCC;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionBundleImage;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionCategoryId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionClassificationId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionDeadline;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionEscalation;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionIdentifier;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionInquiryDate;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionItilId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionItilLinkCount;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastChanged;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastChangedById;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionLastEditorId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionOwnerId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionPriorityId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionResourceId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionResubmission;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionStatusId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionSubject;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionSumTime;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTargetTime;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketId;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketIdReference;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionTicketOwnerEmail;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeAutoEscalated;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeBundleId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeClosedDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDeadlineLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDispatchingReaStepId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEmailEingang;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeIdDummy;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeInitialReaStepId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeInquiryDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeItilCount;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastChanged;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastChangedByGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeLastEditorGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeStatusId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeSumTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeTerminVereinbarung;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeTicketGUID;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeWiedervorlageDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldAnnotation;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldAutoCC;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCategoryId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldClassificationId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldDeadline;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldIdentifier;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldItilId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldLinks;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldOwnerGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldPriorityId;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldResourceGuid;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldSubject;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldTargetTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketFieldAdditionalAccess;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Tickets {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.core.ticketmanager.i18n.LanguageResources", Tickets.class);
    public static final String KEY_TICKET_ID = "ticketid";
    public static final TicketAttributeIdDummy ATTRIBUTE_TICKET_ID = new TicketAttributeIdDummy();
    public static final TicketAttributeTicketGUID ATTRIBUTE_TICKET_GUID = new TicketAttributeTicketGUID();
    public static final TicketAttributeInitialReaStepId ATTRIBUTE_INITIAL_REA_STEP_ID = new TicketAttributeInitialReaStepId();
    public static final TicketAttributeDispatchingReaStepId ATTRIBUTE_DISPATCHING_REA_STEP_ID = new TicketAttributeDispatchingReaStepId();
    public static final TicketAttributeStatusId ATTRIBUTE_STATUS_ID = new TicketAttributeStatusId();
    public static final TicketAttributeInquiryDate ATTRIBUTE_INQUIRY_DATE = new TicketAttributeInquiryDate();
    public static final String DEFAULT_TICKET_ID_STRING = "TicketID";
    public static final TicketAttributeLastEditorGuid ATTRIBUTE_LAST_EDITOR_GUID = new TicketAttributeLastEditorGuid();
    public static final TicketAttributeLastChanged ATTRIBUTE_LAST_CHANGED = new TicketAttributeLastChanged();
    public static final TicketAttributeEmailEingang ATTRIBUTE_EMAIL_EINGANG = new TicketAttributeEmailEingang();
    public static final TicketAttributeSumTime ATTRIBUTE_SUM_TIME = new TicketAttributeSumTime();
    public static final TicketAttributeBundleId ATTRIBUTE_BUNDLE_ID = new TicketAttributeBundleId();
    public static final TicketAttributeHasAttachments ATTRIBUTE_ATTACHMENTS = new TicketAttributeHasAttachments();
    public static final TicketAttributeAutoEscalated ATTRIBUTE_AUTOESCALATED = new TicketAttributeAutoEscalated();
    public static final TicketAttributeLastChangedByGuid ATTRIBUTE_LAST_CHANGED_BY_GUID = new TicketAttributeLastChangedByGuid();
    public static final TicketAttributeClosedDate ATTRIBUTE_CLOSE_DATE = new TicketAttributeClosedDate();
    public static final TicketAttributeEscalationLight ATTRIBUTE_ESCALATION_LIGHT = new TicketAttributeEscalationLight();
    public static final TicketAttributeDeadlineLight ATTRIBUTE_DEADLINE_LIGHT = new TicketAttributeDeadlineLight();
    public static final TicketAttributeEscalationTime ATTRIBUTE_ESCALATION_TIME = new TicketAttributeEscalationTime();
    public static final TicketAttributeItilCount ATTRIBUTE_ITIL_COUNT = new TicketAttributeItilCount();
    public static final TicketFieldDeadline FIELD_DEADLINE = new TicketFieldDeadline();
    public static final TicketFieldResourceGuid FIELD_RESOURCE_GUID = new TicketFieldResourceGuid();
    public static final TicketFieldTargetTime FIELD_TARGET_TIME = new TicketFieldTargetTime();
    public static final TicketFieldItilId FIELD_ITIL_ID = new TicketFieldItilId();
    public static final TicketFieldClassificationId FIELD_CLASSIFICATION_ID = new TicketFieldClassificationId();
    public static final TicketFieldPriorityId FIELD_PRIORITY_ID = new TicketFieldPriorityId();
    public static final TicketFieldSubject FIELD_SUBJECT = new TicketFieldSubject();
    public static final TicketFieldAnnotation FIELD_ANNOTATION = new TicketFieldAnnotation();
    public static final TicketFieldIdentifier FIELD_IDENTIFIER = new TicketFieldIdentifier();
    public static final TicketFieldCategoryId FIELD_CATEGORY_ID = new TicketFieldCategoryId();
    public static final TicketFieldOwnerGuid FIELD_OWNER_GUID = new TicketFieldOwnerGuid();
    public static final TicketAttributeWiedervorlageDate ATTRIBUTE_WIEDERVORLAGEDATE = new TicketAttributeWiedervorlageDate();
    public static final TicketAttributeTerminVereinbarung ATTRIBUTE_TERMINVEREINBARUNG = new TicketAttributeTerminVereinbarung();
    public static final String FIELD_CUSTOM_1 = "custom1";
    public static final String FIELD_CUSTOM_2 = "custom2";
    public static final String FIELD_CUSTOM_3 = "custom3";
    public static final String FIELD_CUSTOM_4 = "custom4";
    public static final String FIELD_CUSTOM_5 = "custom5";
    public static final String FIELD_CUSTOM_6 = "custom6";
    public static final String FIELD_CUSTOM_7 = "custom7";
    public static final TicketFieldAutoCC FIELD_AUTO_CC = new TicketFieldAutoCC();
    public static final TicketFieldLinks FIELD_LINKS = new TicketFieldLinks();
    public static final TicketFieldAdditionalAccess FIELD_ADDITIONAL_ACCESS = new TicketFieldAdditionalAccess();
    public static final String KEY_TICKETDETAILS = "ticketdetails";
    public static final String KEY_READETAILS = "reastepdetails";
    private static final ConfigValue<TicketIdDefList> TICKET_ID_DEF_LIST = new ConfigValue(HDConfigKeys.TICKET_ID_DEF_LIST);
    private static final ConfigValue<String> TICKET_ID_PREFIX = new ConfigValue(HDConfigKeys.TICKET_ID_PREFIX);
    private static final ConfigValue<String> TICKET_ID_SUFFIX = new ConfigValue(HDConfigKeys.TICKET_ID_SUFFIX);
    private static final ConfigValue<String> TICKET_ID_UID = new ConfigValue(HDConfigKeys.TICKET_ID_SERVER_UID);
    private static final DynamicExtension<TicketField> ALL_TICKET_FIELDS = new DynamicExtension(TicketField.class);

    @Nonnull
    public static List<TicketAttribute<?>> getAttributesForRegistration() {
        List<TicketAttribute<?>> attributes = Tickets.getAttributesWithValuesInOwnColumn();
        attributes.add(ATTRIBUTE_TICKET_GUID);
        return attributes;
    }

    public static List<TicketAttribute<?>> getAttributesWithValuesInOwnColumn() {
        ArrayList attributes = new ArrayList();
        attributes.add(ATTRIBUTE_STATUS_ID);
        attributes.add(ATTRIBUTE_INITIAL_REA_STEP_ID);
        attributes.add(ATTRIBUTE_DISPATCHING_REA_STEP_ID);
        attributes.add(ATTRIBUTE_INQUIRY_DATE);
        attributes.add(ATTRIBUTE_LAST_EDITOR_GUID);
        attributes.add(ATTRIBUTE_LAST_CHANGED);
        attributes.add(ATTRIBUTE_EMAIL_EINGANG);
        attributes.add(ATTRIBUTE_SUM_TIME);
        attributes.add(ATTRIBUTE_BUNDLE_ID);
        attributes.add(ATTRIBUTE_ATTACHMENTS);
        attributes.add(ATTRIBUTE_LAST_CHANGED_BY_GUID);
        attributes.add(ATTRIBUTE_AUTOESCALATED);
        attributes.add(ATTRIBUTE_CLOSE_DATE);
        attributes.add(ATTRIBUTE_DEADLINE_LIGHT);
        attributes.add(ATTRIBUTE_ESCALATION_LIGHT);
        attributes.add(ATTRIBUTE_ESCALATION_TIME);
        attributes.add(ATTRIBUTE_ITIL_COUNT);
        attributes.add(ATTRIBUTE_WIEDERVORLAGEDATE);
        attributes.add(ATTRIBUTE_TERMINVEREINBARUNG);
        return attributes;
    }

    @Nonnull
    public static List<TicketField<?>> getFieldsForRegistration() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_DEADLINE);
        fields.add(FIELD_RESOURCE_GUID);
        fields.add(FIELD_TARGET_TIME);
        fields.add(FIELD_ITIL_ID);
        fields.add(FIELD_CLASSIFICATION_ID);
        fields.add(FIELD_PRIORITY_ID);
        fields.add(FIELD_SUBJECT);
        fields.add(FIELD_IDENTIFIER);
        fields.add(FIELD_CATEGORY_ID);
        fields.add(FIELD_OWNER_GUID);
        fields.add(FIELD_ANNOTATION);
        fields.add(FIELD_LINKS);
        fields.add(FIELD_ADDITIONAL_ACCESS);
        fields.add(FIELD_AUTO_CC);
        return fields;
    }

    @Nonnull
    public static List<TicketField<?>> getFieldsWithValuesInOwnColumns() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_DEADLINE);
        fields.add(FIELD_RESOURCE_GUID);
        fields.add(FIELD_TARGET_TIME);
        fields.add(FIELD_ITIL_ID);
        fields.add(FIELD_CLASSIFICATION_ID);
        fields.add(FIELD_PRIORITY_ID);
        fields.add(FIELD_SUBJECT);
        fields.add(FIELD_IDENTIFIER);
        fields.add(FIELD_CATEGORY_ID);
        fields.add(FIELD_OWNER_GUID);
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_1));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_2));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_3));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_4));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_5));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_6));
        fields.add(Tickets.getFieldByKey(FIELD_CUSTOM_7));
        fields.add(FIELD_ANNOTATION);
        fields.add(FIELD_LINKS);
        return fields;
    }

    @Nonnull
    public static List<TicketFieldDefinition> getFieldDefinitionsForRegistration() {
        ArrayList<TicketFieldDefinition> fieldDefinitions = new ArrayList<TicketFieldDefinition>();
        fieldDefinitions.add(new TicketFieldDefinitionOwnerId(0));
        fieldDefinitions.add(new TicketFieldDefinitionInquiryDate(10));
        fieldDefinitions.add(new TicketFieldDefinitionLastChanged(20));
        fieldDefinitions.add(new TicketFieldDefinitionLastChangedById(30));
        fieldDefinitions.add(new TicketFieldDefinitionLastEditorId(40));
        fieldDefinitions.add(new TicketFieldDefinitionTicketId(50));
        fieldDefinitions.add(new TicketFieldDefinitionStatusId(60));
        fieldDefinitions.add(new TicketFieldDefinitionSubject(70));
        fieldDefinitions.add(new TicketFieldDefinitionPriorityId(80));
        fieldDefinitions.add(new TicketFieldDefinitionCategoryId(90));
        fieldDefinitions.add(new TicketFieldDefinitionResourceId(100));
        fieldDefinitions.add(new TicketFieldDefinitionClassificationId(110));
        fieldDefinitions.add(new TicketFieldDefinitionItilId(120));
        fieldDefinitions.add(new TicketFieldDefinitionItilLinkCount(130));
        fieldDefinitions.add(new TicketFieldDefinitionAutoCC(147));
        fieldDefinitions.add(new TicketFieldDefinitionIdentifier(210));
        fieldDefinitions.add(new TicketFieldDefinitionSumTime(220));
        fieldDefinitions.add(new TicketFieldDefinitionTargetTime(230));
        fieldDefinitions.add(new TicketFieldDefinitionDeadline(240));
        fieldDefinitions.add(new TicketFieldDefinitionResubmission(250));
        fieldDefinitions.add(new TicketFieldDefinitionAppointment(260));
        fieldDefinitions.add(new TicketFieldDefinitionBundleImage(280));
        fieldDefinitions.add(new TicketFieldDefinitionEscalation(290));
        fieldDefinitions.add(new TicketFieldDefinitionAdditionalAccess(300));
        fieldDefinitions.add(new TicketFieldDefinitionTicketIdReference(125));
        fieldDefinitions.add(new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition<?>)UsersAndGroups.FIELD_DEF_LASTNAME, 300));
        fieldDefinitions.add(new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition<?>)UsersAndGroups.FIELD_DEF_FIRSTNAME, 310));
        fieldDefinitions.add(new TicketFieldDefinitionTicketOwnerEmail((UserFieldDefinition<?>)UsersAndGroups.FIELD_DEF_EMAIL, 330));
        fieldDefinitions.add(new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition<?>)UsersAndGroups.FIELD_DEF_TELEPHONE, 340));
        return fieldDefinitions;
    }

    public static String getTicketIDForEmailSubject(int ticketID) {
        TicketIdDefList idList = (TicketIdDefList)TICKET_ID_DEF_LIST.get();
        String ticketIdDef = idList.size() == 0 ? DEFAULT_TICKET_ID_STRING : (String)idList.get(0);
        String ticketIDstr = Tickets.normaliseTicketIdString(ticketIdDef);
        return (String)TICKET_ID_PREFIX.get() + ticketIDstr + " " + Tickets.encodeTicketId(ticketID) + (String)TICKET_ID_UID.get() + (String)TICKET_ID_SUFFIX.get();
    }

    public static String encodeTicketId(int ticketID) {
        byte[] values = String.valueOf(ticketID).getBytes(StandardCharsets.UTF_8);
        byte[] key = Arrays.copyOf(values, values.length * 2);
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                key[values.length] = (byte)(values[i] + 26);
                continue;
            }
            key[values.length + i] = (byte)(values[i - 1] - values[i] + 74);
        }
        return new String(key);
    }

    public static int decodeTicketID(@Nullable String str, boolean requiresChecksum) {
        try {
            Function<String, Integer> simpleNumberReturn = string -> -1;
            if (!requiresChecksum) {
                simpleNumberReturn = string -> Tickets.parseIntWithThousandsDelimiter(string);
            }
            if (str == null) {
                return -1;
            }
            int length = str.length();
            if (length < 1) {
                return -1;
            }
            char ch0 = str.charAt(0);
            if (ch0 < '1' || ch0 > '9') {
                return -1;
            }
            int startkey = length;
            for (int i = 0; i < length; ++i) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                startkey = i;
                break;
            }
            if (startkey == length) {
                return requiresChecksum ? -1 : Integer.parseInt(str);
            }
            if (startkey * 2 != length) {
                return simpleNumberReturn.apply(str);
            }
            for (int i = 0; i < startkey; ++i) {
                char ch1 = str.charAt(i);
                char chKey = Character.toUpperCase(str.charAt(i + startkey));
                if (i == 0) {
                    if (ch0 + 26 == chKey) continue;
                    return simpleNumberReturn.apply(str);
                }
                if (ch0 - ch1 + 74 != chKey) {
                    return simpleNumberReturn.apply(str);
                }
                ch0 = ch1;
            }
            return Integer.parseInt(str.substring(0, startkey));
        }
        catch (Throwable th) {
            return -1;
        }
    }

    private static int parseIntWithThousandsDelimiter(String str) {
        ParsePosition pos = new ParsePosition(0);
        Number val = NumberFormat.getIntegerInstance(ClientLocale.getThreadLocale()).parse(str, pos);
        if (pos.getIndex() == str.length()) {
            return val.intValue();
        }
        return -1;
    }

    public static String normaliseTicketIdString(String input) {
        StringBuffer result = new StringBuffer();
        for (int x = 0; x < input.length(); ++x) {
            if (input.charAt(x) != '\u00a0' && input.charAt(x) != '_' && input.charAt(x) > ' ') {
                result.append(input.charAt(x));
                continue;
            }
            result.append('-');
        }
        return result.toString();
    }

    public static List<TicketFieldDefinition> getFieldsVisibleForUser() {
        List allTicketDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        List<TicketFieldDefinition> fields = allTicketDefs.stream().filter(def -> def.isAvailable()).sorted((d1, d2) -> Integer.compare(d1.getPriority(), d2.getPriority())).collect(Collectors.toList());
        return fields;
    }

    public static List<String> getFieldIdsVisibleForUser() {
        return Tickets.getFieldsVisibleForUser().stream().map(TicketFieldDefinition::getKey).collect(Collectors.toList());
    }

    public static Locale serverLocale() {
        return new Locale(ConfigurationManager.getInstance().getCurrent().get("vm.user.language", Locale.getDefault().getLanguage()));
    }

    public static <T> TicketField<T> getFieldByKey(String key) {
        for (TicketField f : ALL_TICKET_FIELDS.get()) {
            if (!f.getKey().equals(key)) continue;
            return f;
        }
        if (TicketFieldSettings.isOpenFieldKey(key)) {
            throw new IllegalStateException(String.format("Field %s not found. For die Open fields 1-7 this is likely to happen because the TicketFieldSettingsManager was not initialized yet.\nWhen in production or functional tests, this method seems to be called before init() of HelpdeskserverPlugin has completed.\nWhen in a mock-unit-test, it is your responsibility to provide a TicketField or TicketFieldDefinition which behaves as you assume it in your test. Use ReplaceAllMocksRule to provide a field for your custom field. Or use MockServerPluginManager or a related Rule, that should initialize it. Or if you are not interested in any particular field-behaviour, but just want a string-field, use Tickets.FIELD_IDENTIFIER instead.", key));
        }
        return null;
    }

    public static <T> TicketAttribute<T> getAttributeByKey(String key) {
        for (TicketAttribute f : ServerPluginManager.getInstance().get(TicketAttribute.class)) {
            if (!f.getKey().equals(key)) continue;
            return f;
        }
        return null;
    }

    public static TicketFieldDefinition getFieldDefinitionByKey(String key) {
        for (TicketFieldDefinition f : DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class)) {
            if (!f.getKey().equals(key)) continue;
            return f;
        }
        return null;
    }

    public static List<TicketField> getAllTicketFields() {
        return ALL_TICKET_FIELDS.get();
    }
}

