/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.field.Field;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TicketVO {
    @Nullable
    public Object getForKey(String key) throws IllegalArgumentException {
        TicketAttribute attributeByKey = Tickets.getAttributeByKey(key);
        if (attributeByKey != null) {
            return this.getAttribute(attributeByKey);
        }
        TicketField fieldByKey = Tickets.getFieldByKey(key);
        if (fieldByKey != null) {
            return this.getValue(fieldByKey);
        }
        return null;
    }

    @Nullable
    public abstract <VALUE> VALUE getAttribute(TicketAttribute<VALUE> var1);

    public abstract <VALUE> boolean hasAttributeKey(TicketAttribute<VALUE> var1);

    @Nonnull
    public abstract Set<TicketAttribute<Object>> getIncludedAttributes();

    @Nullable
    public abstract <VALUE> VALUE getValue(TicketField<VALUE> var1);

    public abstract <VALUE> boolean hasFieldKey(TicketField<VALUE> var1);

    @Nonnull
    public abstract Set<TicketField<Object>> getIncludedFields();

    public abstract int getID();

    public final int getInitialReaStepID() {
        return this.getAttribute(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID);
    }

    @Nullable
    public final Integer getDispatchingReaStepID() {
        return this.getAttribute(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID);
    }

    public final boolean isDispatched() {
        return this.getDispatchingReaStepID() != null && this.getDispatchingReaStepID() >= 0;
    }

    public final boolean isOpenAndDispatched() {
        return Status.isOpenStatus(this.getStatusID()) && this.isDispatched();
    }

    public final long getLastChanged() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_CHANGED);
    }

    public final int getStatusID() {
        return this.getAttribute(Tickets.ATTRIBUTE_STATUS_ID);
    }

    public final int getPriorityID() {
        return this.getValue(Tickets.FIELD_PRIORITY_ID);
    }

    @Nonnull
    public final String getSubject() {
        return this.getValue(Tickets.FIELD_SUBJECT);
    }

    @Nullable
    public final Integer getCategoryID() {
        return this.getValue(Tickets.FIELD_CATEGORY_ID);
    }

    public final int getClassificationID() {
        return this.getValue(Tickets.FIELD_CLASSIFICATION_ID);
    }

    @Nullable
    public final GUID getResourceID() {
        return this.getValue(Tickets.FIELD_RESOURCE_GUID);
    }

    @Nullable
    public final GUID getOwnerID() {
        return this.getValue(Tickets.FIELD_OWNER_GUID);
    }

    @Nonnull
    public final String getAnnotation() {
        return this.getValue(Tickets.FIELD_ANNOTATION);
    }

    public final long getInquiryDate() {
        return this.getAttribute(Tickets.ATTRIBUTE_INQUIRY_DATE);
    }

    @Nullable
    public final GUID getLastEditorID() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_EDITOR_GUID);
    }

    @Nullable
    public final GUID getLastChangedByID() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID);
    }

    @Nullable
    public final String getEmailEingang() {
        return this.getAttribute(Tickets.ATTRIBUTE_EMAIL_EINGANG);
    }

    public final int getSumTime() {
        return this.getAttribute(Tickets.ATTRIBUTE_SUM_TIME);
    }

    public final Object getCustom1() {
        return this.getValue(Tickets.getFieldByKey("custom1"));
    }

    public final Object getCustom2() {
        return this.getValue(Tickets.getFieldByKey("custom2"));
    }

    public final Object getCustom3() {
        return this.getValue(Tickets.getFieldByKey("custom3"));
    }

    public final Object getCustom4() {
        return this.getValue(Tickets.getFieldByKey("custom4"));
    }

    public final Object getCustom5() {
        return this.getValue(Tickets.getFieldByKey("custom5"));
    }

    public final Object getCustom6() {
        return this.getValue(Tickets.getFieldByKey("custom6"));
    }

    public final Object getCustom7() {
        return this.getValue(Tickets.getFieldByKey("custom7"));
    }

    public final String getIdentifier() {
        return this.getValue(Tickets.FIELD_IDENTIFIER);
    }

    public final int getItilID() {
        return this.getValue(Tickets.FIELD_ITIL_ID);
    }

    @Nullable
    public final Integer getTargetTime() {
        return this.getValue(Tickets.FIELD_TARGET_TIME);
    }

    @Nullable
    public final Long getDeadline() {
        return this.getValue(Tickets.FIELD_DEADLINE);
    }

    public final boolean hasAttachments() {
        return this.getAttribute(Tickets.ATTRIBUTE_ATTACHMENTS);
    }

    public final int getBundleID() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        if (bundleID == null) {
            return this.getID();
        }
        return bundleID;
    }

    public final boolean isMasterInBundle() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        return bundleID != null && this.getID() == bundleID.intValue();
    }

    public final boolean isSlaveInBundle() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        return bundleID != null && this.getID() != bundleID.intValue();
    }

    public final boolean isUnbundled() {
        return this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID) == null;
    }

    public final boolean isInquiry() {
        return !this.isDispatched();
    }

    public final boolean isAutoEscalated() {
        return this.getAttribute(Tickets.ATTRIBUTE_AUTOESCALATED);
    }

    @Nonnull
    public final Set<Integer> getLinkedTickets() {
        return this.getValue(Tickets.FIELD_LINKS);
    }

    @Nullable
    public <T> T getFieldOrAttributeValue(Field<T> fieldOrAttribute) {
        if (fieldOrAttribute instanceof TicketAttribute) {
            return (T)this.getAttribute((TicketAttribute)fieldOrAttribute);
        }
        if (fieldOrAttribute instanceof TicketField) {
            return (T)this.getValue((TicketField)fieldOrAttribute);
        }
        if (fieldOrAttribute == Tickets.ATTRIBUTE_TICKET_ID) {
            return (T)Integer.valueOf(this.getID());
        }
        return null;
    }

    @Nonnull
    public GUID getGUID() {
        return this.getAttribute(Tickets.ATTRIBUTE_TICKET_GUID);
    }
}

