/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ReaStepTextVO {
    private String text;
    private boolean htmlContent;

    private ReaStepTextVO() {
    }

    private ReaStepTextVO(String text, boolean htmlContent) {
        this.text = text == null ? "" : text;
        this.htmlContent = htmlContent;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasHtmlContent() {
        return this.htmlContent;
    }

    public static ReaStepTextVO of(String text, boolean htmlContent) {
        return new ReaStepTextVO(text, htmlContent);
    }

    public static ReaStepTextVO empty() {
        return ReaStepTextVO.of("", false);
    }

    public boolean isEmpty() {
        return this.text.trim().isEmpty() || this.htmlContent && HtmlConverter.html2text((String)this.text).trim().isEmpty() && !this.text.contains("src=");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.htmlContent ? 1231 : 1237);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReaStepTextVO other = (ReaStepTextVO)obj;
        if (this.htmlContent != other.htmlContent) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "ReaStepTextVO [text=" + this.text + ", htmlContent=" + this.htmlContent + "]";
    }

    public static ReaStepTextVO concatenateOriginalInitialTextWithNewOne(@Nonnull ReaStepTextVO baseText, @Nullable ReaStepTextVO appendedText) {
        if (appendedText == null) {
            return baseText;
        }
        if (appendedText.isEmpty()) {
            return baseText;
        }
        if (baseText.isEmpty()) {
            return appendedText;
        }
        if (!appendedText.hasHtmlContent() && !baseText.hasHtmlContent()) {
            return ReaStepTextVO.of(baseText.getText() + "\n\n" + appendedText.getText(), false);
        }
        if (appendedText.hasHtmlContent()) {
            String converted = HtmlConverter.html2inlinedHtml((String)appendedText.getText(), (boolean)false);
            int indexOfOpeningBodyTag = converted.indexOf("<body");
            int indexAfterOpeningBodyTag = converted.indexOf(62, indexOfOpeningBodyTag) + 1;
            StringBuilder sb = new StringBuilder();
            sb.append(converted.substring(0, indexAfterOpeningBodyTag));
            sb.append(ReaStepTextVO.extractContentFrom(baseText));
            sb.append("<br><br>");
            sb.append(converted.substring(indexAfterOpeningBodyTag));
            return ReaStepTextVO.of(sb.toString(), true);
        }
        String converted = HtmlConverter.html2inlinedHtml((String)baseText.getText(), (boolean)false);
        int indexOfClosingBodyTag = converted.indexOf("</body>");
        StringBuilder sb = new StringBuilder();
        sb.append(converted.substring(0, indexOfClosingBodyTag));
        sb.append("<br><br>");
        sb.append(ReaStepTextVO.extractContentFrom(appendedText));
        sb.append(converted.substring(indexOfClosingBodyTag));
        return ReaStepTextVO.of(sb.toString(), true);
    }

    private static String extractContentFrom(ReaStepTextVO stepText) {
        if (stepText.hasHtmlContent()) {
            String converted = HtmlConverter.html2inlinedHtml((String)stepText.getText(), (boolean)false);
            int indexOfOpeningBodyTag = converted.indexOf("<body");
            int indexAfterOpeningBodyTag = converted.indexOf(62, indexOfOpeningBodyTag) + 1;
            int indexOfClosingBodyTag = converted.lastIndexOf("</body>");
            return converted.substring(indexAfterOpeningBodyTag, indexOfClosingBodyTag);
        }
        return HtmlConverter.text2html((String)stepText.getText(), null);
    }
}

