/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.cache.MemorySize;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MutableTicketAttributes
implements MemorySize {
    private Map<TicketAttribute<Object>, Object> map = new HashMap<TicketAttribute<Object>, Object>();

    public <VALUE> void put(TicketAttribute<VALUE> attribute, VALUE value) {
        try {
            attribute.validate(value);
        }
        catch (FieldValidationException ex) {
            throw new FieldValidationException(attribute.getKey() + ": " + ex.getMessage(), (Throwable)ex);
        }
        this.map.put(attribute, value);
    }

    public <VALUE> void putValidOrDefaultValue(TicketAttribute<VALUE> attribute, VALUE value) {
        value = attribute.getValidOrDefaultValue(value, null);
        this.map.put(attribute, value);
    }

    public <VALUE> VALUE get(TicketAttribute<VALUE> attribute) {
        return (VALUE)this.map.get(attribute);
    }

    public <VALUE> VALUE getOrDefault(TicketAttribute<VALUE> attribute) {
        return (VALUE)this.map.getOrDefault(attribute, attribute.getDefaultValue());
    }

    public void remove(TicketAttribute<?> attribute) {
        this.map.remove(attribute);
    }

    public boolean containsAttribute(TicketAttribute<?> attribute) {
        return this.map.containsKey(attribute);
    }

    public Set<TicketAttribute<Object>> getIncludedAttributes() {
        return new HashSet<TicketAttribute<Object>>(this.map.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public MutableTicketAttributes copy() {
        MutableTicketAttributes copy = new MutableTicketAttributes();
        for (Map.Entry<TicketAttribute<Object>, Object> entry : this.map.entrySet()) {
            TicketAttribute<Object> attribute = entry.getKey();
            copy.map.put(attribute, attribute.copyValue(entry.getValue()));
        }
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableTicketAttributes other = (MutableTicketAttributes)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TicketAttributes:[");
        sb.append(this.map.toString()).append("]");
        return sb.toString();
    }

    public void putAll(MutableTicketAttributes attributes) {
        this.map.putAll(attributes.map);
    }

    public long getSizeInMemory() {
        return 16L + MemorySize.getSizeOfMap(this.map);
    }
}

