/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableReaStepData {
    private Map<ReaStepField<Object>, Object> map = new HashMap<ReaStepField<Object>, Object>();

    public <VALUE> void put(ReaStepField<VALUE> field, VALUE value) {
        field.validate(value);
        this.map.put(field, value);
    }

    public <VALUE> void putValidOrDefaultValue(ReaStepField<VALUE> field, VALUE value) {
        value = field.getValidOrDefaultValue(value, null);
        this.map.put(field, value);
    }

    public void putAll(MutableReaStepData otherData) {
        otherData.getIncludedFields().forEach(field -> this.put((ReaStepField)((Object)field), otherData.get((ReaStepField)((Object)field))));
    }

    public <VALUE> VALUE get(ReaStepField<VALUE> field) {
        return (VALUE)this.map.get(field);
    }

    public <VALUE> VALUE getOrDefault(ReaStepField<VALUE> field) {
        return (VALUE)this.map.getOrDefault(field, field.getDefaultValue());
    }

    public void remove(ReaStepField<?> field) {
        this.map.remove(field);
    }

    public boolean containsField(ReaStepField<?> field) {
        return this.map.containsKey(field);
    }

    public Set<ReaStepField<Object>> getIncludedFields() {
        return new HashSet<ReaStepField<Object>>(this.map.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Nonnull
    public MutableReaStepData copy() {
        MutableReaStepData copy = new MutableReaStepData();
        for (Map.Entry<ReaStepField<Object>, Object> entry : this.map.entrySet()) {
            ReaStepField<Object> field = entry.getKey();
            copy.map.put(field, field.copyValue(entry.getValue()));
        }
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableReaStepData other = (MutableReaStepData)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public static <VALUE> MutableReaStepData ofSingle(ReaStepField<VALUE> field, VALUE value) {
        MutableReaStepData data = new MutableReaStepData();
        data.put(field, value);
        return data;
    }
}

