/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.itil;

import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ItilManager
extends GenericFieldsManager<ItilVO> {
    private static ItilManager manager = new ItilManager();

    private ItilManager() {
        super(ItilVO.class, "tblItil");
    }

    public static ItilManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        ItilVO itil = (ItilVO)this.get(id);
        if (itil == null) {
            return null;
        }
        return this.resolveImageURL(itil.getImageName(), size);
    }

    @Override
    protected void updateModelValueFromResultSet(ItilVO vo, ResultSet rs, int columnIndex, Field field) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("restrictedTo")) {
            super.updateModelValueFromResultSet(vo, rs, columnIndex, field);
            return;
        }
        Map<Object, Set<Object>> restrictedTo = new HashMap<com.inet.usersandgroups.api.ui.Type, Set<GUID>>();
        restrictedTo.put(com.inet.usersandgroups.api.ui.Type.group, new HashSet<GUID>(){
            {
                this.add(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUP_ALLUSERS).getID());
            }
        });
        try (InputStream binaryStream = rs.getBinaryStream(columnIndex);){
            String readBytes;
            if (binaryStream != null && !StringFunctions.isEmpty((String)(readBytes = IOFunctions.readString((InputStream)binaryStream, (Charset)StandardCharsets.UTF_8)))) {
                restrictedTo = (Map)new Json().fromJson(readBytes, (Type)new JsonParameterizedType(HashMap.class, new Type[]{com.inet.usersandgroups.api.ui.Type.class, new JsonParameterizedType(HashSet.class, new Type[]{GUID.class})}));
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        vo.setRestrictedTo(restrictedTo);
    }

    @Override
    protected void updateResultSetValueFromModelValue(ItilVO vo, Field field, ResultSet rs, int columnIndex) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("restrictedTo")) {
            super.updateResultSetValueFromModelValue(vo, field, rs, columnIndex);
            return;
        }
        Map<com.inet.usersandgroups.api.ui.Type, Set<GUID>> restrictedTo = vo.getRestrictedTo();
        String json = new Json().toJson(restrictedTo);
        rs.updateObject(columnIndex, (Object)json.getBytes(StandardCharsets.UTF_8));
    }

    public boolean isUsableByCurrentUser(int itilID) {
        ItilVO itilVO = (ItilVO)this.get(itilID);
        if (itilVO == null) {
            throw new IllegalArgumentException("ITIL " + itilID + " null!!!");
        }
        Map<com.inet.usersandgroups.api.ui.Type, Set<GUID>> restrictedTo = itilVO.getRestrictedTo();
        Set<GUID> groups = restrictedTo.get(com.inet.usersandgroups.api.ui.Type.group);
        HashSet<GUID> users = new HashSet<GUID>();
        if (restrictedTo.get(com.inet.usersandgroups.api.ui.Type.user) != null) {
            users.addAll((Collection)restrictedTo.get(com.inet.usersandgroups.api.ui.Type.user));
        }
        users.add(UserManager.PRIVILEGED_ACCOUNT_ID);
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        return this.isUserInGroups(groups, currentUserAccountID) || users.contains(currentUserAccountID);
    }

    private boolean isUserInGroups(Set<GUID> groups, GUID currentUserAccountID) {
        if (groups == null || currentUserAccountID == null) {
            return false;
        }
        UserGroupManager groupManager = UserGroupManager.getInstance();
        Set groupsForUser = groupManager.getGroupsForUser(currentUserAccountID).stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
        return groups.stream().anyMatch(groupsForUser::contains);
    }
}

