/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.category;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import java.text.Collator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonData
public class CategoryVO
extends FieldVO
implements Deletable,
Comparable<CategoryVO> {
    public static final int CATEGORY_MAX_LENGTH = 49;
    private String Betreff;
    private Integer ParentID = 0;
    private int ResID;
    private boolean UserInVis;
    private boolean geloescht;
    private String absender;
    private transient String path;

    private CategoryVO() {
    }

    public CategoryVO(int id, String name, Integer parentCategoryID, int resourceID, boolean invisibleToUser, boolean deleted, String absender) {
        super(id);
        this.Betreff = name;
        this.ParentID = parentCategoryID;
        this.ResID = resourceID;
        this.UserInVis = invisibleToUser;
        this.geloescht = deleted;
        this.path = null;
        this.absender = absender;
    }

    @Override
    public String getDisplayValue() {
        return this.Betreff;
    }

    @Nullable
    public String getAbsender() {
        return this.absender;
    }

    public Integer getParentCategoryID() {
        return this.ParentID;
    }

    public int getResourceID() {
        return this.ResID;
    }

    public boolean isHidden() {
        return this.UserInVis;
    }

    public boolean isEffectivelyHidden() {
        CategoryManager m = CategoryManager.getInstance();
        return this.isEffectivelyHidden(vo -> (CategoryVO)m.get(vo.getParentCategoryID()));
    }

    public boolean isEffectivelyHidden(Function<CategoryVO, CategoryVO> parentProvider) {
        CategoryVO vo = this;
        while (vo != null) {
            if (vo.isHidden()) {
                return true;
            }
            if (vo.getParentCategoryID() != null && vo.getParentCategoryID() > 0) {
                vo = parentProvider.apply(vo);
                continue;
            }
            vo = null;
        }
        return false;
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    public String getPath() {
        CategoryVO parent;
        if (this.path != null) {
            return this.path;
        }
        Integer parentId = this.getParentCategoryID();
        Object path = this.getDisplayValue();
        if (parentId != null && parentId > 0 && (parent = (CategoryVO)CategoryManager.getInstance().get(parentId)) != null) {
            path = parent.getPath() + "\\" + (String)path;
        }
        this.path = path;
        return path;
    }

    void resetPath() {
        this.path = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.Betreff == null ? 0 : this.Betreff.hashCode());
        result = 31 * result + (this.ParentID == null ? -1 : this.ParentID.hashCode());
        result = 31 * result + (this.absender == null ? -1 : this.ParentID.hashCode());
        result = 31 * result + this.ResID;
        result = 31 * result + (this.UserInVis ? 1231 : 1237);
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CategoryVO)) {
            return false;
        }
        CategoryVO other = (CategoryVO)obj;
        return this.getId() == other.getId() && Objects.equals(this.ParentID, other.ParentID) && this.ResID == other.ResID && this.geloescht == other.geloescht && this.UserInVis == other.UserInVis && Objects.equals(this.Betreff, other.Betreff) && Objects.equals(this.absender, other.absender);
    }

    void setParentCategoryId(Integer id) {
        this.ParentID = id;
    }

    @Override
    public int compareTo(CategoryVO o) {
        if (o == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        String rawPath1 = this.getPath();
        String rawPath2 = o.getPath();
        return CategoryVO.comparePaths(rawPath1, rawPath2);
    }

    public static int comparePaths(String rawPath1, String rawPath2) {
        String path1 = rawPath1.replace('\\', '|');
        String path2 = rawPath2.replace('\\', '|');
        Collator collator = Collator.getInstance();
        collator.setStrength(1);
        collator.setDecomposition(1);
        return collator.compare(path1, path2);
    }
}

