/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.action;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.shared.model.Actions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonData
public class ActionVO
extends FieldVO
implements Deletable {
    private String AktBezeichnung;
    private int Status;
    private boolean intern;
    private int PauschAdd;
    private int PauschSelekt;
    private double AktPauschale;
    private boolean geloescht;
    private int spezial;
    private boolean UserInVis;
    private static final HashSet<Integer> SYSTEMSTEPS_IDS = new HashSet(Arrays.stream(Actions.SYSTEMSTEPS).boxed().collect(Collectors.toList()));

    private ActionVO() {
    }

    public ActionVO(int id, String name, int status, boolean intern, int billingType, int lumpSumType, double flatCharge, boolean deleted, int special, boolean invisibleToUser) {
        super(id);
        this.AktBezeichnung = name;
        this.Status = status;
        this.intern = intern;
        this.PauschAdd = billingType;
        this.PauschSelekt = lumpSumType;
        this.AktPauschale = flatCharge;
        this.geloescht = deleted;
        this.spezial = special;
        this.UserInVis = invisibleToUser;
    }

    @Override
    public String getDisplayValue() {
        return this.AktBezeichnung;
    }

    public int getStatusID() {
        return this.Status;
    }

    public int getBillingType() {
        return this.PauschAdd;
    }

    public int getLumpSumType() {
        return this.PauschSelekt;
    }

    public double getFixedCharge() {
        return this.AktPauschale;
    }

    public int getSpecial() {
        return this.spezial;
    }

    public String getUniqueID() {
        return String.valueOf(this.getId());
    }

    public boolean isInternal() {
        return this.intern;
    }

    public boolean istCustomAction() {
        return this.getId() > 10;
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    public boolean isHidden() {
        return this.UserInVis;
    }

    @Deprecated
    public boolean isActionForSystemStep() {
        return SYSTEMSTEPS_IDS.contains(this.getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ActionVO)) {
            return false;
        }
        ActionVO other = (ActionVO)obj;
        return this.getId() == other.getId() && this.Status == other.Status && this.PauschAdd == other.PauschAdd && this.PauschSelekt == other.PauschSelekt && this.spezial == other.spezial && this.intern == other.intern && this.geloescht == other.geloescht && this.UserInVis == other.UserInVis && Objects.equals(this.AktBezeichnung, other.AktBezeichnung) && Objects.equals(this.getUniqueID(), other.getUniqueID());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.AktBezeichnung == null ? 0 : this.AktBezeichnung.hashCode());
        result = 31 * result + (this.getUniqueID() == null ? 0 : this.getUniqueID().hashCode());
        long temp = Double.doubleToLongBits(this.AktPauschale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.PauschAdd;
        result = 31 * result + this.PauschSelekt;
        result = 31 * result + this.Status;
        result = 31 * result + (this.UserInVis ? 1231 : 1237);
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        result = 31 * result + (this.intern ? 1231 : 1237);
        result = 31 * result + this.spezial;
        return result;
    }

    public ActionVO copyActionWithChangedStatus(int newStatusID) {
        if (!this.getClass().equals(ActionVO.class)) {
            throw new UnsupportedOperationException("Must override this method in class " + this.getClass().getName());
        }
        return this.basicCopyActionWithChangedStatus(newStatusID);
    }

    protected final ActionVO basicCopyActionWithChangedStatus(int newStatusID) {
        return new ActionVO(this.getId(), this.getDisplayValue(), newStatusID, this.isInternal(), this.getBillingType(), this.getLumpSumType(), this.getFixedCharge(), this.isDeleted(), this.getSpecial(), this.isHidden());
    }
}

