/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.action;

import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.stream.Collectors;

public class ActionManager
extends GenericFieldsManager<ActionVO> {
    private static ActionManager manager = new ActionManager();
    private static final String MSSQL_INSERT_STATEMENT_PRE = "SET IDENTITY_INSERT tblAktionen ON;";
    private static final String MSSQL_INSERT_STATEMENT_POST = "; SET IDENTITY_INSERT tblAktionen OFF;";

    private ActionManager() {
        super(ActionVO.class, "tblAktionen");
    }

    public static ActionManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        return null;
    }

    @Override
    public int add(ActionVO vo) throws SQLException {
        return this.add(vo, true);
    }

    @Override
    public int addPredefined(ActionVO vo) throws SQLException {
        return this.addPredefined(vo, true);
    }

    public int addPredefined(ActionVO vo, boolean grantToSupporters) throws SQLException {
        return this.add0(vo, grantToSupporters, true);
    }

    public int add(ActionVO vo, boolean grantToSupporters) throws SQLException {
        return this.add0(vo, grantToSupporters, false);
    }

    private int add0(ActionVO vo, boolean grantToSupporters, boolean usePredefinedId) throws SQLException {
        int actionID;
        int n = actionID = usePredefinedId ? this.addPredefined0(vo) : super.add(vo);
        if (grantToSupporters) {
            Set allowedActions = (Set)UserGroupManager.getInstance().getGroup(HDUsersAndGroups.GROUPID_SUPPORTERS).getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS);
            allowedActions.add(vo.getId());
            MutableUserGroupData data = new MutableUserGroupData();
            data.put((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS, (Object)allowedActions);
            UserGroupManager.getInstance().updateGroupData(HDUsersAndGroups.GROUPID_SUPPORTERS, data);
        }
        ActionCreationNotificator acn = (ActionCreationNotificator)ServerPluginManager.getInstance().getSingleInstance(ActionCreationNotificator.class);
        acn.notifyAboutNewlyCreatedAction(actionID);
        return actionID;
    }

    private int addPredefined0(ActionVO vo) throws SQLException {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        return DatabaseTransactionUtils.executeAsTransaction(connectionFactory, connection -> {
            DatabaseConfigInfoList list = (DatabaseConfigInfoList)HDConfigKeys.DB_CONFIGS.getCurrent();
            DatabaseConfigInfo databaseConfigInfo = list.get("HDS");
            if (databaseConfigInfo != null && databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7) {
                try (Statement stm = connection.createStatement();){
                    stm.execute(MSSQL_INSERT_STATEMENT_PRE);
                }
            }
            int result = super.addPredefined(vo);
            if (databaseConfigInfo != null && databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7) {
                try (Statement stm = connection.createStatement();){
                    stm.execute(MSSQL_INSERT_STATEMENT_POST);
                }
            }
            connection.commit();
            return result;
        });
    }

    @Override
    protected void beforeUpdateOrInsertRow(ResultSet mainResultSet, ActionVO vo, Connection con, boolean update) throws SQLException {
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null) {
            return;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo hdDb = list.get("HDS");
        if (!(hdDb == null || hdDb.getDriver() != DatabaseConfigInfo.DatabaseType.mysql && hdDb.getDriver() != DatabaseConfigInfo.DatabaseType.mariadb || update)) {
            try (Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery("Select Max(AktID) from tblAktionen");){
                if (rs.next()) {
                    int max = rs.getInt(1);
                    mainResultSet.updateInt(1, max + 1);
                }
            }
        }
    }

    public Set<Integer> getAllValidIds() {
        return this.getAll(true).stream().map(FieldVO::getId).collect(Collectors.toSet());
    }
}

