/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.config.ConfigValue;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.JoinIndexIterator;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionResourceId
extends AbstractTicketFieldDefinitionWithField<GUID> {
    private static final ConfigValue<Integer> CONTENT_CHANGEABLE = new ConfigValue(HDConfigKeys.PROCESSING_CONTENT_CHANGEABLE_WHEN_CLOSED);

    public TicketFieldDefinitionResourceId(int prio) {
        super(Tickets.FIELD_RESOURCE_GUID, true, true, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/resources_16@3x.png");
    }

    @Override
    public SelectEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public String getEditHint(List<TicketVO> tickets) {
                if (UserManager.getInstance().getCurrentUserAccount() == null || !HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return null;
                }
                if (tickets != null && !tickets.isEmpty()) {
                    for (TicketVO ticket : tickets) {
                        ActionVO forwardAction;
                        if (ticket.isInquiry() || Status.isClosedStatus(ticket.getStatusID())) continue;
                        if (TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(8) && (forwardAction = (ActionVO)ActionManager.getInstance().get(8)) != null) {
                            return Tickets.MSG.getMsg("hint.ressourceid", new Object[]{forwardAction.getDisplayValue()});
                        }
                        return null;
                    }
                }
                return null;
            }

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                boolean available = super.isAvailable(tickets);
                if (!available) {
                    return false;
                }
                if (tickets != null && !tickets.isEmpty()) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(Tickets.FIELD_RESOURCE_GUID.getFieldChangeReaStepActionId());
                    for (TicketVO ticket : tickets) {
                        if (!ticket.isInquiry()) {
                            if (!Status.isClosedStatus(ticket.getStatusID())) {
                                return false;
                            }
                            if ((Integer)CONTENT_CHANGEABLE.get() != 2) {
                                return false;
                            }
                        }
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket.getID()) == null) continue;
                        return false;
                    }
                    return HDUsersAndGroups.isDispatcher(UserManager.getInstance().getCurrentUserAccount());
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString)) {
                        GUID resourceId = GUID.valueOf((String)valueString);
                        if (resourceId != null) {
                            ticketData.put(Tickets.FIELD_RESOURCE_GUID, resourceId);
                        }
                    } else {
                        ticketData.put(Tickets.FIELD_RESOURCE_GUID, null);
                    }
                }
            }

            @Override
            public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, @Nonnull Map<String, String> values) {
                UserGroupInfo groupInfo;
                CategoryVO categoryVO;
                Integer categoryDefault;
                CategoryManager.RESOURCE_TAKEOVER takeOverValue;
                UserGroupInfo resource;
                int defaultAuthorisationResource;
                UserAccount owner;
                GUID resourceId = (GUID)Tickets.FIELD_RESOURCE_GUID.getDefaultValue();
                if (ownerId != null && (owner = UserManager.getInstance().getUserAccount(ownerId)) != null) {
                    Integer classId = (Integer)owner.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
                    UserClassVO userClassVO = (UserClassVO)UserClassManager.getInstance().get(classId);
                    if (userClassVO != null && (defaultAuthorisationResource = userClassVO.getDefaultAuthorisationResource()) > 0 && (resource = HDUsersAndGroups.getResource(defaultAuthorisationResource)) != null) {
                        resourceId = resource.getID();
                    }
                }
                if ((takeOverValue = (CategoryManager.RESOURCE_TAKEOVER)((Object)CategoryManager.RESOURCE_TAKEOVER_SETTING.get())) != CategoryManager.RESOURCE_TAKEOVER.never && (categoryDefault = (Integer)Tickets.FIELD_CATEGORY_ID.getDefaultValue()) != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryDefault)) != null && (defaultAuthorisationResource = categoryVO.getResourceID()) > 0 && (resource = HDUsersAndGroups.getResource(defaultAuthorisationResource)) != null) {
                    resourceId = resource.getID();
                }
                if (ticket != null) {
                    resourceId = ticket.getResourceID();
                }
                SelectOption option = new SelectOption(null, "", "");
                if (resourceId != null && (groupInfo = UserGroupManager.getRecoveryEnabledInstance().getGroup(resourceId)) != null) {
                    option = new SelectOption(resourceId.toString(), groupInfo.getDisplayName(), HDUsersAndGroups.getResourceIconKey(groupInfo), 0, false, false, this.getPath(resourceId, ""));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionResourceId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionResourceId.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                if (searchTerm == null) {
                    searchTerm = "";
                }
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                boolean noneAuthorized = true;
                if (tickets != null && !tickets.isEmpty()) {
                    for (TicketVO ticket : tickets) {
                        if (!ticket.isDispatched()) continue;
                        noneAuthorized = false;
                        break;
                    }
                }
                if (noneAuthorized) {
                    list.add(new SelectOption(null, "", ""));
                }
                SearchID searchID = new SearchID((Object)("recource_getSelectOptions_" + searchTerm));
                ArrayList boostingExpressions = new ArrayList();
                ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
                UserGroupManager manager = UserGroupManager.getRecoveryEnabledInstance();
                additionalExpressions.add(new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, (Object)HDUsersAndGroups.RESOURCE.getName()));
                SearchResult searchResult = manager.search(manager.getSearchEngine().getTag("groupname").getDisplayName() + ":" + searchTerm, additionalExpressions, boostingExpressions, 500, searchID);
                if (searchResult.isPartialResult() && searchResult.getEntries().isEmpty()) {
                    return new SelectOptionResult(0, list);
                }
                HashSet knownIds = new HashSet();
                ArrayList result = new ArrayList();
                Consumer<List> fillFinalResultWithEntries = entries -> {
                    for (SearchResultEntry e : entries) {
                        if (knownIds.contains(e.getId())) continue;
                        knownIds.add((GUID)e.getId());
                        result.add(e);
                    }
                };
                fillFinalResultWithEntries.accept(searchResult.getEntries());
                HashSet<UserGroupInfo> foundGroups = new HashSet<UserGroupInfo>();
                for (SearchResultEntry entry : searchResult.getEntries()) {
                    UserGroupInfo group = manager.getGroup((GUID)entry.getId());
                    if (group == null || !group.isActive()) continue;
                    foundGroups.add(group);
                }
                Function<Set, Set> getParentGroups = groups -> {
                    HashSet<UserGroupInfo> parentGroups = new HashSet<UserGroupInfo>();
                    for (UserGroupInfo group : groups) {
                        UserGroupInfo parent;
                        GUID parentID = group.getParentID();
                        if (parentID == null || (parent = manager.getGroup(parentID)) == null || !parent.isActive()) continue;
                        parentGroups.add(parent);
                    }
                    return parentGroups;
                };
                HashSet<GUID> allAncestorIDs = new HashSet<GUID>();
                Set parentGroups = getParentGroups.apply(foundGroups);
                while (!parentGroups.isEmpty()) {
                    for (UserGroupInfo parent : parentGroups) {
                        allAncestorIDs.add(parent.getID());
                    }
                    parentGroups = getParentGroups.apply(parentGroups);
                }
                HashSet<GUID> allDescendantIDs = new HashSet<GUID>();
                Set allDescendantGroups = UserGroupTreeUtils.findDescendantGroups(foundGroups, (Set)manager.getAllGroups(), (boolean)false);
                for (UserGroupTreeUtils.DescendantGroups entry : allDescendantGroups) {
                    for (UserGroupInfo group : entry.getDescendantGroups()) {
                        allDescendantIDs.add(group.getID());
                    }
                }
                HashSet<GUID> allAncestorAndDescendantIDs = new HashSet<GUID>();
                allAncestorAndDescendantIDs.addAll(allAncestorIDs);
                allAncestorAndDescendantIDs.addAll(allDescendantIDs);
                if (!allAncestorAndDescendantIDs.isEmpty()) {
                    int maxResults = allAncestorAndDescendantIDs.size();
                    ArrayList searchConditions = new ArrayList();
                    OrSearchExpression orSearchExpression = new OrSearchExpression();
                    allAncestorAndDescendantIDs.forEach(groupID -> orSearchExpression.add((Object)new SearchCondition("groupname", SearchCondition.SearchTermOperator.Equals, (Object)groupID.toString())));
                    searchConditions.add(orSearchExpression);
                    List searchResultEntries = manager.search("", (List)searchConditions, Collections.emptyList(), maxResults, searchID).getEntries();
                    fillFinalResultWithEntries.accept(searchResultEntries);
                }
                HashMap<SearchResultEntry, String> pathes = new HashMap<SearchResultEntry, String>();
                for (SearchResultEntry entry : result) {
                    String path = this.getPath((GUID)entry.getId(), "");
                    pathes.put(entry, path);
                }
                Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
                Comparator comparator = (a, b) -> collator.compare((String)a, (String)b);
                List sortedResult = pathes.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).map(Map.Entry::getKey).collect(Collectors.toList());
                int start = currentSize;
                int end = start + chunkSize;
                end = Math.min(end, sortedResult.size());
                List subList = sortedResult.subList(start, end);
                for (SearchResultEntry searchExpression : subList) {
                    UserGroupInfo resourceGroup = manager.getGroup((GUID)searchExpression.getId());
                    int level = this.getLevel(resourceGroup);
                    String path = (String)pathes.get(searchExpression);
                    list.add(new SelectOption(resourceGroup.getID().toString(), resourceGroup.getDisplayName(), HDUsersAndGroups.getResourceIconKey(resourceGroup), level, false, false, path));
                }
                return new SelectOptionResult(sortedResult.size(), list);
            }

            private int getLevel(UserGroupInfo resourceGroup) {
                int level = 0;
                GUID parentId = resourceGroup.getParentID();
                while (parentId != null) {
                    ++level;
                    UserGroupInfo parent = UserGroupManager.getRecoveryEnabledInstance().getGroup(parentId);
                    if (parent != null) {
                        parentId = parent.getParentID();
                        continue;
                    }
                    parentId = null;
                }
                return level;
            }

            private String getPath(GUID id, String parentPath) {
                parentPath = ((String)parentPath).isEmpty() ? this.getName(id) : this.getName(id) + "\\" + (String)parentPath;
                GUID parentId = this.getParentId(id);
                if (id.equals((Object)parentId)) {
                    return parentPath;
                }
                if (parentId != null) {
                    parentPath = this.getPath(parentId, (String)parentPath);
                }
                return parentPath;
            }

            private String getName(GUID id) {
                UserGroupInfo group = UserGroupManager.getRecoveryEnabledInstance().getGroup(id);
                return group == null || !group.isActive() ? null : group.getName();
            }

            private GUID getParentId(GUID id) {
                UserGroupInfo group = UserGroupManager.getRecoveryEnabledInstance().getGroup(id);
                if (group != null && group.isActive()) {
                    return group.getParentID();
                }
                return null;
            }
        };
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        GUID resId = ticket.getResourceID();
        if (resId == null) {
            return null;
        }
        return this.getRessourceState(resId);
    }

    private String getRessourceState(GUID resId) {
        UserGroupInfo ressourceGroup = UserGroupManager.getRecoveryEnabledInstance().getGroup(resId);
        return HDUsersAndGroups.getResourceIconKey(ressourceGroup);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if ("deleted".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/delete_16.gif");
        }
        if ("write".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resources_16.gif");
        }
        if ("read".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resources_read_16.gif");
        }
        if ("blocked".equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/resource_forign_16.gif");
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.FIELD_RESOURCE_GUID.getKey(), sortGroupKey -> {
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            GUID resID = GUID.valueOf((String)sortGroupKey);
            UserGroupManager groupManager = UserGroupManager.getRecoveryEnabledInstance();
            UserGroupInfo ressourceGroup = groupManager.getGroup(resID);
            String displayName = TicketFieldDefinitionResourceId.getDisplayName(ressourceGroup, groupManager);
            String iconKey = this.getRessourceState(resID);
            return new SortGroup(displayName, true, iconKey);
        });
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Nonnull
    public static String getDisplayName(UserGroupInfo ressourceGroup, UserGroupManager groupManager) {
        Object displayName = "";
        if (ressourceGroup != null) {
            UserGroupInfo parent;
            displayName = ressourceGroup.getDisplayName();
            GUID parentID = ressourceGroup.getParentID();
            while (parentID != null && (parent = groupManager.getGroup(parentID)) != null) {
                displayName = parent.getDisplayName() + " \\ " + (String)displayName;
                parentID = parent.getParentID();
            }
        } else {
            displayName = Tickets.MSG.getMsg("value.deleted", new Object[0]);
        }
        return displayName;
    }

    @Override
    @Nullable
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return new FieldSortedIteratorDefinition(){

            @Override
            @Nonnull
            public Iterator<Integer> getIterator(@Nonnull Set<Integer> mainIds, @Nonnull IndexSearchEngine<Integer> engine, boolean forward) {
                Comparator comp = forward ? Comparator.naturalOrder() : Comparator.reverseOrder();
                TreeMap map = new TreeMap(comp);
                UserGroupManager manager = UserGroupManager.getInstance();
                for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
                    String displayName = TicketFieldDefinitionResourceId.getDisplayName(group, manager);
                    map.put(displayName, Collections.singleton(group.getID()));
                }
                return new JoinIndexIterator(mainIds, engine, "resourceid", map.values().iterator(), forward);
            }
        };
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_SELECT;
    }
}

