/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.config.ConfigurationManager;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.CustomFieldDefinitionEditInformations;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldIdentifier;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionIdentifier
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionIdentifier(int prio) {
        super(Tickets.FIELD_IDENTIFIER, true, false, prio);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(a.getForKey(this.getKey()), b.getForKey(this.getKey()));
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), Tickets.FIELD_IDENTIFIER);
        if (editInformation == null) {
            return new FieldEditDefinition(this){

                @Override
                public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                    String identifier = values.get(this.getFieldKey());
                    if (identifier != null) {
                        ticketData.put(Tickets.FIELD_IDENTIFIER, identifier);
                    }
                }

                @Override
                public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                    if (ticket != null) {
                        String identifier = ticket.getIdentifier();
                        values.put(this.getFieldKey(), String.valueOf(identifier));
                    } else {
                        String fieldValue;
                        UserAccount userAccount;
                        String value = (String)TicketFieldDefinitionIdentifier.this.defaultValue();
                        DefaultValuesManager defaultValuesManager = (DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
                        UserField<Object> fieldForIdentifierValue = defaultValuesManager.getFieldForIdentifierValue();
                        if (fieldForIdentifierValue != null && ownerId != null && (userAccount = UserManager.getInstance().getUserAccount(ownerId)) != null && (fieldValue = fieldForIdentifierValue.getFieldType().asString(userAccount.getValue(fieldForIdentifierValue))) != null) {
                            value = fieldValue;
                        }
                        values.put(this.getFieldKey(), value);
                    }
                }

                @Override
                public String getFieldKey() {
                    return TicketFieldDefinitionIdentifier.this.getKey();
                }

                @Override
                public String getDisplayType() {
                    return "textinput";
                }

                @Override
                public String getDisplayName() {
                    return TicketFieldDefinitionIdentifier.this.getDisplayName();
                }
            };
        }
        if (editInformation.getFreifeldType() == FreifeldType.Multi) {
            return this.getSelectEditDefinition(Tickets.FIELD_IDENTIFIER, true, false);
        }
        if (editInformation.getFreifeldType() == FreifeldType.Editable) {
            return this.getSelectEditDefinition(Tickets.FIELD_IDENTIFIER, false, true);
        }
        return this.getSelectEditDefinition(Tickets.FIELD_IDENTIFIER, false, false);
    }

    protected SelectEditDefinition getSelectEditDefinition(final TicketFieldIdentifier field, final boolean multi, final boolean customValues) {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    if (multi) {
                        ticketData.put(field, value);
                    } else {
                        SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                        String valueString = selectOption.getValue();
                        if (!StringFunctions.isEmpty((String)valueString)) {
                            ticketData.put(field, valueString);
                        } else {
                            ticketData.put(field, null);
                        }
                    }
                } else {
                    ticketData.put(field, null);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (multi) {
                    if (ticket != null) {
                        String custom = ticket.getValue(field);
                        values.put(this.getFieldKey(), String.valueOf(custom));
                    } else {
                        values.put(this.getFieldKey(), "");
                    }
                } else {
                    String custom = null;
                    SelectOption option = new SelectOption("", "");
                    if (ticket != null && (custom = ticket.getValue(field)) != null) {
                        option = new SelectOption(custom, custom);
                    }
                    values.put(this.getFieldKey(), new Json().toJson((Object)option));
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionIdentifier.this.getKey();
            }

            @Override
            public String getDisplayType() {
                if (multi) {
                    return "selectmulti";
                }
                if (customValues) {
                    return "selecteditable";
                }
                if (ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION) != null) {
                    return "selecteditable";
                }
                return "select";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionIdentifier.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                SelectOptionResult data = CustomFieldDefinitionEditInformations.getData(UserManager.getInstance().getCurrentUserAccount(), field, true);
                if (data != null) {
                    List allOptions = data.getOptions();
                    for (SelectOption option : allOptions) {
                        String label = option.getLabel();
                        if (label == null) {
                            label = "";
                        }
                        if (searchTerm != null && !label.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                        list.add(option);
                    }
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }
        };
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_TEXT;
    }
}

