/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationLight;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByDateRangeSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.helpdesk.shared.model.ticket.TicketTimelineInformations;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import java.net.URL;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TicketFieldDefinitionEscalation
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    private TimelineDataHandler dataHandler = null;

    public TicketFieldDefinitionEscalation(int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, "escalation", true, true, prio);
    }

    private TimelineDataHandler getHandler() {
        if (this.dataHandler == null) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            this.dataHandler = (TimelineDataHandler)spm.getSingleInstance(TimelineDataHandler.class);
        }
        return this.dataHandler;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Long value = ticket.getAttribute(Tickets.ATTRIBUTE_ESCALATION_TIME);
        if (value == null) {
            return null;
        }
        return DateTimeUtils.dateTimeToLongFormat(value);
    }

    private TicketTimelineInformations getEscalationData(TicketVO ticket) {
        return this.getHandler().getEscalationData(ticket.getID());
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/escalation_blue_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/escalation_blue_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/escalation_blue_16@3x.png");
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        TicketAttributeEscalationLight.Value attribute = ticket.getAttribute(Tickets.ATTRIBUTE_ESCALATION_LIGHT);
        return attribute == null ? null : attribute.name();
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if (TicketAttributeEscalationLight.Value.green.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/escalation_green_16.gif");
        }
        if (TicketAttributeEscalationLight.Value.yellow.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/escalation_yellow_16.gif");
        }
        if (TicketAttributeEscalationLight.Value.red.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/escalation_red_16.gif");
        }
        if (TicketAttributeEscalationLight.Value.attention.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/escalation_attention.gif");
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByDateRangeSortGroupInformation(null){

            @Override
            protected Long getTimeStamp(TicketVO ticket) {
                return TicketFieldDefinitionEscalation.this.getEscalationData(ticket) == null ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(TicketFieldDefinitionEscalation.this.getEscalationData(ticket).getTargetTime());
            }
        };
    }

    private long getComparableEscalationTargetTime(TicketVO ticket) {
        TicketTimelineInformations escalationData = this.getEscalationData(ticket);
        if (escalationData == null) {
            return Long.MAX_VALUE;
        }
        return escalationData.getTargetTime();
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        return (t1, t2) -> Long.compare(this.getComparableEscalationTargetTime((TicketVO)t1), this.getComparableEscalationTargetTime((TicketVO)t2));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_DATE_TIME;
    }
}

