/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.ConfigurableDefaultValue;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionClassificationId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager
implements ConfigurableDefaultValue,
ConfigurableMandatoryField<Integer> {
    public TicketFieldDefinitionClassificationId(int prio) {
        super(Tickets.FIELD_CLASSIFICATION_ID, ClassificationManager.getInstance(), prio);
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        Integer value = ticket.getFieldOrAttributeValue(Tickets.FIELD_CLASSIFICATION_ID);
        if (value == null) {
            return null;
        }
        ClassificationVO classificationVO = (ClassificationVO)ClassificationManager.getInstance().get(value);
        if (classificationVO == null) {
            return null;
        }
        String imageName = classificationVO.getImageName();
        if (StringFunctions.isEmpty((String)imageName)) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_classification_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                Integer classificationId;
                SelectOption selectOption;
                String valueString;
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value) && !StringFunctions.isEmpty((String)(valueString = (selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class)).getValue())) && (classificationId = Integer.valueOf(valueString)) != null) {
                    ticketData.put(Tickets.FIELD_CLASSIFICATION_ID, classificationId);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                int classificationId;
                int n = classificationId = TicketFieldDefinitionClassificationId.this.defaultValue() == null ? 0 : TicketFieldDefinitionClassificationId.this.defaultValue();
                if (ticket != null) {
                    classificationId = ticket.getClassificationID();
                }
                SelectOption option = new SelectOption(null, "");
                ClassificationVO classificationVO = (ClassificationVO)ClassificationManager.getInstance().get(classificationId);
                if (classificationVO != null) {
                    option = new SelectOption(String.valueOf(classificationId), classificationVO.getDisplayValue(), String.valueOf(classificationVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionClassificationId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionClassificationId.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<ClassificationVO> comparator = new Comparator<ClassificationVO>(){

                    @Override
                    public int compare(ClassificationVO o1, ClassificationVO o2) {
                        return o1.getDisplayValue().compareToIgnoreCase(o2.getDisplayValue());
                    }
                };
                List calssifications = ClassificationManager.getInstance().getAll(true);
                calssifications.sort(comparator);
                for (ClassificationVO classificationVO : calssifications) {
                    String classificationDisplayValue = classificationVO.getDisplayValue();
                    if (classificationDisplayValue == null) {
                        classificationDisplayValue = "";
                    }
                    if (searchTerm != null && !classificationDisplayValue.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    list.add(new SelectOption(String.valueOf(classificationVO.getId()), classificationDisplayValue, String.valueOf(classificationVO.getId())));
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }
        };
    }

    public void setDefaultValue(@Nullable String value) {
        this.getField().setDefaultValue((Integer)this.getField().getFieldType().valueOf(value));
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

