/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionAutoCC
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionAutoCC(int prio) {
        super(Tickets.FIELD_AUTO_CC, true, false, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.SUPPORTER);
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String displayValue = ticket.getValue(Tickets.FIELD_AUTO_CC);
        displayValue = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat(displayValue);
        return displayValue;
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public String getEditHint(List<TicketVO> tickets) {
                if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
                    return null;
                }
                if (tickets != null && !tickets.isEmpty()) {
                    return Tickets.MSG.getMsg("field.autocc.description", new Object[0]);
                }
                return null;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String autocc = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat(values.get(this.getFieldKey()));
                if (autocc != null) {
                    ticketData.put(Tickets.FIELD_AUTO_CC, autocc);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String autocc = TicketFieldDefinitionAutoCC.normalizeEmailAddressesIntoLinesPreservingFormat(ticket.getValue(Tickets.FIELD_AUTO_CC));
                    values.put(this.getFieldKey(), String.valueOf(autocc));
                } else {
                    values.put(this.getFieldKey(), (String)TicketFieldDefinitionAutoCC.this.defaultValue());
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionAutoCC.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "textarea";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionAutoCC.this.getDisplayName();
            }
        };
    }

    public static String normalizeEmailAddressesIntoLinesPreservingFormat(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String[] parts = input.split("(,|;|\\r?\\n)+(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        ArrayList<String> normalizedEmails = new ArrayList<String>();
        for (String part : parts) {
            String trimmedPart = part.trim();
            if (trimmedPart.isEmpty()) continue;
            normalizedEmails.add(trimmedPart);
        }
        return String.join((CharSequence)"\n", normalizedEmails).replaceAll(">([^\n])", ">\n$1");
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_TEXT;
    }
}

