/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.config.Freifeld;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class CustomFieldDefinitionEditInformations {
    private static final ConfigValue<FreifeldSettingList> FREIFELDER = new ConfigValue(HDConfigKeys.FREIFELDER);

    public static FreifeldSetting getEditInformation(UserAccount account, Field<?> field) {
        return CustomFieldDefinitionEditInformations.getEditInformation(account, CustomFieldDefinitionEditInformations.getCorrespondingFreifeld(field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FreifeldSetting getEditInformation(UserAccount account, Freifeld freifeld) {
        FreifeldSettingList list = (FreifeldSettingList)FREIFELDER.get();
        FreifeldSetting currentSetting = null;
        for (FreifeldSetting freifeldSetting : list) {
            if (!freifeldSetting.getFreifeld().equals((Object)freifeld)) continue;
            currentSetting = freifeldSetting;
        }
        if (currentSetting == null && freifeld == Freifeld.auftrag3) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            boolean hasEntries = false;
            try {
                con = connectionFactory.getConnection();
                final boolean isSupporter = account == null ? false : HDUsersAndGroups.isSupporter(account);
                Predicate<String> predicate = new Predicate<String>(){

                    @Override
                    public boolean test(String line) {
                        return isSupporter && line.startsWith("*") || line.startsWith("#");
                    }
                };
                if (account != null) {
                    String gebTxt;
                    stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");
                    stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
                    rs = stm.executeQuery();
                    if (rs.next() && (gebTxt = rs.getString(1)) != null) {
                        hasEntries = Arrays.stream(gebTxt.split("\\n")).filter(predicate).findAny().isPresent();
                    }
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            if (hasEntries) {
                currentSetting = new FreifeldSetting(freifeld);
            }
        }
        return currentSetting;
    }

    public static SelectOptionResult getData(UserAccount account, Field<?> field, boolean emptyValue) {
        return CustomFieldDefinitionEditInformations.getData(account, CustomFieldDefinitionEditInformations.getCorrespondingFreifeld(field), emptyValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL ist provided internally and is hard coded.")
    public static SelectOptionResult getData(UserAccount account, Freifeld freifeld, boolean emptyValue) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        FreifeldSettingList list = (FreifeldSettingList)FREIFELDER.get();
        FreifeldSetting currentSetting = null;
        for (FreifeldSetting freifeldSetting : list) {
            if (!freifeldSetting.getFreifeld().equals((Object)freifeld)) continue;
            currentSetting = freifeldSetting;
        }
        if (currentSetting != null) {
            String db = currentSetting.getDatabase();
            String command = currentSetting.getQueryName();
            boolean allowMulti = currentSetting.getFreifeldType() == FreifeldType.Multi;
            ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            if (emptyValue && !allowMulti) {
                options.add(new SelectOption("", ""));
            }
            try (Connection con = factory.getConnection();
                 PreparedStatement pst = con.prepareStatement("SELECT Abfrage FROM tblQueries WHERE AbfrageID = ?");){
                pst.setString(1, command);
                try (ResultSet rs = pst.executeQuery();){
                    if (!rs.next()) {
                        HDLogger.warn("Query '" + command + "' not found for field " + freifeld.name());
                        SelectOptionResult selectOptionResult = new SelectOptionResult(options.size(), options);
                        return selectOptionResult;
                    }
                    String query = rs.getString("Abfrage");
                    try (Connection c2 = factory.getConnection(db);
                         PreparedStatement pstQuery = c2.prepareStatement(query);
                         ResultSet rsQuery = pstQuery.executeQuery();){
                        while (rsQuery.next()) {
                            String key = rsQuery.getString(1);
                            if (StringFunctions.isEmpty((String)key)) continue;
                            options.add(new SelectOption(key, key));
                        }
                    }
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        }
        if (freifeld != Freifeld.auftrag3) return new SelectOptionResult(options.size(), options);
        if (account == null) return new SelectOptionResult(options.size(), options);
        final boolean isSupporter = HDUsersAndGroups.isSupporter(account);
        Predicate<String> predicate = new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return isSupporter && line.startsWith("*") || line.startsWith("#");
            }
        };
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");){
            stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
            try (ResultSet rs = stm.executeQuery();){
                if (!rs.next()) return new SelectOptionResult(options.size(), options);
                String gebTxt = rs.getString(1);
                if (gebTxt == null) return new SelectOptionResult(options.size(), options);
                List labels = Arrays.stream(gebTxt.split("\\n")).filter(predicate).collect(Collectors.toList());
                Iterator iterator = labels.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    string = string.substring(1).trim();
                    options.add(new SelectOption(string, string));
                }
                return new SelectOptionResult(options.size(), options);
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        return new SelectOptionResult(options.size(), options);
    }

    private static Freifeld getCorrespondingFreifeld(Field<?> field) {
        if (field instanceof TicketField) {
            switch (field.getKey()) {
                case "custom1": {
                    return Freifeld.auftrag1;
                }
                case "custom2": {
                    return Freifeld.auftrag2;
                }
                case "custom3": {
                    return Freifeld.auftrag3;
                }
                case "custom4": {
                    return Freifeld.auftrag4;
                }
                case "custom5": {
                    return Freifeld.auftrag5;
                }
                case "custom6": {
                    return Freifeld.auftrag6;
                }
                case "custom7": {
                    return Freifeld.auftrag7;
                }
                case "identifier": {
                    return Freifeld.kennung;
                }
            }
        } else if (field instanceof UserField) {
            switch (field.getKey()) {
                case "custom1": {
                    return Freifeld.benutzer1;
                }
                case "custom2": {
                    return Freifeld.benutzer2;
                }
                case "custom3": {
                    return Freifeld.benutzer3;
                }
                case "custom4": {
                    return Freifeld.benutzer4;
                }
                case "custom5": {
                    return Freifeld.benutzer5;
                }
                case "department": {
                    return Freifeld.abteilung;
                }
            }
        }
        return null;
    }
}

