/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.CustomFieldDefinitionEditInformations;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldOpenField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@InternalApi
public class AbstractTicketFieldDefinitionForCustomFields<T>
extends CustomTicketFieldDefinition<T>
implements TicketFieldDefinitionHDCore {
    private TicketFieldOpenField<T> fieldInstance;

    public AbstractTicketFieldDefinitionForCustomFields(TicketFieldOpenField<T> fieldInstance, GenericFieldSetting settings) {
        super(fieldInstance, settings);
        this.fieldInstance = fieldInstance;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        T value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return this.fieldInstance.valueToString(value);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        if (this.fieldInstance.getFieldType() instanceof FieldTypeString || this.fieldInstance.getFieldType() instanceof FieldTypeSelect_String) {
            Comparator comp = String.CASE_INSENSITIVE_ORDER;
            Comparator nullsFirst = Comparator.nullsFirst(comp);
            return (a, b) -> nullsFirst.compare(a.getForKey(this.getKey()), b.getForKey(this.getKey()));
        }
        return super.getComparator();
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), this.fieldInstance);
        if (editInformation == null) {
            return super.getEditDefinition();
        }
        if (editInformation.getFreifeldType() == FreifeldType.Multi) {
            return this.getSelectEditDefinition(this.fieldInstance, true, false);
        }
        if (editInformation.getFreifeldType() == FreifeldType.Editable) {
            return this.getSelectEditDefinition(this.fieldInstance, false, true);
        }
        return this.getSelectEditDefinition(this.fieldInstance, false, false);
    }

    protected SelectEditDefinition getSelectEditDefinition(final TicketFieldOpenField field, final boolean multi, final boolean customValues) {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    if (multi) {
                        ticketData.put(field, value);
                    } else {
                        SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                        String valueString = selectOption.getValue();
                        if (!StringFunctions.isEmpty((String)valueString)) {
                            ticketData.put(field, valueString);
                        } else {
                            ticketData.put(field, null);
                        }
                    }
                } else {
                    ticketData.put(field, null);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (multi) {
                    if (ticket != null) {
                        String custom = (String)ticket.getValue(field);
                        values.put(this.getFieldKey(), String.valueOf(custom));
                    } else {
                        values.put(this.getFieldKey(), "");
                    }
                } else {
                    String custom = null;
                    SelectOption option = new SelectOption("", "");
                    if (ticket != null && (custom = (String)ticket.getValue(field)) != null) {
                        option = new SelectOption(custom, custom);
                    }
                    values.put(this.getFieldKey(), new Json().toJson((Object)option));
                }
            }

            @Override
            public String getFieldKey() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getKey();
            }

            @Override
            public String getDisplayType() {
                if (multi) {
                    return "selectmulti";
                }
                if (customValues) {
                    return "selecteditable";
                }
                return "select";
            }

            @Override
            public String getDisplayName() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                SelectOptionResult data = CustomFieldDefinitionEditInformations.getData(UserManager.getInstance().getCurrentUserAccount(), field, true);
                if (data != null) {
                    List allOptions = data.getOptions();
                    for (SelectOption option : allOptions) {
                        String label = option.getLabel();
                        if (label == null) {
                            label = "";
                        }
                        if (searchTerm != null && !label.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                        list.add(option);
                    }
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }
        };
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), this.fieldInstance);
        if (editInformation == null) {
            return FieldSettingsType.TYPE_TEXT;
        }
        return FieldSettingsType.TYPE_SELECT;
    }
}

