/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.extension;

import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtensionUtils {
    public static void escalateTicketSilently(OperationChangedTicket ticket, @Nonnull UserGroupInfo targetResource, long lastChanged) {
        GUID oldResID = ticket.getOldTicket().get().getResourceID();
        String description = ExtensionUtils.buildResourceChangeText(oldResID, targetResource.getID());
        MutableReaStepData reaStepData = new MutableReaStepData();
        reaStepData.put(ReaStepVO.FIELD_DESC, description);
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(lastChanged));
        ticket.getNewTicketData().put(Tickets.FIELD_RESOURCE_GUID, targetResource.getID());
        ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, lastChanged);
        ticket.addReaStep(8, reaStepData, null);
    }

    @Nonnull
    public static String getResourceDisplayName(@Nullable GUID resID) {
        String displayValue = Tickets.FIELD_RESOURCE_GUID.getFieldType().getDisplayValue((Object)resID);
        return displayValue == null ? "" : displayValue;
    }

    @Nonnull
    public static String buildResourceChangeText(@Nullable GUID oldRes, @Nullable GUID newRes) {
        String oldResourceName = ExtensionUtils.getResourceDisplayName(oldRes);
        String arrow = " -> ";
        String newResourceName = ExtensionUtils.getResourceDisplayName(newRes);
        if (oldResourceName.length() + arrow.length() + newResourceName.length() > 255) {
            int exceeding = oldResourceName.length() + arrow.length() + newResourceName.length() - 255;
            int removeFromOld = exceeding * oldResourceName.length() / (newResourceName.length() + oldResourceName.length()) + 1;
            int removeFromNew = exceeding * newResourceName.length() / (newResourceName.length() + oldResourceName.length()) + 1;
            oldResourceName = oldResourceName.substring(removeFromOld);
            newResourceName = newResourceName.substring(removeFromNew);
        }
        return oldResourceName + arrow + newResourceName;
    }
}

