/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings.fields;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.LinkField;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionLink
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore,
TicketFieldDefinitionWithHyperlink {
    private GenericFieldSetting settings;

    public TicketFieldDefinitionLink(GenericFieldSetting settings) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, settings.getKey(), true, false, settings.getSortPriority());
        this.settings = settings;
    }

    @Override
    public String getDisplayValue(@Nonnull TicketVO ticket) {
        return LinkField.buildTitle((GenericFieldSetting)this.settings, key -> this.getFieldDisplayValue(ticket, (String)key));
    }

    private String getFieldDisplayValue(TicketVO ticket, String key) {
        UserAccount userAccount;
        TicketField fieldByKey = Tickets.getFieldByKey(key);
        if (fieldByKey != null) {
            return fieldByKey.getFieldType().asString(ticket.getValue(fieldByKey));
        }
        TicketAttribute attribute = Tickets.getAttributeByKey(key);
        if (attribute != null) {
            return attribute.getFieldType().asString(ticket.getAttribute(attribute));
        }
        TicketFieldDefinition fieldDefinitionByKey = Tickets.getFieldDefinitionByKey(key);
        if (fieldDefinitionByKey != null) {
            if (fieldDefinitionByKey instanceof TicketFieldDefinitionLink) {
                return null;
            }
            return fieldDefinitionByKey.getDisplayValue(ticket);
        }
        if (key.startsWith("ticketowner.") && ticket.getOwnerID() != null && (userAccount = UserManager.getInstance().getUserAccount(ticket.getOwnerID())) != null) {
            UserField userField = UsersAndGroups.getFieldByKey((String)(key = key.substring("ticketowner.".length())));
            if (userField == null) {
                if (Objects.equals(key, "userid")) {
                    return userAccount.getID().toString();
                }
                return null;
            }
            return userField.getFieldType().asString(userAccount.getValue(userField));
        }
        return null;
    }

    @Override
    public boolean isLinkField() {
        return true;
    }

    @Override
    public String getHyperlink(@Nonnull TicketVO ticket) {
        return LinkField.buildLink((GenericFieldSetting)this.settings, key -> this.getFieldDisplayValue(ticket, (String)key));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_LINK;
    }
}

