/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.dataview;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.reporting.server.dataview.TemplateDataViewDefaultsHD;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataView_ITIL_Links
extends TemplateDataViewDefaultsHD {
    @Nonnull
    public String getExtensionName() {
        return "ItilLinks";
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        ArrayList<TemplateDataViewDefaults.Column> list = new ArrayList<TemplateDataViewDefaults.Column>();
        list.add(new TemplateDataViewDefaults.Column("tblItilLinks.MasterAufID", "Prim\u00e4r ID", 6));
        list.add(new TemplateDataViewDefaults.Column("tblItil.ItilBezeichnung", "ITIL-Bezeichnung Prim\u00e4r", 11));
        list.add(new TemplateDataViewDefaults.Column("tblAuftraege.DerBetreff", "Betreff Prim\u00e4r", 11));
        list.add(new TemplateDataViewDefaults.Column("tblItilLinks.SlaveAufID", "Sekund\u00e4r ID", 6));
        list.add(new TemplateDataViewDefaults.Column("tblItil2.ItilBezeichnung", "ITIL-Bezeichnung Sekund\u00e4r", 11));
        list.add(new TemplateDataViewDefaults.Column("tblAuftraege2.DerBetreff", "Betreff Sekund\u00e4r", 11));
        list.add(new TemplateDataViewDefaults.Column("qryAbrechnungProAuftrag.Startzeit", "Startzeit", 15));
        list.add(new TemplateDataViewDefaults.Column("qryAbrechnungProAuftrag.Endzeit", "Endzeit", 15));
        list.add(new TemplateDataViewDefaults.Column("@Benutzername", "Benutzer", 11));
        list.add(new TemplateDataViewDefaults.Column("tblGebaeude.GebBezeichnung", "Ort/Kunde", 11));
        list.add(new TemplateDataViewDefaults.Column("qryAbrechnungProAuftrag.Bearbeitungszeit", "Bearbeitungszeit in Min", 6));
        list.add(new TemplateDataViewDefaults.Column("qryAbrechnungProAuftrag.Kosten", "Kosten", 6));
        return list;
    }

    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            ArrayList<TableColumnData> list = new ArrayList<TableColumnData>();
            list.add(new TableColumnData("tblAuftraege.DerBetreff"));
            list.add(new TableColumnData("tblItilLinks.SlaveAufID", AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_INTEGER, List.of()));
            list.add(new TableColumnData("qryAbrechnungProAuftrag.Startzeit"));
            list.add(new TableColumnData("qryAbrechnungProAuftrag.Endzeit"));
            list.add(new TableColumnData("@Benutzername"));
            return (T)list.toArray(new TableColumnData[0]);
        }
        if (key == TABLE_GROUPS) {
            return (T)new GroupData[]{new GroupData("tblItilLinks.MasterAufID", SortOrder.ASCENDING, AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_INTEGER)};
        }
        return null;
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            DatabaseTables dbTables = engine.getDatabaseTables();
            Datasource hd = dbTables.createDatasource("HelpDesk");
            hd.setDataSourceConfiguration(DataSourceConfigurationManager.getDataSource((String)"HelpDesk"));
            TableSource auf1 = hd.createTableSource("tblAuftraege");
            TableSource auf2 = hd.createTableSource("tblAuftraege", "tblAuftraege2");
            TableSource itilLinks = hd.createTableSource("tblItilLinks");
            TableSource buendel = hd.createTableSource("tblBuendel");
            TableSource user = hd.createTableSource("tblUser");
            TableSource itil1 = hd.createTableSource("tblItil");
            TableSource itil2 = hd.createTableSource("tblItil", "tblItil2");
            TableSource orte = hd.createTableSource("tblGebaeude");
            TableSource kosten = hd.createTableSource("qryAbrechnungProAuftrag");
            itilLinks.addColumn("MasterAufID", 6);
            itil1.addColumn("ItilBezeichnung", 11);
            auf1.addColumn("DerBetreff", 11);
            itilLinks.addColumn("SlaveAufID", 6);
            itil2.addColumn("ItilBezeichnung", 11);
            auf2.addColumn("DerBetreff", 11);
            kosten.addColumn("Startzeit", 15);
            kosten.addColumn("Endzeit", 15);
            user.addColumn("UsrID", 6);
            engine.getFields().addFormulaField("Benutzername", " getUserDisplayName( {tblUser.UsrID} )", 0);
            orte.addColumn("GebBezeichnung", 11);
            kosten.addColumn("Bearbeitungszeit", 6);
            kosten.addColumn("Kosten", 6);
            this.join(dbTables, auf1, "AufID", itilLinks, "MasterAufID", 6);
            this.join(dbTables, auf1, "ItiID", itil1, "ItiID", 6);
            this.join(dbTables, auf2, "AufID", itilLinks, "SlaveAufID", 6);
            this.join(dbTables, auf2, "BunID", buendel, "BunID", 6);
            this.join(dbTables, auf2, "BunID", kosten, "BunID", 6);
            this.join(dbTables, auf2, "ItiID", itil2, "ItiID", 6);
            this.join(dbTables, auf2, "UsrID", user, "UsrID", 6, 23);
            this.join(dbTables, user, "GebID", orte, "GebID", 6, 23);
            this.setSelectionFormula(engine, filter);
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
             @Nonnull TemplateDataViewDefaults.Column> fields = new ArrayList<TemplateDataViewDefaults.Column>();
            fields.addAll(this.getAvailableColumns());
            return new SimpleDataView(fields, engine);
        }
        catch (ReportException e) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)e);
        }
    }
}

