/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.dataview;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.datasource.UserDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.dataview.DataViewConditions;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_TicketsWithUser;
import com.inet.helpdesk.core.reporting.server.dataview.TemplateDataViewDefaultsHD;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataView_GroupMembers
extends TemplateDataViewDefaultsHD {
    @Nonnull
    public String getExtensionName() {
        return "group_members";
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        DataSourceConfiguration userSourceCfg = DataSourceConfigurationManager.getDataSource((String)"HelpDeskUser");
        if (userSourceCfg == null) {
            throw new IllegalStateException("Datasource HelpDeskUser is missing");
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            return this.getFields(engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            ArrayList<TableColumnData> list = new ArrayList<TableColumnData>();
            list.add(new TableColumnData("UserAdhoc.username"));
            if (DataView_TicketsWithUser.userFieldIsVisible(HDUsersAndGroups.FIELD_LOCATION_ID)) {
                list.add(new TableColumnData("UserAdhoc." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey()));
            }
            if (DataView_TicketsWithUser.userFieldIsVisible(HDUsersAndGroups.FIELD_ROOM)) {
                list.add(new TableColumnData("UserAdhoc." + HDUsersAndGroups.FIELD_ROOM.getKey()));
            }
            return (T)list.toArray(new TableColumnData[list.size()]);
        }
        if (key == TABLE_GROUPS) {
            return (T)new GroupData[]{new GroupData("UserGroups.usergroupname", SortOrder.ASCENDING)};
        }
        if (key == FILTER_DEFINITION) {
            return (T)new DataFilter(List.of(List.of(new DataFilter.DataFilterEntry("UserGroups.grouptype", DataFilter.Operation.equals, HDUsersAndGroups.GROUPTYPEDEF_RESOURCE.getDisplayName(), null))));
        }
        return null;
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            List<// Could not load outer class - annotation placement on inner may be incorrect
             @Nonnull TemplateDataViewDefaults.Column> dataFields = this.getFields(engine);
            DatabaseTables dbTables = engine.getDatabaseTables();
            Datasource userSource = dbTables.getDatasource(0);
            TableSource tblGroupMembers = userSource.createTableSource("UserGroupMemberships");
            TableSource tblUser = dbTables.getTablesource("UserAdhoc");
            TableSource tblGroups = dbTables.getTablesource("UserGroups");
            this.join(dbTables, tblUser, "userGUID", tblGroupMembers, "userGUID", 11);
            this.join(dbTables, tblGroups, "usergroupid", tblGroupMembers, "usergroupid", 11, this.filterContainsUserFilters(filter) ? 21 : 23);
            DataViewConditions dataViewConditions = new DataViewConditions(filter == null ? new DataFilter(List.of()) : filter, List.of());
            String json = new Json().toJson((Object)dataViewConditions);
            UserDataSourceConfiguration.buildSearchExpressionFromFilter(dataViewConditions);
            HDReporting.setInputParameter(tblUser, "UserSearchPhrase", json);
            this.setSelectionFormula(engine, filter);
            return new SimpleDataView(dataFields, engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    private boolean filterContainsUserFilters(@Nullable DataFilter filter) {
        if (filter == null) {
            return false;
        }
        for (List len : filter.getFilterLists()) {
            for (DataFilter.DataFilterEntry en : len) {
                if (!en.getColumn().startsWith("UserAdhoc")) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    private @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getFields(@Nonnull Engine engine) throws ReportException {
        HDReporting.ColumnInfoWithLabel column;
        int dataType;
        String name;
        DataSourceConfiguration userSourceCfg = DataSourceConfigurationManager.getDataSource((String)"HelpDeskUser");
        if (userSourceCfg == null) {
            throw new IllegalStateException("Datasource HelpDeskUser is missing");
        }
        DatabaseTables dbTables = engine.getDatabaseTables();
        Datasource userSource = dbTables.getDatasource(0);
        userSource.setDataSourceConfiguration(userSourceCfg);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @Nonnull TemplateDataViewDefaults.Column> dataFields = new ArrayList<TemplateDataViewDefaults.Column>();
        DataFactory dataFactory = userSource.getDataFactory();
        TableSource ts = userSource.createTableSource("UserAdhoc");
        List columns = dataFactory.getColumns(ts);
        String alias = ts.getAlias() + ".";
        for (ColumnInfo col : columns) {
            name = col.getName();
            dataType = col.getDataType();
            ts.addColumn(name, dataType);
            if (col.getColumnType() != 3) continue;
            column = (HDReporting.ColumnInfoWithLabel)col;
            dataFields.add(new TemplateDataViewDefaults.Column(alias + name, column.getLabel(), dataType));
        }
        dataFactory = userSource.getDataFactory();
        ts = userSource.createTableSource("UserGroups");
        columns = dataFactory.getColumns(ts);
        alias = ts.getAlias() + ".";
        for (ColumnInfo col : columns) {
            name = col.getName();
            dataType = col.getDataType();
            ts.addColumn(name, dataType);
            if (col.getColumnType() != 3) continue;
            column = (HDReporting.ColumnInfoWithLabel)col;
            String label = column.getLabel();
            label = this.duplicated(label, dataFields);
            dataFields.add(new TemplateDataViewDefaults.Column(alias + name, label, dataType));
        }
        return dataFields;
    }

    private String duplicated(String label, List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> dataFields) {
        if (dataFields.stream().anyMatch(f -> f.getDisplayName().equals(label))) {
            return label + " " + ITicketDataSourceConfiguration.MSG.getMsg("suffix_duplicated_column_usergroup", new Object[0]);
        }
        return label;
    }

    @Nullable
    public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        if (filterColumn.startsWith("UserAdhoc")) {
            return DataView_GroupMembers.getSuggestedValuesForUserColumn(filterColumn, filterText);
        }
        if (filterColumn.startsWith("UserGroups")) {
            String key = filterColumn.substring("UserGroups".length() + 1);
            GroupFieldDefinition def = UsersAndGroups.getUserGroupFieldDefinitionByKey((String)key);
            if (def != null && def instanceof HasSelectOptions) {
                if (filterText.isEmpty()) {
                    filterText = null;
                }
                return ((HasSelectOptions)def).getSelectOptions(false).stream().map(o -> new LocalizedKey(o.getValue(), o.getLabel())).collect(Collectors.toList());
            }
            SearchTag searchTag = UserGroupManager.getInstance().getSearchEngine().getTag(key);
            if (searchTag != null) {
                if (!searchTag.isSuggestedTag()) {
                    Iterator valuesIterator = UserGroupManager.getInstance().getSearchEngine().createValuesIterator(searchTag, true);
                    ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
                    while (result.size() < 50 && valuesIterator.hasNext()) {
                        Optional<GroupTypeDef> first;
                        String val;
                        String next = (String)valuesIterator.next();
                        String display = val = next == null ? "" : next.toString();
                        if (key.equals("grouptype") && (first = ServerPluginManager.getInstance().get(GroupTypeDef.class).stream().filter(t -> t.getGroupType().getName().equals(val)).findFirst()).isPresent()) {
                            display = first.get().getDisplayName();
                        }
                        if (!val.toLowerCase().startsWith(filterText)) continue;
                        result.add(new LocalizedKey(display, display));
                    }
                    return result;
                }
                String term = searchTag.getDisplayName() + ":" + filterText;
                return UserGroupManager.getInstance().getSearchEngine().getSuggestedValues(term, null).stream().map(sv -> new LocalizedKey(String.valueOf(sv.getKey()), sv.getDisplayName())).toList();
            }
        }
        return null;
    }

    public static List<LocalizedKey> getSuggestedValuesForUserColumn(String filterColumn, String filterText) {
        String key = filterColumn.substring("UserAdhoc".length() + 1);
        UserFieldDefinition def = UsersAndGroups.getUserFieldDefinitionByKey((String)key);
        if (def != null) {
            if (!(def instanceof SelectUserFieldDefinition)) {
                String term = def.getLabel() + ":" + filterText;
                if (!UsersAndGroups.getFieldByKey((String)key).getSearchTag().isSuggestedTag()) {
                    Iterator valuesIterator = UserManager.getInstance().getSearchEngine().createValuesIterator(UsersAndGroups.getFieldByKey((String)key).getSearchTag(), true);
                    ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
                    while (result.size() < 50 && valuesIterator.hasNext()) {
                        String val;
                        String next = (String)valuesIterator.next();
                        String string = val = next == null ? "" : next.toString();
                        if (!val.toLowerCase().startsWith(filterText)) continue;
                        result.add(new LocalizedKey(val, val));
                    }
                    return result;
                }
                return UserManager.getInstance().getSearchEngine().getSuggestedValues(term, null).stream().map(sv -> {
                    String svKey = sv.getKey();
                    if (svKey.startsWith("value:")) {
                        svKey = svKey.substring("value:".length());
                    }
                    return new LocalizedKey(svKey, sv.getDisplayName());
                }).toList();
            }
            if (filterText.isEmpty()) {
                filterText = null;
            }
            return HDReporting.selectOptionsToLocalizedKeys(((SelectUserFieldDefinition)def).getOptions(null, filterText, 0, 50).getOptions());
        }
        return null;
    }
}

