/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.datasource;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.dataview.DataViewConditions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserDataSourceConfiguration
extends BaseDataFactory {
    public static final String PROMPT_USER_SEARCH_CONDITIONS = "UserSearchPhrase";
    private static final String TABLE_NAME_USER = "User";
    public static final String TABLE_NAME_USER_ADHOC = "UserAdhoc";
    public static final String TABLE_NAME_USER_GROUPS = "UserGroups";
    public static final String TABLE_NAME_USER_GROUP_MEMBERSHIPS = "UserGroupMemberships";
    public static final String COLUMN_USER_NAME = "username";
    public static final String COLUMN_USER_ID = "userId";
    public static final String COLUMN_USER_GUID = "userGUID";
    public static final String COLUMN_USERGROUP_ID = "usergroupid";
    public static final String COLUMN_USERGROUP_NAME = "usergroupname";
    public static final String COLUMN_USERGROUP_TYPE = "grouptype";

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    public TableData getTableSourceData(final @Nonnull TableSource ts) throws ReportException {
        UserGroupManager ugm;
        SimpleResultSet rs;
        UserManager um;
        List prompts = ts.getInputParameters();
        final Set searchResult = switch (ts.getDatabaseIdentifier()) {
            case TABLE_NAME_USER -> {
                if (!prompts.isEmpty()) {
                    PromptField field = (PromptField)prompts.get(0);
                    GUID userGuid = (GUID)field.getValue();
                    yield Collections.singleton(userGuid);
                }
            }
            case TABLE_NAME_USER_ADHOC -> {
                Object value;
                String json;
                Optional<PromptField> promptField = ts.getInputParameters().stream().filter(f -> f.getName().equals(PROMPT_USER_SEARCH_CONDITIONS)).findFirst();
                UserManager um = UserManager.getInstance();
                if (promptField.isPresent() && !StringFunctions.isEmpty((String)(json = (String)(value = promptField.get().getValue())))) {
                    AndSearchExpression expression = UserDataSourceConfiguration.buildSearchExpressionFromFilter((DataViewConditions)new Json().fromJson(json, DataViewConditions.class));
                    SearchCommand command2 = new SearchCommand(new SearchExpression[]{expression});
                    command2.setResultLimit(10000);
                    yield um.searchAsUser(command2).getEntries().stream().map(e -> (GUID)e.getId()).collect(Collectors.toSet());
                }
                SearchCommand command = new SearchCommand(new SearchExpression[0]);
                command.setResultLimit(10000);
                yield um.searchAsUser(command).getEntries().stream().map(e -> (GUID)e.getId()).collect(Collectors.toSet());
            }
            case TABLE_NAME_USER_GROUP_MEMBERSHIPS -> {
                if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                    yield Set.of();
                }
            }
            case TABLE_NAME_USER_GROUPS -> {
                SearchCommand command2 = new SearchCommand(new SearchExpression[]{new SearchCondition("groupname", SearchCondition.SearchTermOperator.StartsWith, (Object)"")});
                yield UserGroupManager.getInstance().getSearchEngine().simpleSearch(command2);
            }
            default -> throw new UnsupportedOperationException(ts.getDatabaseIdentifier());
        };
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER)) {
            um = UserManager.getInstance();
            List<String> columns = this.getColumns(ts).stream().filter(c -> c.getColumnType() == 3).map(c -> c.getName()).collect(Collectors.toList());
            List fieldDefinitions = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
            final List userFields = fieldDefinitions.stream().filter(d -> d instanceof UserFieldDefinition && "user.masterdata".equals(d.getGroupKey()) && d.getFieldKey() != null).sorted((a, b) -> Integer.compare(a.getPriority(), b.getPriority())).collect(Collectors.toList());
            SimpleResultSet rs2 = new SimpleResultSet(columns.toArray(new String[columns.size()])){
                private final Iterator<GUID> ids;
                {
                    super(arg0);
                    this.ids = searchResult.iterator();
                }

                public boolean next() throws SQLException {
                    if (this.getRowCount() > 0) {
                        return super.next();
                    }
                    while (this.ids.hasNext()) {
                        GUID userGUID = this.ids.next();
                        UserAccount userAccount = um.getUserAccount(userGUID);
                        if (userAccount == null || !ts.getDatabaseIdentifier().equals(UserDataSourceConfiguration.TABLE_NAME_USER)) continue;
                        for (UserFieldDefinition d : userFields) {
                            if (!d.isAvailable(userAccount)) continue;
                            FieldValue fieldValue = d.getFieldValue(userAccount);
                            String value = UserDataSourceConfiguration.getStringRendererForFieldValue(d.getDisplayType(), fieldValue);
                            Object[] rowData = new Object[5];
                            rowData[0] = userGUID.toString();
                            rowData[1] = d.getLabel();
                            rowData[2] = d.getFieldKey();
                            rowData[3] = value;
                            if (value == null || value.isEmpty()) continue;
                            this.getAllRows().add(rowData);
                        }
                    }
                    return super.next();
                }
            };
            return new TableData((ResultSet)rs2);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_ADHOC)) {
            um = UserManager.getInstance();
            final List<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> cols = this.getColumnPairs(ts.getDatabaseIdentifier());
            rs = new SimpleResultSet(cols.stream().map(c -> ((HDReporting.ColumnInfoWithLabel)((Object)((Object)c.getValue()))).getName()).collect(Collectors.toList()).toArray(new String[cols.size()])){
                private final Iterator<GUID> ids;
                {
                    super(arg0);
                    this.ids = searchResult.iterator();
                }

                public boolean next() throws SQLException {
                    while (this.ids.hasNext()) {
                        GUID id = this.ids.next();
                        UserAccount user = um.getUserAccount(id);
                        if (user == null) continue;
                        Object[] rowData = new Object[cols.size()];
                        for (int i = 0; i < cols.size(); ++i) {
                            Map.Entry col = (Map.Entry)cols.get(i);
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_ID)) {
                                rowData[i] = HDUsersAndGroups.getUserID(user);
                                continue;
                            }
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_GUID)) {
                                rowData[i] = user.getID().toString();
                                continue;
                            }
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_NAME)) {
                                rowData[i] = user.getDisplayName();
                                continue;
                            }
                            if (((HDReporting.ColumnInfoWithLabel)((Object)col.getValue())).getColumnType() != 3) continue;
                            UserField field = UsersAndGroups.getFieldByKey((String)((String)col.getKey()));
                            rowData[i] = HDReporting.showDisplayValueForField(field) ? field.getFieldType().getDisplayValue(user.getValue(field)) : HDReporting.convertFieldValueToReportingValue(user.getValue(field), field);
                        }
                        this.getAllRows().add(rowData);
                        return super.next();
                    }
                    return false;
                }
            };
            return new TableData((ResultSet)rs);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUPS)) {
            ugm = UserGroupManager.getInstance();
            final List<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> cols = this.getColumnPairs(ts.getDatabaseIdentifier());
            rs = new SimpleResultSet(cols.stream().map(c -> ((HDReporting.ColumnInfoWithLabel)((Object)((Object)c.getValue()))).getName()).collect(Collectors.toList()).toArray(new String[cols.size()])){
                private final Iterator<GUID> ids;
                {
                    super(arg0);
                    this.ids = searchResult.iterator();
                }

                public boolean next() throws SQLException {
                    while (this.ids.hasNext()) {
                        GUID id = this.ids.next();
                        UserGroupInfo group = ugm.getGroup(id);
                        if (group == null) continue;
                        Object[] rowData = new Object[cols.size()];
                        block1: for (int i = 0; i < cols.size(); ++i) {
                            Map.Entry col = (Map.Entry)cols.get(i);
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_ID)) {
                                rowData[i] = id.toString();
                                continue;
                            }
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_NAME)) {
                                rowData[i] = group.getDisplayName();
                                if (group.getParentID() == null) continue;
                                rowData[i] = ugm.getGroup(group.getParentID()).getDisplayName() + "/" + String.valueOf(rowData[i]);
                                continue;
                            }
                            if (((String)col.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_TYPE)) {
                                for (GroupTypeDef typeDef : ServerPluginManager.getInstance().get(GroupTypeDef.class)) {
                                    GroupType groupType = typeDef.getGroupType();
                                    if (!group.getType().equals((Object)groupType)) continue;
                                    rowData[i] = typeDef.getDisplayName();
                                    continue block1;
                                }
                                continue;
                            }
                            if (((HDReporting.ColumnInfoWithLabel)((Object)col.getValue())).getColumnType() != 3) continue;
                            UserGroupField field = UsersAndGroups.getGroupFieldByKey((String)((String)col.getKey()));
                            rowData[i] = HDReporting.showDisplayValueForField(field) ? field.getFieldType().getDisplayValue(group.getValue(field)) : group.getValue(field);
                        }
                        this.getAllRows().add(rowData);
                        return super.next();
                    }
                    return false;
                }
            };
            return new TableData((ResultSet)rs);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUP_MEMBERSHIPS)) {
            ugm = UserGroupManager.getInstance();
            final List<ColumnInfo> cols = this.getColumns(ts);
            rs = new SimpleResultSet(cols.stream().map(c -> c.getName()).collect(Collectors.toList()).toArray(new String[cols.size()])){
                private final Iterator<GUID> ids;
                private List<GUID> moreRows;
                private GUID groupID;
                {
                    super(arg0);
                    this.ids = searchResult.iterator();
                    this.moreRows = List.of();
                }

                public boolean next() throws SQLException {
                    if (this.moreRows.isEmpty()) {
                        while (this.ids.hasNext()) {
                            GUID id = this.ids.next();
                            UserGroupInfo group = ugm.getGroup(id);
                            if (group == null || id.equals((Object)HDUsersAndGroups.GROUPID_ENDUSER)) continue;
                            Set memberIDs = group.getMemberIDs();
                            if (memberIDs.isEmpty()) {
                                if (group.getParentID() != null) {
                                    memberIDs = ugm.getGroup(group.getParentID()).getMemberIDs();
                                }
                                if (memberIDs.isEmpty()) continue;
                            }
                            this.moreRows = new ArrayList<GUID>(memberIDs);
                            this.groupID = id;
                            break;
                        }
                        if (this.moreRows.isEmpty()) {
                            return false;
                        }
                    }
                    Object[] rowData = new Object[cols.size()];
                    GUID id = this.moreRows.remove(0);
                    for (int i = 0; i < cols.size(); ++i) {
                        ColumnInfo col = (ColumnInfo)cols.get(i);
                        if (col.getName().equals(UserDataSourceConfiguration.COLUMN_USER_GUID)) {
                            rowData[i] = id.toString();
                            continue;
                        }
                        if (!col.getName().equals(UserDataSourceConfiguration.COLUMN_USERGROUP_ID)) continue;
                        rowData[i] = this.groupID.toString();
                    }
                    this.getAllRows().add(rowData);
                    return super.next();
                }
            };
            return new TableData((ResultSet)rs);
        }
        throw new ReportException("Unknown database table: " + ts.getDatabaseIdentifier(), ReportErrorCode.invalidDataSourceFile.getErrorCodeNumber());
    }

    private static String getStringRendererForFieldValue(String type, FieldValue value) {
        TakeoutDataRenderer renderer = null;
        try {
            renderer = (TakeoutDataRenderer)ServerPluginManager.getInstance().getSingleInstanceByName(TakeoutDataRenderer.class, type, true);
        }
        catch (IllegalStateException e) {
            HDLogger.error(e);
            return "";
        }
        return renderer.render(value);
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Map.of(TABLE_NAME_USER, new TableSourceInfo(null, null, TABLE_NAME_USER, 20), TABLE_NAME_USER_ADHOC, new TableSourceInfo(null, null, TABLE_NAME_USER_ADHOC, 20), TABLE_NAME_USER_GROUPS, new TableSourceInfo(null, null, TABLE_NAME_USER_GROUPS, 20), TABLE_NAME_USER_GROUP_MEMBERSHIPS, new TableSourceInfo(null, null, TABLE_NAME_USER_GROUP_MEMBERSHIPS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        List<Object> cols = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER)) {
            cols.add(new ColumnInfo("UserGUID", 11));
            cols.add(new ColumnInfo("Label", 11));
            cols.add(new ColumnInfo("FieldKey", 11));
            cols.add(new ColumnInfo("Value", 11));
            cols.add(new ColumnInfo("UserGUID", 11, 1, 12, 0));
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_ADHOC)) {
            cols = this.getColumnPairs(ts.getDatabaseIdentifier()).stream().map(p -> (HDReporting.ColumnInfoWithLabel)((Object)((Object)p.getValue()))).collect(Collectors.toList());
            cols.add(new ColumnInfo(PROMPT_USER_SEARCH_CONDITIONS, 11, 1, 12, 0));
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUPS)) {
            cols = this.getColumnPairs(ts.getDatabaseIdentifier()).stream().map(p -> (HDReporting.ColumnInfoWithLabel)((Object)((Object)p.getValue()))).collect(Collectors.toList());
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUP_MEMBERSHIPS)) {
            cols.add(new ColumnInfo(COLUMN_USER_GUID, 11));
            cols.add(new ColumnInfo(COLUMN_USERGROUP_ID, 11));
        }
        return cols;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> getColumnPairs(String table) {
        ArrayList<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> cols = new ArrayList<Map.Entry<String, HDReporting.ColumnInfoWithLabel>>();
        if (table.equals(TABLE_NAME_USER_ADHOC)) {
            cols.add(Map.entry(COLUMN_USER_ID, new HDReporting.ColumnInfoWithLabel(COLUMN_USER_ID, ITicketDataSourceConfiguration.MSG.getMsg("column_userid", new Object[0]), 6)));
            cols.add(Map.entry(COLUMN_USER_GUID, new HDReporting.ColumnInfoWithLabel(COLUMN_USER_GUID, ITicketDataSourceConfiguration.MSG.getMsg("column_userguid", new Object[0]), 11)));
            cols.add(Map.entry(COLUMN_USER_NAME, new HDReporting.ColumnInfoWithLabel(COLUMN_USER_NAME, ITicketDataSourceConfiguration.MSG.getMsg("column_username", new Object[0]), 11)));
        } else if (table.equals(TABLE_NAME_USER_GROUPS)) {
            cols.add(Map.entry(COLUMN_USERGROUP_ID, new HDReporting.ColumnInfoWithLabel(COLUMN_USERGROUP_ID, ITicketDataSourceConfiguration.MSG.getMsg("column_usergroupid", new Object[0]), 11)));
            cols.add(Map.entry(COLUMN_USERGROUP_NAME, new HDReporting.ColumnInfoWithLabel(COLUMN_USERGROUP_NAME, ITicketDataSourceConfiguration.MSG.getMsg("column_usergroupname", new Object[0]), 11)));
            cols.add(Map.entry(COLUMN_USERGROUP_TYPE, new HDReporting.ColumnInfoWithLabel(COLUMN_USERGROUP_TYPE, ITicketDataSourceConfiguration.MSG.getMsg("column_usergrouptype", new Object[0]), 11)));
        }
        @Nonnull List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Collections.sort(list, (d1, d2) -> d1.getPriority() - d2.getPriority());
        for (FieldDefinition fieldDef : list) {
            if (fieldDef.getDisplayType() == null || table.equals(TABLE_NAME_USER_ADHOC) && fieldDef.getGroupingType() != Type.user || table.equals(TABLE_NAME_USER_GROUPS) && fieldDef.getGroupingType() != Type.group || fieldDef.getFieldKey() == null || fieldDef.getLabel() == null || fieldDef instanceof UserFieldDefinition && !((UserFieldDefinition)fieldDef).isAvailable(null) || fieldDef instanceof GroupFieldDefinition && !((GroupFieldDefinition)fieldDef).isAvailable(null)) continue;
            UserField field = null;
            if (table.equals(TABLE_NAME_USER_ADHOC)) {
                field = UsersAndGroups.getFieldByKey((String)fieldDef.getFieldKey());
            } else if (table.equals(TABLE_NAME_USER_GROUPS)) {
                field = UsersAndGroups.getGroupFieldByKey((String)fieldDef.getFieldKey());
            }
            if (field == null) {
                HDLogger.debug("No field for def " + fieldDef.getFieldKey());
                continue;
            }
            if (HDReporting.showDisplayValueForField(field)) {
                cols.add(Map.entry(fieldDef.getFieldKey(), new HDReporting.ColumnInfoWithLabel(fieldDef.getFieldKey(), fieldDef.getLabel(), 11)));
                continue;
            }
            int reportFieldType = HDReporting.apiFieldTypeToReportFieldType(field);
            cols.add(Map.entry(fieldDef.getFieldKey(), new HDReporting.ColumnInfoWithLabel(fieldDef.getFieldKey(), fieldDef.getLabel(), reportFieldType)));
        }
        return cols;
    }

    public static AndSearchExpression buildSearchExpressionFromFilter(@Nonnull DataViewConditions filter) {
        return HDReporting.buildSearchPhraseExpression(filter, TABLE_NAME_USER_ADHOC, key -> UsersAndGroups.getFieldByKey((String)key), UserManager.getInstance().getSearchEngine());
    }
}

