/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.reporting.server.dataview.DataViewConditions;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.report.DefaultValue;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.database.ColumnInfo;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class HDReporting {
    public static final String DATASOURCE_USERS = "HelpDeskUser";
    public static final String DATASOURCE_TICKETS = "HelpDeskTickets";

    public static int apiFieldTypeToReportFieldType(Field<?> field) {
        int reportFieldType = field.getFieldType() instanceof FieldTypeDate ? (((FieldTypeDate)field.getFieldType()).isDateWithTime() ? 15 : 9) : (field.getFieldType() instanceof FieldTypeString ? 11 : (field.getFieldType() instanceof FieldTypeBoolean ? 8 : (field.getFieldType() instanceof FieldTypeInteger ? 6 : (field.getFieldType() instanceof FieldTypeSelect_Int ? 6 : (field.getFieldType() instanceof FieldTypeSelect_String ? 11 : (field.getFieldType() instanceof FieldTypeGUID ? 11 : (field.getFieldType() instanceof FieldTypeTime ? 10 : (field.getFieldType() instanceof FieldTypeCurrency ? 7 : (field.getFieldType() instanceof FieldTypeDouble ? 6 : 11)))))))));
        return reportFieldType;
    }

    public static AndSearchExpression buildSearchPhraseExpression(@Nonnull DataViewConditions filter, String tableAlias, Function<String, Field<?>> hasSearchTag, @Nonnull IndexSearchEngine<?> searchEngine) {
        AndSearchExpression globalAnd = new AndSearchExpression();
        if (!filter.getFilter().getFilterLists().isEmpty()) {
            OrSearchExpression filterOr = new OrSearchExpression();
            Iterator iterator = filter.getFilter().getFilterLists().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                AndSearchExpression and = new AndSearchExpression();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    DataFilter.DataFilterEntry filterEntry = (DataFilter.DataFilterEntry)iterator2.next();
                    SearchExpression expression = HDReporting.getExpressionForAdhocCondition(filterEntry, tableAlias, hasSearchTag, searchEngine);
                    if (expression == null) continue;
                    and.add(expression);
                    iterator2.remove();
                }
                HDReporting.convertConditionWithSameField(and);
                if (!and.isEmpty()) {
                    filterOr.add((Object)and);
                }
                if (!list.isEmpty()) continue;
                iterator.remove();
            }
            if (!filterOr.isEmpty()) {
                globalAnd.add((SearchExpression)filterOr);
            }
        }
        if (!filter.getConditionsFromView().isEmpty()) {
            for (DataFilter.DataFilterEntry entry : filter.getConditionsFromView()) {
                SearchExpression expression = HDReporting.getExpressionForAdhocCondition(entry, tableAlias, hasSearchTag, searchEngine);
                if (expression == null) continue;
                globalAnd.add(expression);
            }
        }
        return globalAnd;
    }

    @Nullable
    private static SearchExpression getExpressionForAdhocCondition(DataFilter.DataFilterEntry filterEntry, String tableAlias, Function<String, Field<?>> hasSearchTag, @Nonnull IndexSearchEngine<?> searchEngine) {
        String column = filterEntry.getColumn();
        if (column.startsWith(tableAlias)) {
            SearchCondition.SearchTermOperator op;
            String leftOperand = column.substring(tableAlias.length() + 1);
            Field<?> field = hasSearchTag.apply(leftOperand);
            if (field == null || field.getSearchTag() == null) {
                return null;
            }
            Object value = filterEntry.getValue();
            if (value != null) {
                FieldType fieldType = field.getFieldType();
                if (fieldType instanceof FieldTypeBoolean) {
                    value = "true".equals(value) ? Integer.valueOf(1) : Integer.valueOf(0);
                } else {
                    try {
                        value = fieldType.valueOf(filterEntry.getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean isOwnerField = field.getKey().contains("owner") && field.getFieldType() instanceof FieldTypeGUID;
            boolean isToStringConvertedField = HDReporting.showDisplayValueForField(field) && !(field.getFieldType() instanceof FieldTypeString) && !isOwnerField;
            switch (filterEntry.getOperation()) {
                case contains: {
                    op = SearchCondition.SearchTermOperator.Contains;
                    if (!isToStringConvertedField) break;
                    return null;
                }
                case equals: {
                    op = SearchCondition.SearchTermOperator.Equals;
                    break;
                }
                case greaterthan: {
                    op = SearchCondition.SearchTermOperator.GT;
                    break;
                }
                case greaterthanequals: {
                    op = SearchCondition.SearchTermOperator.GE;
                    break;
                }
                case inrange: {
                    op = SearchCondition.SearchTermOperator.BETWEEN;
                    break;
                }
                case lessthan: {
                    op = SearchCondition.SearchTermOperator.LT;
                    break;
                }
                case lessthanequals: {
                    op = SearchCondition.SearchTermOperator.LE;
                    break;
                }
                case notequals: {
                    op = SearchCondition.SearchTermOperator.Unequals;
                    break;
                }
                case startswith: {
                    op = SearchCondition.SearchTermOperator.StartsWith;
                    if (!isToStringConvertedField) break;
                    return null;
                }
                case notinrange: {
                    op = SearchCondition.SearchTermOperator.NOT_BETWEEN;
                    if (!isToStringConvertedField) break;
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (op == SearchCondition.SearchTermOperator.Equals && (value == null || "".equals(value))) {
                return new PhraseSearchExpression(leftOperand, op, "", Set.of());
            }
            if (isOwnerField) {
                if (op == SearchCondition.SearchTermOperator.BETWEEN || op == SearchCondition.SearchTermOperator.NOT_BETWEEN) {
                    return null;
                }
                JoinTokenMatcher matcher = new JoinTokenMatcher(searchEngine, field.getSearchTag(), UserManager.getInstance().getSearchEngine(), UserManager.getInstance().getSearchEngine().getTag("useraccountdisplayname"), false);
                return matcher.createSearchExpression(filterEntry.getValue(), op, false, false);
            }
            if (op == SearchCondition.SearchTermOperator.BETWEEN || op == SearchCondition.SearchTermOperator.NOT_BETWEEN) {
                return new SearchCondition(leftOperand, op, (Object)new Object[]{value, filterEntry.getSecondValue()});
            }
            if (op == SearchCondition.SearchTermOperator.Unequals && (value == null || "".equals(value))) {
                return new SearchCondition(leftOperand, SearchCondition.SearchTermOperator.StartsWith, (Object)"");
            }
            if (value instanceof String && value.toString().contains(" ")) {
                Set tokens = TextSearchTokenizer.DEFAULT.tokens(value, 1);
                return new PhraseSearchExpression(leftOperand, op, value.toString(), (Collection)tokens);
            }
            return new SearchCondition(leftOperand, op, value);
        }
        return null;
    }

    private static void convertConditionWithSameField(AndSearchExpression topAnd) {
        SearchExpression sonderlocke;
        SearchCondition previous = null;
        ArrayList<SearchCondition> currentGroup = null;
        for (int i = 0; i < topAnd.size(); ++i) {
            SearchExpression se = (SearchExpression)topAnd.get(i);
            if (se instanceof SearchCondition) {
                SearchCondition condition = (SearchCondition)se;
                if (previous != null && Objects.equals(condition.getLeftOperand(), previous.getLeftOperand())) {
                    if (currentGroup == null) {
                        currentGroup = new ArrayList<SearchCondition>();
                        currentGroup.add(previous);
                    }
                    currentGroup.add(condition);
                    previous = condition;
                    continue;
                }
                if (currentGroup != null) {
                    SearchExpression sonderlocke2 = HDReporting.createExpressionForSameField(currentGroup);
                    if (sonderlocke2 != null) {
                        topAnd.removeAll(currentGroup);
                        topAnd.add(i - currentGroup.size() + 1, (Object)sonderlocke2);
                        i = i - currentGroup.size() + 1;
                    }
                    currentGroup = null;
                }
                previous = condition;
                continue;
            }
            previous = null;
        }
        if (currentGroup != null && (sonderlocke = HDReporting.createExpressionForSameField(currentGroup)) != null) {
            topAnd.removeAll(currentGroup);
            topAnd.add(sonderlocke);
        }
    }

    private static SearchExpression createExpressionForSameField(List<SearchCondition> currentGroup) {
        OrSearchExpression topOr = new OrSearchExpression();
        SearchCondition prev = null;
        AndSearchExpression innerAnd = null;
        for (SearchCondition searchCondition : currentGroup) {
            if (prev != null && HDReporting.isNotOperator(prev.getOperator()) && HDReporting.isNotOperator(searchCondition.getOperator())) {
                if (innerAnd == null) {
                    innerAnd = new AndSearchExpression();
                    innerAnd.add((SearchExpression)prev);
                    topOr.remove((Object)prev);
                    topOr.add((Object)innerAnd);
                }
                innerAnd.add((SearchExpression)searchCondition);
            } else {
                innerAnd = null;
                topOr.add((Object)searchCondition);
            }
            prev = searchCondition;
        }
        return topOr;
    }

    private static boolean isNotOperator(SearchCondition.SearchTermOperator op) {
        switch (op) {
            case Unequals: 
            case NOT_BETWEEN: {
                return true;
            }
            case BETWEEN: {
                break;
            }
            case Contains: {
                break;
            }
            case Equals: {
                break;
            }
            case GE: {
                break;
            }
            case GT: {
                break;
            }
            case IN: {
                break;
            }
            case LE: {
                break;
            }
            case LT: {
                break;
            }
            case StartsWith: {
                break;
            }
        }
        return false;
    }

    public static boolean showDisplayValueForField(Field<?> field) {
        if (field == null) {
            return true;
        }
        if (field.getKey().equals(Tickets.ATTRIBUTE_STATUS_ID.getKey())) {
            return true;
        }
        if (field.getKey().equals(HDUsersAndGroups.RES_FIELD_PARENT_ID.getKey()) && field instanceof UserGroupField) {
            return true;
        }
        if (field.getKey().equals(HDUsersAndGroups.RES_FIELD_ESC_RES_ID.getKey()) && field instanceof UserGroupField) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeDate) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeString) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeBoolean) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeInteger) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeSelect_Int) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeSelect_String) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeGUID) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeTime) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeCurrency) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeDouble) {
            return false;
        }
        return !(field.getFieldType() instanceof FieldTypeRating);
    }

    @Nullable
    public static Object convertFieldValueToReportingValue(@Nullable Object value, Field<?> field) {
        if (value == null) {
            return value;
        }
        if (field.getFieldType() instanceof FieldTypeGUID) {
            return ((GUID)value).toString();
        }
        if (field.getFieldType() instanceof FieldTypeTime) {
            try {
                String full = (String)value;
                int hours = Integer.valueOf(full.substring(0, 2));
                int minutes = Integer.valueOf(full.substring(3, 5));
                return new Time(hours, minutes, 0);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                return null;
            }
        }
        if (field.getFieldType() instanceof FieldTypeDate) {
            return new Date((Long)value);
        }
        if (field.getFieldType() instanceof FieldTypeRating) {
            return (double)((Integer)value).intValue() / 2.0;
        }
        return value;
    }

    public static List<LocalizedKey> selectOptionsToLocalizedKeys(List<SelectOption> options) {
        return options.stream().map(op -> new LocalizedKey(op.getValue(), op.getPath() != null ? op.getPath() : op.getLabel())).toList();
    }

    public static void setInputParameter(@Nonnull TableSource ts, @Nonnull String paramName, @Nonnull String value) throws ReportException {
        ts.setInputParameter(new String[]{paramName}, new int[]{11}, new Object[]{value});
        for (PromptField prompt : ts.getInputParameters()) {
            if (!paramName.equals(prompt.getName())) continue;
            prompt.addDefaultValue(new DefaultValue((Object)value, null, 11));
            prompt.setEditable(false);
        }
    }

    public static class ColumnInfoWithLabel
    extends ColumnInfo {
        private String label;

        public ColumnInfoWithLabel(@Nonnull String name, @Nonnull String label, int dataType) {
            super(name, dataType);
            this.label = Objects.requireNonNull(label);
        }

        @Nonnull
        public String getLabel() {
            return this.label;
        }
    }
}

