/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.permissions;

import com.inet.classloader.LoaderUtils;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.http.servlet.ClientLocale;
import com.inet.permissions.Permission;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PermissionInCategoryMapper {
    private static HashMap<String, String> ALTERNATIVE_CATEGORIES = new HashMap<String, String>(){
        {
            this.put("configuration", "helpDesk-administration");
            this.put("scheduler", "helpDesk-reports");
            this.put("taskplanner", "helpDesk-reports");
            this.put("taskplanner.admin", "helpDesk-reports");
            this.put("datasource", "helpDesk-reports");
            this.put("repository_browser", "helpDesk-reports");
            this.put("statistics", "helpDesk-administration");
            this.put("reporting", "helpDesk-reports");
            this.put("adhoc_service", "helpDesk-reports");
            this.put("interface_remotedatasources", "helpDesk-reports");
            this.put("remote_printing", "helpDesk-reports");
            this.put("interface_remotedesigner", "helpDesk-reports");
        }
    };

    public static String getCategoryKeyOfPermission(Permission permission) {
        String alternativeKey = ALTERNATIVE_CATEGORIES.get(permission.getKey());
        if (alternativeKey != null) {
            return alternativeKey;
        }
        return permission.getCategoryKey();
    }

    public static String getCategoryDisplayNameOfPermission(Permission permission) {
        String alternativeKey = ALTERNATIVE_CATEGORIES.get(permission.getKey());
        if (alternativeKey != null) {
            try {
                ResourceBundle bundle = LoaderUtils.getBundle((String)"com.inet.helpdesk.core.permissions.structure.i18n.ConfigStructure", (Locale)ClientLocale.getThreadLocale(), (Object)HdPermissions.class.getClassLoader());
                return bundle.getString("PermissionCategories." + alternativeKey);
            }
            catch (MissingResourceException missingResourceException) {
                return alternativeKey;
            }
        }
        return permission.getCategoryDisplayName();
    }
}

