/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.plugin.ServerPluginManager;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

@JsonData
public class Sorting {
    private SortField sortField;
    private SortType sortType = SortType.ORIGINAL;
    private String clientLanguage = "de";
    private long groupByLastSync;

    private Sorting() {
    }

    public Sorting(SortField sortField, SortType sortType, String clientLanguage) {
        this.sortField = sortField;
        this.sortType = sortType;
        this.clientLanguage = clientLanguage;
    }

    public SortField getSortField() {
        return this.sortField;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public String getClientLanguage() {
        return this.clientLanguage;
    }

    public long getGroupByLastSync() {
        return this.groupByLastSync;
    }

    public void setGroupByLastSync(long groupByLastSync) {
        this.groupByLastSync = groupByLastSync;
    }

    public <T> Comparator<T> getComparator(Class<T> clazz) {
        return new SortingComparator(this.sortField, this.sortType, new Locale(this.clientLanguage, Locale.getDefault().getCountry()), this.groupByLastSync);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sorting) {
            Sorting sorting = (Sorting)obj;
            boolean equals = true;
            equals &= this.clientLanguage == null ? sorting.clientLanguage == null : this.clientLanguage.equals(sorting.clientLanguage);
            equals &= this.sortField == null ? sorting.sortField == null : this.sortField.equals((Object)sorting.sortField);
            return equals &= this.sortType == null ? sorting.sortType == null : this.sortType.equals((Object)sorting.sortType);
        }
        return super.equals(obj);
    }

    public static enum SortType {
        ASCENDING,
        DESCENDING,
        ORIGINAL;

    }

    @JsonData
    public static enum SortField {
        LASTMODIFIED(true),
        UNREAD(false),
        PRIOID(true),
        STATUSID(true),
        TICKETOWNER(false),
        TICKETID(true),
        SUBJECT(false),
        CONTACTNAME(false),
        CATEGORY(true),
        CLASSIFICATION(false),
        RESOURCE(false),
        LOCATION(false),
        TICKETFIELD1(false),
        TICKETFIELD2(false),
        TICKETFIELD3(false),
        TICKETFIELD4(false);

        private final boolean sortableOnDB;

        private SortField(boolean sortableOnDB) {
            this.sortableOnDB = sortableOnDB;
        }

        public boolean isSortableOnDB() {
            return this.sortableOnDB;
        }
    }

    public static class SortingComparator<T>
    implements Comparator<T> {
        private final SortField sortField;
        private final SortType sortType;
        private final Locale locale;
        private long lastSync;

        public SortingComparator(SortField sortField, SortType sortType, Locale locale, long lastSync) {
            this.sortField = sortField;
            this.sortType = sortType;
            this.locale = locale;
            this.lastSync = lastSync;
        }

        @Override
        public int compare(T o1, T o2) {
            int classCompare;
            if (o1 == null) {
                return o2 == null ? 0 : (this.sortType == SortType.ASCENDING ? -1 : 1);
            }
            if (o2 == null) {
                return this.sortType == SortType.ASCENDING ? 1 : -1;
            }
            String c1 = o1.getClass().getName();
            String c2 = o2.getClass().getName();
            int n = classCompare = this.sortType == SortType.ASCENDING ? c1.compareToIgnoreCase(c2) : c2.compareToIgnoreCase(c1);
            if (classCompare != 0) {
                return classCompare;
            }
            if (this.lastSync > 0L && o1 instanceof Ticket && o2 instanceof Ticket) {
                Date d1 = ((Ticket)o1).getValue(Field.TICKETDATA_LASTMODIFIED, Date.class);
                Date d2 = ((Ticket)o2).getValue(Field.TICKETDATA_LASTMODIFIED, Date.class);
                if (d1 != null && d2 != null) {
                    if (d1.getTime() >= this.lastSync) {
                        if (d2.getTime() < this.lastSync) {
                            return -1;
                        }
                    } else if (d2.getTime() >= this.lastSync && d1.getTime() < this.lastSync) {
                        return 1;
                    }
                }
            }
            Comparable<?> comp1 = this.getComparableField(o1);
            Comparable<?> comp2 = this.getComparableField(o2);
            if (comp1 == null) {
                return comp2 == null ? 0 : (this.sortType == SortType.ASCENDING ? -1 : 1);
            }
            if (comp2 == null) {
                return this.sortType == SortType.ASCENDING ? 1 : -1;
            }
            int compareResult = 0;
            RuleBasedCollator collator = UtilityFunctions.getRuleBasedCollator(this.locale);
            if (comp1 instanceof String && comp2 instanceof String) {
                compareResult = this.sortType == SortType.ASCENDING ? collator.compare((String)((Object)comp1), (String)((Object)comp2)) : collator.compare((String)((Object)comp2), (String)((Object)comp1));
            } else {
                int n2 = compareResult = this.sortType == SortType.ASCENDING ? comp1.compareTo(comp2) : comp2.compareTo(comp1);
            }
            if (compareResult == 0) {
                if (o1 instanceof Ticket && o2 instanceof Ticket) {
                    int id1 = ((Ticket)o1).getId();
                    int id2 = ((Ticket)o2).getId();
                    return id2 - id1;
                }
                if (o1 instanceof User && o2 instanceof User) {
                    String uname1 = ((User)o1).getUserName();
                    String uname2 = ((User)o2).getUserName();
                    return collator.compare(uname1, uname2);
                }
            }
            return compareResult;
        }

        private Comparable<?> getComparableField(T obj) {
            if (obj instanceof Ticket) {
                Ticket ticket = (Ticket)obj;
                switch (this.sortField) {
                    case TICKETID: {
                        return ticket.getValue(Field.TICKETDATA_TICKETID, Integer.class);
                    }
                    case STATUSID: {
                        return ticket.getValue(Field.TICKETDATA_STATUSID, Integer.class);
                    }
                    case PRIOID: {
                        return ticket.getValue(Field.TICKETDATA_PRIORITYID, Integer.class);
                    }
                    case SUBJECT: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_SUBJECT, String.class));
                    }
                    case TICKETOWNER: {
                        User ticketOwner = ticket.getValue(Field.TICKETDATA_OWNER, User.class);
                        String value = ticketOwner.getValue(Field.USERDATA_LASTNAME, String.class);
                        if (value != null && value.length() > 0) {
                            return value;
                        }
                        return ticketOwner.getDisplayName();
                    }
                    case LASTMODIFIED: {
                        return ticket.getValue(Field.TICKETDATA_LASTMODIFIED, Date.class);
                    }
                    case UNREAD: {
                        int status = ticket.getValue(Field.TICKETDATA_STATUSID, Integer.class);
                        boolean isUnRead = status == 0 || status == 100 || status == 101;
                        return isUnRead;
                    }
                    case LOCATION: {
                        User ticketOwner = ticket.getValue(Field.TICKETDATA_OWNER, User.class);
                        String value = ticketOwner.getValue(Field.USERDATA_LOCATION_DISPLAYNAME, String.class);
                        if (value != null && value.length() > 0) {
                            return value;
                        }
                        return ticketOwner.getDisplayName();
                    }
                    case CATEGORY: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_CATEGORY, String.class));
                    }
                    case CLASSIFICATION: {
                        int classificationId = ticket.getValue(Field.TICKETDATA_CLASSIFICATIONID, Integer.class);
                        ClassificationVO classificationVO = (ClassificationVO)ClassificationManager.getInstance().get(classificationId);
                        if (classificationVO == null) {
                            HDLogger.debug("unknown classification id " + classificationId);
                            return "" + classificationId;
                        }
                        return classificationVO.getDisplayValue();
                    }
                    case RESOURCE: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, String.class));
                    }
                    case TICKETFIELD1: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_TICKETFIELD1, String.class));
                    }
                    case TICKETFIELD2: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_TICKETFIELD2, String.class));
                    }
                    case TICKETFIELD3: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_TICKETFIELD3, String.class));
                    }
                    case TICKETFIELD4: {
                        return (Comparable)((Object)ticket.getValue(Field.TICKETDATA_TICKETFIELD4, String.class));
                    }
                }
                return null;
            }
            if (obj instanceof User) {
                User user = (User)obj;
                switch (this.sortField) {
                    case CONTACTNAME: {
                        String value = user.getValue(Field.USERDATA_LASTNAME, String.class);
                        if (value == null || value.length() == 0) {
                            value = user.getDisplayName();
                        }
                        if (value == null || value.length() == 0) {
                            value = user.getUserName();
                        }
                        return value;
                    }
                }
                return null;
            }
            return null;
        }

        protected ServerValuesConnector getServerValuesConnector() {
            return (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
        }
    }

    @JsonData
    public static class TranslatedSortField {
        private SortField sortField;
        private String display;

        public TranslatedSortField() {
        }

        public TranslatedSortField(SortField sort, String display) {
            this.sortField = sort;
            this.display = display;
        }

        public String getDisplay() {
            return this.display;
        }

        public SortField getSortField() {
            return this.sortField;
        }
    }
}

