/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mailtemplates;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.mailtemplates.DefaultMailTemplates;
import com.inet.plugin.NamedExtension;

@InternalApi
public class MailTemplate
implements NamedExtension {
    private final String key;
    private String responseTo;
    private boolean includeProducer;
    private boolean subTemplate;
    private String typeDescription;

    public MailTemplate(String responseTo, String key, String typeDescription) {
        this(responseTo, key, typeDescription, false, false);
    }

    public MailTemplate(String responseTo, String key, String typeDescription, boolean includeProducer) {
        this(responseTo, key, typeDescription, includeProducer, false);
    }

    public MailTemplate(String responseTo, String key, String typeDescription, boolean includeProducer, boolean subTemplate) {
        this.responseTo = responseTo;
        this.key = key;
        this.typeDescription = typeDescription;
        this.includeProducer = includeProducer;
        this.subTemplate = subTemplate;
    }

    public String getExtensionName() {
        return this.key;
    }

    public String getDescription() {
        return DefaultMailTemplates.MSG.getMsg("mailtemplates.defaults." + this.key, new Object[0]);
    }

    public String getResponseTo() {
        return this.responseTo;
    }

    public boolean isIncludeProducer() {
        return this.includeProducer;
    }

    public boolean isSubTemplate() {
        return this.subTemplate;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }
}

