/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.stopwatch.StopWatchList;
import com.inet.helpdesk.config.stopwatch.StopWatchRule;
import com.inet.helpdesk.config.stopwatch.StopWatchSetting;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformations;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public interface TicketAccessInformationsProvider {
    public static final ConfigValue<StopWatchSetting> CONFIG_WATCH_STANDARD = new ConfigValue(HDConfigKeys.STOP_WATCH_STANDARD);
    public static final ConfigValue<StopWatchList> CONFIG_WATCH_RULES = new ConfigValue(HDConfigKeys.STOP_WATCH_RULES);
    public static final ConfigValue<Integer> CONFIG_WATCH_START_THRESHOLD = new ConfigValue(HDConfigKeys.STOP_WATCH_START_THRESHOLD);

    @Deprecated
    public TicketAccessInformations getTicketAccessInformations(int var1);

    public TicketAccessInfo getTicketAccessInfo(int var1);

    public void leaveTickets(String var1, int ... var2);

    public boolean accessTicketWrite(String var1, int var2);

    public void accessTicketRead(String var1, int var2);

    public void leaveAllTickets(String var1);

    public void removeTicketAccessChangedListener(TicketAccessChangedListener var1);

    public void addTicketAccessChangedListener(TicketAccessChangedListener var1);

    @Nullable
    public StopWatch getStopWatchInfo(int var1, String var2);

    public void cancelStopWatch(GUID var1, int var2);

    public void stopStopWatch(GUID var1, int var2);

    public boolean startStopWatch(GUID var1, int var2);

    public static boolean stopWatchIsActiveFor(@Nonnull UserAccount user, int bunId) {
        return TicketAccessInformationsProvider.getStopWatchSettingFor(user, TicketManager.getReader().getTicket(bunId)) != StopWatchSetting.OFF;
    }

    public static StopWatchSetting getStopWatchSettingFor(@Nonnull UserAccount user, TicketVO ticket) {
        try (UserAccountScope s = UserAccountScope.create((GUID)user.getID());){
            TicketPermissionContext permissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket);
            if (permissionInfo == null || !permissionInfo.hasSupporterWriteAccessToTicket()) {
                StopWatchSetting stopWatchSetting = StopWatchSetting.OFF;
                return stopWatchSetting;
            }
        }
        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
            return StopWatchSetting.OFF;
        }
        List list = (List)CONFIG_WATCH_RULES.get();
        for (StopWatchRule stopWatchEntry : list) {
            if (!stopWatchEntry.getCondition().matches(user, ticket)) continue;
            return stopWatchEntry.getSetting();
        }
        return (StopWatchSetting)((Object)CONFIG_WATCH_STANDARD.get());
    }

    public static class TicketStopWatchChangedEvent {
        private int ticketId;
        private GUID userId;
        @Nullable
        private StopWatch stopWatch;

        public TicketStopWatchChangedEvent(int ticketId, @Nullable StopWatch stopWatch, GUID userId) {
            this.ticketId = ticketId;
            this.stopWatch = stopWatch;
            this.userId = userId;
        }

        public int getTicketId() {
            return this.ticketId;
        }

        @Nullable
        public StopWatch getStopWatch() {
            return this.stopWatch;
        }

        public GUID getUserId() {
            return this.userId;
        }
    }

    @Immutable
    public static class StopWatch {
        private long startTime;
        private long activeTime;

        public StopWatch(long startTime, long activeTime) {
            this.startTime = startTime;
            this.activeTime = activeTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getActiveTime() {
            return this.activeTime;
        }
    }

    public static interface TicketAccessChangedListener {
        public void ticketAccessChanged(TicketAccessChangedEvent var1);

        default public void ticketStopWatchChanged(TicketStopWatchChangedEvent event) {
        }
    }

    public static class TicketAccessChangedEvent {
        private int ticketId;
        private TicketAccessInfo newAccessInfo;

        public TicketAccessChangedEvent(int ticketId, TicketAccessInfo newAccessInfo) {
            this.ticketId = ticketId;
            this.newAccessInfo = newAccessInfo;
        }

        public int getTicketId() {
            return this.ticketId;
        }

        @Nullable
        public TicketAccessInfo getNewAccessInfo() {
            return this.newAccessInfo;
        }
    }
}

