/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    private static final Path ATTACHMENTS_TEMP_PARENTDIR = TempDirectory.createTempAttachmentsParentDir();
    public static final String ATTACHMENTS_TEMP_DIRNAME = "Attachments_Temp";
    public static final Path ATTACHMENTS_TEMP = TempDirectory.createDir(ATTACHMENTS_TEMP_PARENTDIR, "Attachments_Temp");
    public static final Path ATTACHMENTS_PUFFER = TempDirectory.createDir(ATTACHMENTS_TEMP_PARENTDIR, "Attachments_Puffer");

    private static Path createTempAttachmentsParentDir() {
        try {
            Path dirInTempDir = Files.createTempDirectory("", new FileAttribute[0]);
            Path tempDir = dirInTempDir.getParent();
            Files.deleteIfExists(dirInTempDir);
            Configuration cfg = ConfigurationManager.getInstance().getCurrent();
            Object configName = cfg.getScope() == 4 ? "TempConfig" + String.valueOf(System.currentTimeMillis()) : cfg.getName();
            String parentDirName = "i-net HelpDesk Attachments (" + (String)configName + ")";
            Path parentDir = tempDir.resolve(parentDirName);
            return Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Path createDir(Path parentDir, String dirName) {
        try {
            return Files.createDirectories(parentDir.resolve(dirName), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

