/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.Position;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.StringFunctions;
import java.awt.Font;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;

@InternalApi
public class TicketTextFunctions {
    private static final ConfigValue<String> DEFAULT_TICKET_FONT_NAME_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_NAME);
    private static final ConfigValue<Integer> DEFAULT_TICKET_FONT_SIZE_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE);

    public static Font getDefaultFont() {
        String fontName = (String)DEFAULT_TICKET_FONT_NAME_VALUE.get();
        int fontSize = (Integer)DEFAULT_TICKET_FONT_SIZE_VALUE.get();
        if (StringFunctions.isEmpty((String)fontName)) {
            fontName = HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault();
        }
        if (fontSize <= 0) {
            fontSize = Integer.parseInt(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE.getDefault());
        }
        return new Font(fontName, 0, fontSize);
    }

    public static String prepareHtmlTextForSaving(String htmltext) {
        if (htmltext.isEmpty()) {
            return htmltext;
        }
        Object wrapped = "<html><head><style>p.hddefault{margin:0px;} img {max-width: 100%; height: auto !important;}</style></head><body";
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        if (defaultFont != null) {
            wrapped = (String)wrapped + " style=\"font-family:'" + defaultFont.getFamily() + "'; font-size: " + defaultFont.getSize() + "pt;\"";
        }
        wrapped = (String)wrapped + ">";
        wrapped = (String)wrapped + htmltext;
        wrapped = (String)wrapped + "</body>";
        wrapped = HtmlConverter.getCompactHtmlText((String)wrapped, null);
        return wrapped;
    }

    public static String convertToPlainText(String lightHtmlText) {
        return HtmlConverter.html2text((String)lightHtmlText);
    }

    public static String getLightHtmlFromPlainText(String plainText) {
        if (StringFunctions.isEmpty((String)plainText)) {
            return "<div>" + plainText + "</div>";
        }
        plainText = StringFunctions.encodeHTML((String)plainText, (boolean)false);
        StringBuilder htmlEntitiesConverted = new StringBuilder();
        for (int i = 0; i < plainText.length(); ++i) {
            char ch = plainText.charAt(i);
            if (ch > '\u007f') {
                htmlEntitiesConverted.append("&#");
                htmlEntitiesConverted.append(String.valueOf((int)ch));
                htmlEntitiesConverted.append(';');
                continue;
            }
            htmlEntitiesConverted.append(ch);
        }
        return "<div>" + htmlEntitiesConverted.toString().replace("\n", "<br>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replace("  ", "&nbsp;&nbsp;") + "</div>";
    }

    public static String getInlinedHtml(String htmlText, boolean wrapWithDefaultFont) {
        Font defaultFont;
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        doc.putProperty((Object)"IgnoreCharsetDirective", (Object)Boolean.TRUE);
        htmlText = htmlText.replace("<head>", "<head><style>p.hddefault { margin-top:0px; margin-bottom:0px; }</style>");
        try {
            doc.parse((Reader)new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        doc.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, (Object)0);
        StringWriter out = new StringWriter();
        Element element = ElementUtils.getBodyElement((InetHtmlDocument)doc);
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, element);
        writer.setInlineMode(true);
        writer.setAllowStyleSpan(false);
        writer.setEmptyBlockFiller("<br>");
        writer.setWriteSelectedElementOnly(true);
        writer.registerAttributeFilter(new InetHtmlWriter.AttributeFilter(){

            public Object filterAttributeValue(Object elementName, Object key, Object value, AttributeSet elementAttributes, Element element) {
                if (key == CSS.Attribute.POSITION && (Position.getPosition((byte)2).equals(value) || Position.getPosition((byte)3).equals(value))) {
                    value = Position.getPosition((byte)0);
                }
                return super.filterAttributeValue(elementName, key, value, elementAttributes, element);
            }
        });
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        Object textContent = out.toString();
        String rootURL = SessionStore.getRootURL();
        if (rootURL != null) {
            if (((String)textContent).indexOf("src=\"Attachment") != -1) {
                textContent = ((String)textContent).replace("src=\"Attachment", "src=\"" + rootURL + "Attachment");
            }
            if (((String)textContent).indexOf("href=\"Attachment") != -1) {
                textContent = ((String)textContent).replace("href=\"Attachment", "href=\"" + rootURL + "Attachment");
            }
        }
        if (wrapWithDefaultFont && !((String)textContent).isEmpty() && (defaultFont = TicketTextFunctions.getDefaultFont()) != null) {
            textContent = "<div style=\"font-family:'" + defaultFont.getFamily() + "'; font-size: " + defaultFont.getSize() + "pt;\">" + (String)textContent + "</div>";
        }
        return textContent;
    }

    public static String correctAttachmentPathesForServer(String textContent) {
        String rootURL = SessionStore.getRootURL();
        if (rootURL != null && !StringFunctions.isEmpty((String)textContent)) {
            if (textContent.indexOf("src=\"" + rootURL + "Attachment") != -1) {
                textContent = textContent.replace("src=\"" + rootURL + "Attachment", "src=\"Attachment");
            }
            if (textContent.indexOf("href=\"" + rootURL + "Attachment") != -1) {
                textContent = textContent.replace("href=\"" + rootURL + "Attachment", "href=\"Attachment");
            }
        }
        return textContent;
    }
}

