/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.stopwatch;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.stopwatch.ConditionType;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonData
public class StopWatchCondition {
    private ConditionType type;
    private GUID parameter;

    public StopWatchCondition(ConditionType type, @Nullable GUID parameter) {
        this.type = type;
        this.parameter = parameter;
    }

    private StopWatchCondition() {
    }

    public ConditionType getType() {
        return this.type;
    }

    @Nullable
    public GUID getParameter() {
        return this.parameter;
    }

    public boolean matches(UserAccount user, TicketVO ticket) {
        switch (this.getType()) {
            case TicketIsInquiry: {
                return ticket != null && ticket.isInquiry();
            }
            case TicketIsInResource: {
                return ticket != null && Objects.equals(ticket.getResourceID(), this.getParameter());
            }
            case UserIsInGroup: {
                return UserGroupManager.getInstance().getGroupsForUser(user.getID()).stream().anyMatch(g -> g.getID().equals((Object)this.getParameter()));
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.getType()));
    }
}

