/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.mailtemplates.data.MailConfigSettingsData;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.prefs.BackingStoreException;

public class SaveMailConfigSettings
extends ServiceMethod<MailConfigSettingsData, Void> {
    public String getMethodName() {
        return "mailtemplates.savemailconfigsettings";
    }

    public short getMethodType() {
        return 1;
    }

    public Void invoke(HttpServletRequest req, HttpServletResponse resp, MailConfigSettingsData payload) throws IOException {
        ConfigurationManager man = ConfigurationManager.getInstance();
        Configuration config = man.getCurrent();
        if (ConfigurationManager.getRecoveryConfiguration() != null) {
            config = man.get(ConfigurationManager.getRecoveryConfiguration());
        }
        config.put(HDConfigKeys.SUBTEMPLATE_ORDER, payload.getOrder());
        config.put(HDConfigKeys.MAIL_FORMAT, payload.getFormat());
        config.put(HDConfigKeys.AUTOMAIL_SEND_TO_ORIGINATOR, payload.getToorginator());
        config.put(HDConfigKeys.AUTOMAIL_TEMPLATE_SET, payload.getSet());
        try {
            config.flush();
        }
        catch (BackingStoreException e) {
            throw new ClientMessageException(e.getLocalizedMessage());
        }
        return null;
    }
}

