/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.config.mailtemplates.data.LoadTemplateDataRequest;
import com.inet.helpdesk.config.mailtemplates.data.LoadTemplateDataResponse;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LoadTemplateDataHandler
extends ServiceMethod<LoadTemplateDataRequest, LoadTemplateDataResponse> {
    public String getMethodName() {
        return "mailtemplates.loadtemplatedata";
    }

    public short getMethodType() {
        return 1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public LoadTemplateDataResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadTemplateDataRequest payload) throws IOException {
        Comparator displayNameComperator = (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName());
        HashMap<String, ArrayList<LocalizedKey>> templateStructure = new HashMap<String, ArrayList<LocalizedKey>>();
        if (!payload.isShowSubtemplate()) {
            ArrayList<LocalizedKey> listTicketOwner = new ArrayList<LocalizedKey>();
            listTicketOwner.add(new LocalizedKey("abteilung", HDUsersAndGroups.FIELD_DEPARTMENT.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei1", HDUsersAndGroups.FIELD_CUSTOM_1.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei2", HDUsersAndGroups.FIELD_CUSTOM_2.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei3", HDUsersAndGroups.FIELD_CUSTOM_3.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei4", HDUsersAndGroups.FIELD_CUSTOM_4.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei5", HDUsersAndGroups.FIELD_CUSTOM_5.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerfrei6", HDUsersAndGroups.FIELD_CUSTOM_6.getLabel()));
            listTicketOwner.add(new LocalizedKey("computername", HDUsersAndGroups.FIELD_COMPUTER_NAME.getLabel()));
            listTicketOwner.add(new LocalizedKey("gebbezeichnung", HDUsersAndGroups.FIELD_LOCATION_ID.getLabel()));
            listTicketOwner.add(new LocalizedKey("kostenstelle", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.kostenstelle", new Object[0])));
            listTicketOwner.add(new LocalizedKey("adresse", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.adresse", new Object[0])));
            listTicketOwner.add(new LocalizedKey("nachname", UsersAndGroups.FIELD_LASTNAME.getLabel()));
            listTicketOwner.add(new LocalizedKey("telefon", UsersAndGroups.FIELD_TELEPHONE.getLabel()));
            listTicketOwner.add(new LocalizedKey("useremail", UsersAndGroups.FIELD_EMAIL.getLabel()));
            listTicketOwner.add(new LocalizedKey("username", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.username", new Object[0])));
            listTicketOwner.add(new LocalizedKey("vorname", UsersAndGroups.FIELD_FIRSTNAME.getLabel()));
            listTicketOwner.add(new LocalizedKey("zimmer", HDUsersAndGroups.FIELD_ROOM.getLabel()));
            listTicketOwner.add(new LocalizedKey("benutzerklasse", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.benutzerklasse", new Object[0])));
            listTicketOwner.sort(displayNameComperator);
            templateStructure.put(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.ticketowner", new Object[0]), listTicketOwner);
        }
        if (payload.isShowSubtemplate()) {
            ArrayList<LocalizedKey> listSubTemplate = new ArrayList<LocalizedKey>();
            listSubTemplate.add(new LocalizedKey("wann", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.wann", new Object[0])));
            listSubTemplate.add(new LocalizedKey("von", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.von", new Object[0])));
            listSubTemplate.add(new LocalizedKey("bis", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.bis", new Object[0])));
            listSubTemplate.add(new LocalizedKey("was", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.was", new Object[0])));
            listSubTemplate.add(new LocalizedKey("stundensatz", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.stundensatz", new Object[0])));
            listSubTemplate.add(new LocalizedKey("wer", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.wer", new Object[0])));
            listSubTemplate.add(new LocalizedKey("empfaenger", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.empfaenger", new Object[0])));
            listSubTemplate.add(new LocalizedKey("absender", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.absender", new Object[0])));
            listSubTemplate.sort(displayNameComperator);
            templateStructure.put(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.subtemplate", new Object[0]), listSubTemplate);
        }
        if (!payload.isShowSubtemplate()) {
            ArrayList<LocalizedKey> listOther = new ArrayList<LocalizedKey>();
            listOther.add(new LocalizedKey("firma", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.firma", new Object[0])));
            listOther.add(new LocalizedKey("logo", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.logo", new Object[0])));
            listOther.add(new LocalizedKey("date", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.date", new Object[0])));
            listOther.add(new LocalizedKey("time", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.time", new Object[0])));
            listOther.sort(displayNameComperator);
            templateStructure.put(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.other", new Object[0]), listOther);
        }
        if (!payload.isShowSubtemplate()) {
            ArrayList<LocalizedKey> listTicket = new ArrayList<LocalizedKey>();
            listTicket.add(new LocalizedKey("anfragedatum", Tickets.ATTRIBUTE_INQUIRY_DATE.getLabel()));
            listTicket.add(new LocalizedKey("anfragedatumgmt", Tickets.ATTRIBUTE_INQUIRY_DATE.getLabel() + " (GMT)"));
            listTicket.add(new LocalizedKey("aufid", Tickets.ATTRIBUTE_TICKET_ID.getLabel()));
            listTicket.add(new LocalizedKey("aufidxxx", Tickets.ATTRIBUTE_TICKET_ID.getLabel()));
            listTicket.add(new LocalizedKey("ticket.guid", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.ticket.guid", new Object[0])));
            listTicket.add(new LocalizedKey("auftrag", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.auftrag", new Object[0])));
            listTicket.add(new LocalizedKey("auftragfrei1", Tickets.getFieldByKey("custom1").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei2", Tickets.getFieldByKey("custom2").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei3", Tickets.getFieldByKey("custom3").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei4", Tickets.getFieldByKey("custom4").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei5", Tickets.getFieldByKey("custom5").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei6", Tickets.getFieldByKey("custom6").getLabel()));
            listTicket.add(new LocalizedKey("auftragfrei7", Tickets.getFieldByKey("custom7").getLabel()));
            listTicket.add(new LocalizedKey("derbetreff", Tickets.FIELD_SUBJECT.getLabel()));
            listTicket.add(new LocalizedKey("deadlinezeit", Tickets.FIELD_DEADLINE.getLabel()));
            listTicket.add(new LocalizedKey("dispatcher", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.dispatcher", new Object[0])));
            listTicket.add(new LocalizedKey("email", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.email", new Object[0])));
            listTicket.add(new LocalizedKey("e-mail absender", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates." + "e-mail absender".replaceAll(" ", "_").replaceAll("-", "_"), new Object[0])));
            listTicket.add(new LocalizedKey("e-mail empfaenger", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates." + "e-mail empfaenger".replaceAll(" ", "_").replaceAll("-", "_"), new Object[0])));
            listTicket.add(new LocalizedKey("e-mail disp", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates." + "e-mail disp".replaceAll(" ", "_").replaceAll("-", "_"), new Object[0])));
            listTicket.add(new LocalizedKey("emaileingang", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.emaileingang", new Object[0])));
            listTicket.add(new LocalizedKey("itilbezeichnung", Tickets.FIELD_ITIL_ID.getLabel()));
            listTicket.add(new LocalizedKey("kennung", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.kennung", new Object[0])));
            listTicket.add(new LocalizedKey("klassifizierung", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.klassifizierung", new Object[0])));
            listTicket.add(new LocalizedKey("klassifizierunginfo", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.klassifizierunginfo", new Object[0])));
            listTicket.add(new LocalizedKey("letzterbearbeiter", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.letzterbearbeiter", new Object[0])));
            listTicket.add(new LocalizedKey("pribezeichnung", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.pribezeichnung", new Object[0])));
            listTicket.add(new LocalizedKey("producer", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.producer", new Object[0])));
            listTicket.add(new LocalizedKey("resbezeichnung", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.resbezeichnung", new Object[0])));
            listTicket.add(new LocalizedKey("ressourcestundensatz", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.ressourcestundensatz", new Object[0])));
            listTicket.add(new LocalizedKey("subtemplate", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.subtemplate", new Object[0])));
            listTicket.add(new LocalizedKey("statusbezeichnung", Tickets.ATTRIBUTE_STATUS_ID.getLabel()));
            listTicket.add(new LocalizedKey("summezeit", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.summezeit", new Object[0])));
            listTicket.add(new LocalizedKey("the message", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates." + "the message".replaceAll(" ", "_"), new Object[0])));
            listTicket.add(new LocalizedKey("wvzeit", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.wvzeit", new Object[0])));
            listTicket.add(new LocalizedKey("zeit_mal_ressourcestundensatz", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.zeit_mal_ressourcestundensatz", new Object[0])));
            listTicket.add(new LocalizedKey("dispatcherusr", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.dispatcherusr", new Object[0])));
            listTicket.sort(displayNameComperator);
            templateStructure.put(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configpage.configuration.mailtemplates.ticket", new Object[0]), listTicket);
        }
        HashSet seenKeys = new HashSet();
        ArrayList providerPlaceholders = new ArrayList();
        @Nonnull List autoTextPlaceholderProviders = DynamicExtensionManager.getInstance().get(AutoTextPlaceholderProvider.class);
        autoTextPlaceholderProviders.stream().map(AutoTextPlaceholderProvider::provideAdditionalAutoTextPlaceholders).filter(p -> p != null && !p.isEmpty()).flatMap(p -> p.stream()).forEach(placeholder -> {
            String name = placeholder.getValue();
            ArrayList keys = placeholder.getEntries().stream().map(e -> new LocalizedKey(e.getKey(), e.getValue())).sorted(new Comparator<LocalizedKey>(){

                @Override
                public int compare(LocalizedKey o1, LocalizedKey o2) {
                    String display1 = o1.getDisplayName();
                    String display2 = o2.getDisplayName();
                    boolean hasSlash1 = display1.contains("/");
                    boolean hasSlash2 = display2.contains("/");
                    if (hasSlash1 && !hasSlash2) {
                        return -1;
                    }
                    if (!hasSlash1 && hasSlash2) {
                        return 1;
                    }
                    return display1.compareToIgnoreCase(display2);
                }
            }).collect(Collectors.toCollection(ArrayList::new));
            templateStructure.put(name, keys);
        });
        return new LoadTemplateDataResponse(templateStructure);
    }
}

