/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.helpdesk.config.autotext.data.AutoTextDescription;
import com.inet.helpdesk.config.autotext.data.AutoTextGroupsDescription;
import com.inet.helpdesk.config.autotext.data.SaveAutoTextsRequest;
import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.TargetEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SaveAutoText
extends ServiceMethod<SaveAutoTextsRequest, Void> {
    public Void invoke(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, SaveAutoTextsRequest payload) throws IOException {
        final ArrayList openStream = new ArrayList();
        try {
            AutoTextDescription desc = payload.getAutoTextDescription();
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            Objects.requireNonNull(currentUserAccount);
            Integer hdUserId = HDUsersAndGroups.getUserID(currentUserAccount.getID());
            AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
            boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
            boolean isSupporterGroup = HDUsersAndGroups.isSupporter(currentUserAccount);
            boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
            boolean userHasPermission = SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
            if (!(isAdminGroup || userIsAdmin || userHasPermission || isSupporterGroup)) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.nopermission", new Object[0]));
            }
            HashMap<String, String> fieldValues = payload.getFieldValues();
            String htmlText = fieldValues.get("htmleditor");
            htmlText = TicketTextFunctions.correctAttachmentPathesForServer(htmlText);
            Integer autotextId = desc.getId();
            ArrayList<String> deleteAttachments = payload.getDeleteAttachments();
            if (autotextId != null && deleteAttachments != null && !deleteAttachments.isEmpty() && ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                AutoTextAttachmentHelper.deleteAutoTextAttachments(autotextId, deleteAttachments);
            }
            ArrayList<LargeContent> addedAttachments = new ArrayList<LargeContent>();
            if (payload.getAttachments() != null) {
                int attachmentNumber = 0;
                for (AttachmentDescription ad : payload.getAttachments()) {
                    Part f;
                    if ((f = req.getPart("attachment" + attachmentNumber++)) == null) continue;
                    LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                        @Override
                        public InputStream getStream() {
                            try {
                                InputStream inputStream = f.getInputStream();
                                openStream.add(inputStream);
                                return inputStream;
                            }
                            catch (Throwable t) {
                                HDLogger.error(t);
                                throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
                            }
                        }

                        @Override
                        public long getSize() {
                            return f.getSize();
                        }
                    });
                    lc.setContentType(AttachmentType.valueOf((String)ad.getAttachmentType().name()));
                    lc.setLastModified(ad.getLastModified());
                    lc.setName(ad.getName());
                    addedAttachments.add(lc);
                }
            }
            String group = desc.getGroup();
            List<AutoTextMember> memberList = this.getMemberList(desc.getAutoTextGroups());
            if (!(memberList == null || memberList.size() == 1 && memberList.get(0).getId().equals((Object)UsersAndGroups.GROUPID_ALLUSERS) || SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}))) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.nopermission", new Object[0]));
            }
            if (autotextId != null) {
                of = AutoTextVO.of(autotextId, desc.getOwnerId(), desc.getLabel(), desc.getFlags(), htmlText, desc.getShortcut(), group, memberList);
                AutoTextVO autoTextVO = (AutoTextVO)man.get(autotextId);
                if (autoTextVO == null) {
                    throw new ClientMessageException(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.autotext.edit.notexits", new Object[0]));
                }
                man.update(of);
            } else {
                of = AutoTextVO.of(-1, hdUserId, desc.getLabel(), desc.getFlags(), htmlText, desc.getShortcut(), group, memberList);
                man.add(of);
                autotextId = of.getId();
            }
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                AutoTextAttachmentHelper.addAttachmentsToAutotext(autotextId, addedAttachments, payload.getDuplicatedAutotextId());
                if (payload.getDuplicatedAutotextId() != null) {
                    AutoTextAttachmentHelper.addDuplAttachmentsToAutotext(autotextId, payload.getDuplicatedAutotextId());
                }
            }
        }
        catch (Throwable t) {
            HDLogger.error(t);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
        }
        finally {
            for (InputStream stream : openStream) {
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    if (t instanceof ClientMessageException) {
                        throw t;
                    }
                    HDLogger.error(t);
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
                }
            }
        }
        return null;
    }

    public String getMethodName() {
        return "autotext.saveautotext";
    }

    public short getMethodType() {
        return 1;
    }

    private List<AutoTextMember> getMemberList(AutoTextGroupsDescription groups) {
        if (groups == null) {
            return null;
        }
        String value = groups.getValue();
        if (StringFunctions.isEmpty((String)value)) {
            return null;
        }
        ArrayList fromJson = (ArrayList)new Json().fromJson(value, ArrayList.class, new Type[]{TargetEntry.class});
        if (fromJson == null || fromJson.isEmpty()) {
            return null;
        }
        ArrayList<AutoTextMember> menbersList = new ArrayList<AutoTextMember>();
        for (TargetEntry targetEntry : fromJson) {
            menbersList.add(new AutoTextMember(targetEntry.getGuid(), targetEntry.getEntryType()));
        }
        return menbersList;
    }
}

