/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.editor.HtmlConverter;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class AutoTextAttachmentHelper {
    public static List<SavedAttachmentData> getAutoTextAttachments(int autoTextId) {
        AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        try {
            ArrayList<SavedAttachmentData> attachments = new ArrayList<SavedAttachmentData>();
            Map fullAttachmentData = attService.getFullAttachmentDataFor(AttachmentOwnerType.AutoTextAttachment, Collections.singletonList(autoTextId));
            for (AttachmentRow row : fullAttachmentData.keySet()) {
                attachments.add(new SavedAttachmentData(row.getOwnerId(), row.getStepId(), row.getAdditionalId(), row.getType().getId(), row.getFileName(), MimeTypes.getMimeType((String)row.getFileName()), row.getFileLength(), row.getLastModified(), row.isEmbedded(), false));
            }
            return attachments;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public static void addAttachmentsToAutotext(int autoTextId, List<LargeContent> attachments, Integer duplicatedAutoTextId) throws Throwable {
        AutoTextManager man;
        AutoTextVO autoTextVO;
        String contentText;
        ExternalImageAttachmentAdder attachmentAdder = (ExternalImageAttachmentAdder)ServerPluginManager.getInstance().getSingleInstance(ExternalImageAttachmentAdder.class);
        HashMap<String, String> imageMap = new HashMap<String, String>();
        if (attachments != null && attachments.size() > 0) {
            for (LargeContent data : attachments) {
                AttachmentDescription desc = attachmentAdder.addAttachment(AttachmentOwnerType.AutoTextAttachment, autoTextId, -1, data);
                if (data.getContentType() != AttachmentType.EmbeddedImage) continue;
                imageMap.put(data.getName(), desc.getRESTfulFilePath());
            }
        }
        if (!StringFunctions.isEmpty((String)(contentText = (autoTextVO = (AutoTextVO)(man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class)).get(autoTextId)).getContentText()))) {
            String changed;
            if (duplicatedAutoTextId != null) {
                AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                Map fullAttachmentData = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.AutoTextAttachment, Arrays.asList(duplicatedAutoTextId));
                for (AttachmentRow att : fullAttachmentData.keySet()) {
                    if (!att.isEmbedded()) continue;
                    contentText = contentText.replaceAll(att.getOwnerId() + "/" + Pattern.quote(att.getFileName()), autoTextId + "/" + att.getFileName());
                }
            }
            if ((changed = attachmentAdder.convertExternalImagesToAttachments(AttachmentOwnerType.AutoTextAttachment, autoTextId, -1, contentText = HtmlConverter.getCompactHtmlText((String)contentText, imageMap, null, (boolean)true))) != null) {
                contentText = changed;
            }
            man.update(AutoTextVO.of(autoTextId, autoTextVO.getUserId(), autoTextVO.getLabel(), autoTextVO.getTyp(), contentText, autoTextVO.getShortcut(), autoTextVO.getGroupLabel(), autoTextVO.getMemberships()), false);
        }
    }

    public static void addDuplAttachmentsToAutotext(int autoTextId, Integer duplAutotextId) throws SQLException {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        AttachmentDuplicator duplicator = (AttachmentDuplicator)ServerPluginManager.getInstance().getSingleInstance(AttachmentDuplicator.class);
        Map fullAttachmentData = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.AutoTextAttachment, Arrays.asList(duplAutotextId));
        HashMap<@Nonnull AttachmentKey, @Nonnull AttachmentKey> keyMap = new HashMap<AttachmentKey, AttachmentKey>();
        for (AttachmentRow att : fullAttachmentData.keySet()) {
            List duplicateAttachments = duplicator.duplicateAttachments(Arrays.asList(att.getAttachmentKey()), AttachmentOwnerType.AutoTextAttachment, autoTextId, -1, -1);
            keyMap.put(att.getAttachmentKey(), (AttachmentKey)duplicateAttachments.get(0));
        }
        AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        AutoTextVO autoTextVO = (AutoTextVO)man.get(autoTextId);
        String contentText = autoTextVO.getContentText();
        Set keySet = keyMap.keySet();
        for (AttachmentKey attachmentKey : keySet) {
            AttachmentKey attachmentKey2 = (AttachmentKey)keyMap.get(attachmentKey);
            contentText = contentText.replaceAll(attachmentKey.getOwnerId() + "/" + Pattern.quote(attachmentKey.getFileName()), attachmentKey2.getOwnerId() + "/" + attachmentKey2.getFileName());
        }
        man.update(AutoTextVO.of(autoTextId, autoTextVO.getUserId(), autoTextVO.getLabel(), autoTextVO.getTyp(), contentText, autoTextVO.getShortcut(), autoTextVO.getGroupLabel(), autoTextVO.getMemberships()));
    }

    public static void deleteAutoTextAttachments(int autoTextId, List<String> attachmentNames) throws IOException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (attachmentNames.isEmpty() || !spm.isPluginLoaded("attachments")) {
            return;
        }
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        for (String fileName : attachmentNames) {
            attService.deleteAttachment(AttachmentOwnerType.AutoTextAttachment, autoTextId, -1, fileName);
        }
    }

    public static void deleteAllAutoTextAttachments(int autoTextId) throws Exception {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return;
        }
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        List allFileNames = attService.getFileNamesFromAttachments(AttachmentOwnerType.AutoTextAttachment, autoTextId, -1);
        for (String fileName : allFileNames) {
            attService.deleteAttachment(AttachmentOwnerType.AutoTextAttachment, autoTextId, -1, fileName);
        }
    }

    public static LargeContent convertToLargeContent(SavedAttachmentData attachmentData) throws SQLException {
        PersistenceEntry entry;
        AttachmentFileRow file;
        AttachmentKey key;
        AttachmentService attService;
        AttachmentRow row;
        if (attachmentData != null && (row = (attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class)).getAttachment(key = AttachmentFilePathBuilder.convertRestfulPathToKey((String)("Attachments/" + AttachmentOwnerType.getTypeForId((int)attachmentData.getTypeId()).getAttachmentSubContext() + "/" + attachmentData.getOwnerId() + "/" + attachmentData.getStepId() + "/" + attachmentData.getFileName() + "/")))) != null && (file = attService.getAttachmentFile(row.getChecksum(), row.getFileLength())) != null && (entry = AppDataLocation.getAttachmentFile(file.getFilePath())) != null) {
            LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                @Override
                public InputStream getStream() {
                    try {
                        return entry.getInputStream();
                    }
                    catch (Exception e) {
                        HDLogger.error(e);
                        return null;
                    }
                }

                @Override
                public long getSize() {
                    return row.getFileLength();
                }
            });
            lc.setContentType(AttachmentType.valueOf((String)AttachmentType.Signature.name()));
            lc.setLastModified(attachmentData.getLastModified());
            lc.setName(attachmentData.getFileName());
            return lc;
        }
        return null;
    }
}

