/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.LocationList;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonData
public class LocationListConfigProperty
extends ItemListConfigProperty {
    public LocationListConfigProperty(Set<ConfigProperty> configProperties, ConfigStructureSettings settings, Translator translator, ConnectionFactory connectionFactory, boolean deactivatedLocations) {
        super(configProperties.size() * 100, LocationListConfigProperty.propertyKey(deactivatedLocations), deactivatedLocations ? "LOCATIONSDEACTIVATED" : "LOCATIONS", LocationListConfigProperty.getObjectListValue(settings, deactivatedLocations), null, LocationListConfigProperty.getRowAction(settings, translator, connectionFactory, deactivatedLocations));
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static String propertyKey(boolean deactivatedLocations) {
        return "Locations" + (deactivatedLocations ? "Del" : "");
    }

    static Object getObjectListValue(ConfigStructureSettings settings, boolean deactivatedLocations) {
        List changedValueRaw = (List)settings.getChangedValue(LocationListConfigProperty.propertyKey(deactivatedLocations), List.class);
        if (changedValueRaw != null) {
            HashMap<String, String> map;
            for (Map element2 : changedValueRaw) {
                if (!((String)element2.get("SLA_PriID")).isEmpty()) continue;
                element2.put("SLA_PriID", "0");
            }
            if (deactivatedLocations) {
                List activeLocationList = (List)settings.getChangedValue(LocationListConfigProperty.propertyKey(false), List.class);
                List activeLocs = LocationManager.getInstance().getAll(true);
                for (LocationVO active : activeLocs) {
                    if (!activeLocationList.stream().noneMatch(element -> Objects.equals(element.get("id"), "" + active.getId())) || !changedValueRaw.stream().noneMatch(element -> Objects.equals(element.get("id"), "" + active.getId()))) continue;
                    map = LocationListConfigProperty.convertToHashmap(active);
                    map.put("hide", "true");
                    changedValueRaw.add(map);
                }
            }
            if (!deactivatedLocations) {
                List deactivatedLocationList = (List)settings.getChangedValue(LocationListConfigProperty.propertyKey(true), List.class);
                List inactiveLocs = LocationManager.getInstance().getAll(false);
                inactiveLocs.removeIf(l -> !l.isDeleted());
                for (LocationVO active : inactiveLocs) {
                    if (!deactivatedLocationList.stream().noneMatch(element -> Objects.equals(element.get("id"), "" + active.getId())) || !changedValueRaw.stream().noneMatch(element -> Objects.equals(element.get("id"), "" + active.getId()))) continue;
                    map = LocationListConfigProperty.convertToHashmap(active);
                    map.put("hide", "true");
                    changedValueRaw.add(map);
                }
            }
            changedValueRaw.sort((o1, o2) -> LocationVO.compareLocationNames((String)o1.get("GebBezeichnung"), (String)o2.get("GebBezeichnung")));
            return changedValueRaw;
        }
        Integer defaultValue = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        List list = LocationManager.getInstance().getAll(false);
        list.removeIf(loc -> loc.isDeleted() && !deactivatedLocations || !loc.isDeleted() && deactivatedLocations);
        LocationList cList = new LocationList();
        cList.addAll(list);
        cList.sort((o1, o2) -> o1.compareTo((LocationVO)o2));
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        UserManager u = UserManager.getInstance();
        IndexSearchEngine s = u.getSearchEngine();
        for (LocationVO location : cList) {
            HashMap<String, String> entry = LocationListConfigProperty.convertToHashmap(location);
            if (location.getId() == defaultValue.intValue()) {
                entry.put("hide", "true");
            }
            result.add(entry);
            if (!ServerPluginManager.getInstance().isPluginLoaded("inventory") || !Objects.equals(AssetFields.FIELD_LOCATION.getDefaultValue(), location.getId())) continue;
            entry.put("hide", "true");
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(LocationVO location) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + location.getId());
        result.put("GebBezeichnung", location.getDisplayValue());
        result.put("SLA_PriID", "" + location.getSLA_PriID());
        String address = location.getAddress();
        if (address == null) {
            address = "";
        }
        result.put("Adresse", address);
        String comment = location.getComment();
        comment = comment == null ? "" : comment;
        result.put("Kommentar", comment);
        String werte = location.getValues();
        result.put("Werte", werte == null ? "" : werte);
        result.put("hide", "false");
        return result;
    }

    public static LocationList convertToList(HashMap<String, String>[] result) {
        LocationList map = new LocationList();
        for (HashMap<String, String> location : result) {
            LocationVO info = LocationListConfigProperty.convertToEntry(location);
            map.add(info);
        }
        return map;
    }

    private static LocationVO convertToEntry(HashMap<String, String> locationMap) {
        String id = locationMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.valueOf(id);
        return new LocationVO(idNum, "", "", "", "", -1, false);
    }

    private static ConfigRowAction[] getRowAction(ConfigStructureSettings settings, Translator translator, ConnectionFactory connectionFactory, boolean deactivatedLocations) {
        if (deactivatedLocations) {
            return new ConfigRowAction[0];
        }
        ConfigAction action = new ConfigAction("location.new", translator.translate("AddLocation"));
        ConfigCategory category = new ConfigCategory(0, "location.new", translator.translate("Location"), "ticket.values.locations");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "location.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("location.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        rowAction.setAddMultipleEntriesAllowed(!deactivatedLocations);
        propertyList.add(LocationListConfigProperty.propWith("SimpleText", translator.translate("GebBezeichnung"), "GebBezeichnung", ""));
        propertyList.add(LocationListConfigProperty.propWith("SimpleText", translator.translate("Kommentar"), "Kommentar", ""));
        if (!settings.isFilter()) {
            List<LocalizedKey> priorityList = LocalizedKeyListFactory.getPriorities(connectionFactory);
            priorityList.add(0, new LocalizedKey("", ""));
            SelectConfigProperty priorities = new SelectConfigProperty(123, "SLA_PriID", "FixNumber", translator.translate("SLA_PriID"), (Object)"", "", priorityList);
            propertyList.add(priorities);
        }
        propertyList.add(LocationListConfigProperty.propWith("MultiLineText", translator.translate("Adresse"), "Adresse", ""));
        propertyList.add(LocationListConfigProperty.propWith("MultiLineText", translator.translate("Werte"), "Werte", ""));
        propertyList.add(LocationListConfigProperty.propWith("Hidden", "id", "id", "-1"));
        return new ConfigRowAction[]{rowAction};
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

