/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.ItilList;
import com.inet.helpdesk.config.ItilRestrictionsConfigProperty;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.TargetValue;
import com.inet.usersandgroups.api.ui.Type;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonData
public class ItilListConfigProperty
extends ItemListConfigProperty {
    public ItilListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, "Itil", "ITIL", ItilListConfigProperty.getObjectListValue(settings, translator), translator.translate("ItilAdd"), new ConfigRowAction[0]);
        List objectListValue = (List)this.getValue();
        Set<String> allPaths = objectListValue.stream().map(m -> (String)m.get("name")).collect(Collectors.toSet());
        this.setRowActions(ItilListConfigProperty.getItilRowActions(settings, translator, allPaths));
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"IsDefault", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        List changedValueRaw = (List)settings.getChangedValue("Itil", List.class);
        if (changedValueRaw != null) {
            List masters = changedValueRaw.stream().filter(map -> "true".equals(map.get("masterType"))).sorted((o1, o2) -> ((String)o1.get("name")).compareToIgnoreCase((String)o2.get("name"))).collect(Collectors.toList());
            List slaves = changedValueRaw.stream().filter(map -> !"true".equals(map.get("masterType"))).sorted((o1, o2) -> ((String)o1.get("name")).compareToIgnoreCase((String)o2.get("name"))).collect(Collectors.toList());
            changedValueRaw.clear();
            changedValueRaw.addAll(masters);
            changedValueRaw.addAll(slaves);
            List idList = changedValueRaw.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
            changedValueRaw.forEach(m -> {
                ArrayList idListWithoutMyself = new ArrayList(idList);
                idListWithoutMyself.remove(m.get("id"));
                String idListJson = new Json().toJson(idListWithoutMyself);
                m.put("allids", idListJson);
            });
            return changedValueRaw;
        }
        List list = ItilManager.getInstance().getAll(true).stream().sorted((o1, o2) -> Integer.compare(o2.getId(), o1.getId())).collect(Collectors.toList());
        ItilList cList = new ItilList();
        cList.addAll(list);
        List idList = cList.stream().map(p -> "" + p.getId()).collect(Collectors.toList());
        String allIds = new Json().toJson(idList);
        Map<Integer, String> allPathNames = ItilManager.getInstance().getAllAttributeDisplayNames(true);
        List<Integer> sortedIds = ItilListConfigProperty.getSortedIds(allPathNames);
        HashMap idToItil = new HashMap();
        cList.forEach(c -> idToItil.put(c.getId(), c));
        HashMap<CallSite, HashMap<String, String>> idToValues = new HashMap<CallSite, HashMap<String, String>>();
        for (ItilVO itil : cList) {
            HashMap<String, String> entry = ItilListConfigProperty.convertToHashmap(itil, translator);
            entry.put("isNewlyCreated", "false");
            entry.put("allids", allIds);
            idToValues.put((CallSite)((Object)entry.get("id")), entry);
        }
        return sortedIds.stream().sorted((e1, e2) -> Boolean.compare(!((ItilVO)idToItil.get(e1)).isMasterType(), !((ItilVO)idToItil.get(e2)).isMasterType())).map(i -> (Map)idToValues.get("" + i)).collect(Collectors.toList());
    }

    static List<Integer> getSortedIds(Map<Integer, String> allNames) {
        List<Integer> sortedIds = allNames.entrySet().stream().sorted((o1, o2) -> ((String)o1.getValue()).replace('\\', '\n').compareToIgnoreCase(((String)o2.getValue()).replace('\\', '\n'))).map(Map.Entry::getKey).collect(Collectors.toList());
        return sortedIds;
    }

    private static HashMap<String, String> convertToHashmap(ItilVO itil, Translator translator) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + itil.getId());
        result.put("origImage", itil.getImageName());
        result.put("name", itil.getDisplayValue());
        result.put("internal", "" + itil.isInternal());
        result.put("masterType", "" + itil.isMasterType());
        result.put("protectedContent", "" + ((itil.getProtectedContent() & 1) > 0));
        result.put("protectedContent.label", translator.translate("itil.protected.label"));
        result.put("autoclose", "" + itil.isCloseSubOrders());
        result.put("info", itil.getInfo());
        result.put("messageType", "" + itil.getMessageType());
        result.put("messageEmail", itil.getMessageEmail());
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        result.put("restrictions", new Json().toJson((Object)TargetValue.getValue(itil.getRestrictedTo())));
        if (((Integer)Tickets.FIELD_ITIL_ID.getDefaultValue()).intValue() == itil.getId()) {
            result.put("IsDefault", "true");
        }
        return result;
    }

    public static ItilList convertToList(HashMap<String, String>[] result) {
        ItilList map = new ItilList();
        for (HashMap<String, String> itil : result) {
            ItilVO info = ItilListConfigProperty.convertToEntry(itil);
            map.add(info);
        }
        return map;
    }

    private static ItilVO convertToEntry(HashMap<String, String> itilMap) {
        String id = itilMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.valueOf(id);
        String name = itilMap.get("name");
        int protectedContent = "true".equals(itilMap.get("protectedContent")) ? 1 : 0;
        String info = itilMap.get("info");
        boolean masterType = "true".equals(itilMap.get("masterType"));
        String restrictions = itilMap.get("restrictions");
        Map restrictedTo = TargetValue.getReceivers((String)restrictions);
        return new ItilVO(idNum, name, "", false, false, masterType, protectedContent, info, 0, "", restrictedTo);
    }

    private static ConfigRowAction[] getItilRowActions(ConfigStructureSettings settings, Translator translator, Set<String> allitils) {
        List<Object> allids = new ArrayList();
        List changedValueRaw = (List)settings.getChangedValue("Itil", List.class);
        if (changedValueRaw != null) {
            List masterids = changedValueRaw.stream().filter(map -> "true".equals(map.get("masterType"))).sorted(Comparator.comparing(o -> (String)o.get("name"))).map(map -> (String)map.get("id")).collect(Collectors.toList());
            List slaveids = changedValueRaw.stream().filter(map -> "true".equals(map.get("masterType"))).sorted(Comparator.comparing(o -> (String)o.get("name"))).map(map -> (String)map.get("id")).collect(Collectors.toList());
            allids.addAll(masterids);
            allids.addAll(slaveids);
        } else {
            String itilOrigValue = settings.getValue("Itil");
            if (itilOrigValue != null) {
                ItilList itils = (ItilList)new Json().fromJson(itilOrigValue, ItilList.class);
                allids = itils.stream().map(i -> "" + i.getId()).collect(Collectors.toList());
            } else {
                List all = ItilManager.getInstance().getAll(true);
                List masterids = all.stream().filter(ItilVO::isMasterType).sorted(Comparator.comparing(ItilVO::getDisplayValue)).map(i -> "" + i.getId()).collect(Collectors.toList());
                List slaveids = all.stream().filter(i -> !i.isMasterType()).sorted(Comparator.comparing(ItilVO::getDisplayValue)).map(i -> "" + i.getId()).collect(Collectors.toList());
                allids.addAll(masterids);
                allids.addAll(slaveids);
            }
        }
        String myId = settings.getValue("id");
        if (myId != null) {
            allids.remove(myId);
        }
        ConfigAction actionAddMaster = new ConfigAction("itil.new.master", translator.translate("AddItilMaster"));
        ConfigAction actionAddSlave = new ConfigAction("itil.new.slave", translator.translate("AddItilSlave"));
        ConfigCategory itil = new ConfigCategory(0, "itil.new", translator.translate("Itil"), "ticket.values.itil");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "itil.new.group", ""));
        propertyGroups.add(new ConfigPropertyGroup(1, "itil.new.restrictions", translator.translate("ItilRestrictionGroupTitle")));
        ArrayList<Object> propertyList = new ArrayList<Object>();
        propertyList.add(ItilListConfigProperty.propWith("SimpleText", translator.translate("itil.name"), "name", ""));
        propertyList.add(ItilListConfigProperty.propWith("Hidden", translator.translate("itil.protected"), "protectedContent", "false"));
        propertyList.add(ItilListConfigProperty.propWith("Boolean", translator.translate("itil.autoclose"), "autoclose", "false"));
        propertyList.add(ItilListConfigProperty.propWith("MultiLineText", translator.translate("itil.info"), "info", ""));
        propertyList.add(ItilListConfigProperty.propWith("Hidden", "id", "id", "-1"));
        propertyList.add(ItilListConfigProperty.propWith("Hidden", "allids", "allids", new Json().toJson(allids)));
        propertyList.add(ItilListConfigProperty.propWith("Hidden", "origImage", "origImage", ""));
        propertyList.add(ItilListConfigProperty.propWith("Hidden", "IsDefault", "IsDefault", "false"));
        ArrayList<ConfigProperty> restrictionsList = new ArrayList<ConfigProperty>();
        restrictionsList.add(ItilListConfigProperty.propWith("KeyLabel", null, "protectedContent.label", translator.translate("itil.protected.label")));
        HashMap<Type, Set<GUID>> restrictedTo = new HashMap<Type, Set<GUID>>(){
            {
                this.put(Type.group, new HashSet<GUID>(Collections.singletonList(UsersAndGroups.GROUPID_ALLUSERS)));
            }
        };
        String defaultRestrictedToJson = new Json().toJson((Object)restrictedTo);
        restrictionsList.add(new ItilRestrictionsConfigProperty(3454356, "restrictions", "haha", defaultRestrictedToJson));
        ArrayList<Object> slaveList = new ArrayList<Object>(propertyList);
        propertyList.add(ItilListConfigProperty.propWith("Hidden", "id", "masterType", "true"));
        slaveList.add(ItilListConfigProperty.propWith("Hidden", "id", "masterType", "false"));
        propertyList.add((Object)new TicketValueIconConfigProperty(0, translator.translate("ItilImage"), 7));
        slaveList.add((Object)new TicketValueIconConfigProperty(0, translator.translate("ItilImage"), 7));
        HashMap<String, ArrayList<Object>> masterProperties = new HashMap<String, ArrayList<Object>>();
        masterProperties.put("itil.new.group", propertyList);
        masterProperties.put("itil.new.restrictions", restrictionsList);
        HashMap<String, ArrayList<Object>> slaveProperties = new HashMap<String, ArrayList<Object>>();
        slaveProperties.put("itil.new.group", slaveList);
        slaveProperties.put("itil.new.restrictions", restrictionsList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        conditions.add(g.visibleActionFor(g.createCondition().property("masterType").equals().value((Object)"true"), "autoclose"));
        ConfigCondition condition = g.alwaysFalse();
        ConfigRowAction rowActionAddMaster = new ConfigRowAction(actionAddMaster, condition, itil, propertyGroups, masterProperties, conditions);
        ConfigRowAction rowActionAddSlave = new ConfigRowAction(actionAddSlave, null, itil, propertyGroups, slaveProperties, conditions);
        return new ConfigRowAction[]{rowActionAddMaster, rowActionAddSlave};
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }
}

