/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConditionGenerator2;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeSelect;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.helpdesk.config.ActionList;
import com.inet.helpdesk.config.ActionListConfigProperty;
import com.inet.helpdesk.config.BundleBehavior;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.Freifeld;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.HDConfigStructureProvider;
import com.inet.helpdesk.config.StatusList;
import com.inet.helpdesk.config.StatusListConfigProperty;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.stopwatch.ConditionType;
import com.inet.helpdesk.config.stopwatch.StopWatchConfig;
import com.inet.helpdesk.config.stopwatch.StopWatchConfigProperty;
import com.inet.helpdesk.config.stopwatch.StopWatchList;
import com.inet.helpdesk.config.stopwatch.StopWatchRule;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.logging.LogManager;
import com.inet.permissions.Permission;
import java.lang.reflect.Type;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HDConfigStructureProviderTicketSettings
extends AbstractStructureProvider {
    public static final String GROUP_SETTINGS = "ticketsettings";
    private static final String CATEGORY_FREIFELDER = "helpdesk.main.freifelder";
    public static final String PROP_GROUP_FREIFELDER = "helpdesk.main.freifelder.main";
    public static final String PROP_GROUP_FREIFELDER_TITLE_LABEL = "helpdesk.freifelder.title_label";
    public static final String PROP_GROUP_ACTIONS = "helpdesk.main.actions.main";
    public static final String PROP_GROUP_ACTIONS_TITLE_LABEL = "helpdesk.actions.title_label";
    private static final String CATEGORY_ACTIONS = "helpdesk.main.actions";
    public static final String PROP_GROUP_STATUSES = "helpdesk.main.statuses.main";
    public static final String PROP_GROUP_STATUSES_TITLE_LABEL = "helpdesk.statuses.title_label";
    private static final String CATEGORY_STATUSES = "helpdesk.main.statuses";
    public static final String PROP_GROUP_BEARBEITUNG_ALLGEMEIN = "helpdesk.main.processing.main";
    public static final String PROP_GROUP_BEARBEITUNG_ENDUSER = "helpdesk.main.processing.enduser";
    public static final String PROP_GROUP_BUNDLE = "helpdesk.tickets.bundle";
    private static final String CATEGORY_BEARBEITUNG = "helpdesk.main.ticketbearbeitung";
    public static final String PROP_GROUP_DEFAULT_VALUES_TITLE_LABEL = "helpdesk.defaultvalues.title_label";
    private static final String PROP_GROUP_USERSANDGROUPS_DEFAULT = "helpdesk.usersandgroupsmanager.defaults";
    public static final String PROP_GROUP_CLIENT_RESOURCES = "helpdesk.main.client.main.resources";
    private static final String CATEGORY_STOPWATCH = "helpdesk.main.stopwatch";
    private static final String PROP_GROUP_STOPWATCH = "helpdesk.main.stopwatch.main";
    private static final String PROP_GROUP_STOPWATCH_TITLE_LABEL = "helpdesk.stopwatch.title_label";
    private ConnectionFactory connectionFactory;

    public HDConfigStructureProviderTicketSettings(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Permission @Nonnull [] getRequiredPermissions() {
        return new Permission[]{Permission.CONFIGURATION};
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(126, GROUP_SETTINGS, this.translate(settings, GROUP_SETTINGS, new Object[0])));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "ticketsettings": {
                categories.add(new ConfigCategory(132, CATEGORY_ACTIONS, this.translate(settings, "Actions", new Object[0]), "ticket.settings.actions"));
                categories.add(new ConfigCategory(133, CATEGORY_STATUSES, this.translate(settings, "Statuses", new Object[0]), "ticket.settings.statuses"));
                categories.add(new ConfigCategory(135, CATEGORY_STOPWATCH, this.translate(settings, "StopWatch", new Object[0]), "ticket.settings.stopwatch"));
                categories.add(new ConfigCategory(136, CATEGORY_BEARBEITUNG, this.translate(settings, "Bearbeitung", new Object[0]), "ticket.settings.bearbeitung"));
                if (!advanced) break;
                categories.add(new ConfigCategory(137, CATEGORY_FREIFELDER, this.translate(settings, "FREIFELDER", new Object[0]), "advanced.freifelder"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        try {
            switch (categoryKey) {
                case "helpdesk.main.actions": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/actions_48.png");
                }
                case "helpdesk.main.freifelder": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/textfields_48.png");
                }
                case "helpdesk.main.statuses": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/status_48.png");
                }
                case "helpdesk.main.stopwatch": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/stopwatch_48.png");
                }
                case "helpdesk.main.ticketbearbeitung": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/editing_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "helpdesk.main.freifelder": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_FREIFELDER_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_FREIFELDER));
                break;
            }
            case "helpdesk.main.stopwatch": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_STOPWATCH_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_STOPWATCH));
                break;
            }
            case "helpdesk.main.actions": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_ACTIONS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_ACTIONS));
                break;
            }
            case "helpdesk.main.statuses": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_STATUSES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_STATUSES));
                break;
            }
            case "helpdesk.main.ticketbearbeitung": {
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_BEARBEITUNG_ALLGEMEIN, this.translate(settings, PROP_GROUP_BEARBEITUNG_ALLGEMEIN, new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(124, PROP_GROUP_BEARBEITUNG_ENDUSER, this.translate(settings, PROP_GROUP_BEARBEITUNG_ENDUSER, new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(125, PROP_GROUP_BUNDLE, this.translate(settings, PROP_GROUP_BUNDLE, new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(126, PROP_GROUP_CLIENT_RESOURCES, this.translate(settings, "client_resources", new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(127, PROP_GROUP_DEFAULT_VALUES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(128, PROP_GROUP_USERSANDGROUPS_DEFAULT, this.translate(settings, "helpdesk.tickets.defaults", new Object[0])));
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="specifying custom dictionary location only looks for custom.txt")
    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, final @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "helpdesk.main.actions.main": {
                configProperties.add((ConfigProperty)new ActionListConfigProperty(settings, t -> this.translate(settings, t)));
                break;
            }
            case "helpdesk.actions.title_label": {
                this.addTo(configProperties, "actions.title_label", "Label", settings);
                break;
            }
            case "helpdesk.freifelder.title_label": {
                this.addTo(configProperties, "freifelder.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.freifelder.main": {
                ConfigAction[] freifelderActions = new ConfigAction[]{new ConfigAction(this.translate(settings, "freifelder.add", new Object[0]))};
                List<LocalizedKey> queries = this.getAllQueries();
                List<LocalizedKey> databases = this.getAllDatabases(settings);
                ConfigProperty[] freifelderConfigProperties = new ConfigProperty[]{};
                if (!settings.isFilter()) {
                    freifelderConfigProperties = new ConfigProperty[]{new SelectConfigProperty(123, "Freifeld", "SimpleText", this.translate(settings, "FreifeldLabel", new Object[0]), (Object)this.getFirstFreeFreiFeld(), this.translate(settings, "FreifeldTooltip", new Object[0]), this.getFreiFeldColumnValues(settings.getLocale().getLanguage())), new SelectConfigProperty(123, "Database", "SimpleText", this.translate(settings, "DatabaseLabel", new Object[0]), (Object)(databases.size() > 0 ? databases.get(0).getKey() : null), this.translate(settings, "DatabaseTooltip", new Object[0]), databases), new SelectConfigProperty(123, "Query", "SimpleText", this.translate(settings, "QueryLabel", new Object[0]), (Object)(queries.size() > 0 ? queries.get(0).getKey() : null), this.translate(settings, "QueryTooltip", new Object[0]), queries), new SelectConfigProperty(123, "Freifeldtyp", "SimpleText", this.translate(settings, "FreifeldtypLabel", new Object[0]), (Object)FreifeldType.Single.name(), this.translate(settings, "FreifeldtypTooltip", new Object[0]), (List)new ArrayList<LocalizedKey>(){
                        {
                            for (FreifeldType f : FreifeldType.values()) {
                                this.add(new LocalizedKey(f.name(), HDConfigStructureProviderTicketSettings.this.translate(settings, "freifeld_" + f.name(), new Object[0])));
                            }
                        }
                    })};
                }
                List<Object> freifelderValues = new ArrayList();
                String[][] changedValues = (String[][])settings.getChangedValue(HDConfigKeys.FREIFELDER, String[][].class);
                if (changedValues != null) {
                    freifelderValues = Arrays.asList(changedValues);
                } else {
                    String jsonValue = settings.getValue(HDConfigKeys.FREIFELDER);
                    FreifeldSettingList list = (FreifeldSettingList)new Json().fromJson(jsonValue, FreifeldSettingList.class);
                    for (FreifeldSetting setting : list) {
                        freifelderValues.add(new String[]{setting.getFreifeld().name(), setting.getDatabase(), setting.getQueryName(), setting.getFreifeldType().name()});
                    }
                }
                configProperties.add((ConfigProperty)new TableConfigProperty(configProperties.size() * 100, HDConfigKeys.FREIFELDER.getKey(), "", null, null, freifelderValues, freifelderConfigProperties, new int[]{20, 20, 20, 40}, freifelderActions, null));
                break;
            }
            case "helpdesk.stopwatch.title_label": {
                this.addTo(configProperties, "stopwatch.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.stopwatch.main": {
                List<LocalizedKey> watchSettings = StopWatchConfig.getSettings();
                configProperties.add((ConfigProperty)new StopWatchConfigProperty(settings, t -> this.translate(settings, t)));
                this.addSelectTo(configProperties, HDConfigKeys.STOP_WATCH_STANDARD.getKey(), settings.getValue(HDConfigKeys.STOP_WATCH_STANDARD), "SimpleText", settings, watchSettings);
                ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                units.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "mail.timer.seconds", new Object[0])));
                units.add(new UnitConfigProperty.Unit(0.016666666666666666, this.translate(settings, "mail.timer.minutes", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.STOP_WATCH_START_THRESHOLD, settings, units);
                break;
            }
            case "helpdesk.main.statuses.main": {
                configProperties.add((ConfigProperty)new StatusListConfigProperty(this.connectionFactory, settings, t -> this.translate(settings, t)));
                break;
            }
            case "helpdesk.statuses.title_label": {
                this.addTo(configProperties, "statuses.title_label", "Label", settings);
                break;
            }
            case "helpdesk.defaultvalues.title_label": {
                this.addTo(configProperties, "defaultvalues.title_label", "Label", settings);
                break;
            }
            case "helpdesk.usersandgroupsmanager.defaults": {
                ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                units.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "default.ticket.reactivation.days", new Object[0])));
                units.add(new UnitConfigProperty.Unit(0.14285714285714285, this.translate(settings, "default.ticket.reactivation.weeks", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.DEFAULT_TICKET_REACTIVATION_TIME, settings, units);
                this.addUnitTo(configProperties, HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME, settings, units);
                this.addUnitTo(configProperties, HDConfigKeys.DEFAULT_RESUBMISSION_TIME, settings, units);
                this.addTo(configProperties, HDConfigKeys.DEFAULT_TICKET_FONT_NAME, "SelectEdit", settings, HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault());
                ArrayList<UnitConfigProperty.Unit> fontUnits = new ArrayList<UnitConfigProperty.Unit>();
                fontUnits.add(new UnitConfigProperty.Unit(1.3333333333333333, this.translate(settings, "default.ticket.font.size.pixel", new Object[0])));
                fontUnits.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "default.ticket.font.size.points", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.DEFAULT_TICKET_FONT_SIZE, settings, fontUnits);
                this.addBooleanTo(configProperties, HDConfigKeys.DEFAULT_TICKET_PLAINTEXT_REASTEP, settings);
                this.addTo(configProperties, HDConfigKeys.TICKET_START_TICKET_ID, "FixNumber", settings);
                break;
            }
            case "helpdesk.main.processing.main": {
                this.addSelectTo(configProperties, HDConfigKeys.USER_ACCESS_FILTER.getKey(), settings.getValue(HDConfigKeys.USER_ACCESS_FILTER), "FixNumber", settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("0", HDConfigStructureProviderTicketSettings.this.translate(settings, "AlleBenutzersichtbar", new Object[0])));
                        this.add(new LocalizedKey("1", HDConfigStructureProviderTicketSettings.this.translate(settings, "NurBenutzerausdereigenenOrtKundenBezeichnungsichtbar", new Object[0])));
                        this.add(new LocalizedKey("2", HDConfigStructureProviderTicketSettings.this.translate(settings, "NurBenutzerausdenBenutzergruppendesSupportersSupervisors", new Object[0])));
                    }
                });
                this.addSelectTo(configProperties, HDConfigKeys.ASK_NEW_TICKET_DESTINATION.getKey(), settings.getValue(HDConfigKeys.ASK_NEW_TICKET_DESTINATION), "FixNumber", settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("0", HDConfigStructureProviderTicketSettings.this.translate(settings, "newticket.destination.never", new Object[0])));
                        this.add(new LocalizedKey("1", HDConfigStructureProviderTicketSettings.this.translate(settings, "newticket.destination.whenopenticket", new Object[0])));
                        this.add(new LocalizedKey("2", HDConfigStructureProviderTicketSettings.this.translate(settings, "newticket.destination.always", new Object[0])));
                    }
                });
                break;
            }
            case "helpdesk.main.processing.enduser": {
                this.addTo(configProperties, HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER, settings);
                this.addTo(configProperties, HDConfigKeys.ENDUSER_ONLY_SHOW_FROM_TICKET_NUMBER, settings);
                this.addTo(configProperties, "email.internaladdresses.hint", "Label", settings);
                ArrayList<LocalizedKey> optionList = new ArrayList<LocalizedKey>();
                optionList.add(new LocalizedKey(HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.ShowAll.name(), this.translate(settings, "email.internaladdresses.alloption", new Object[0])));
                optionList.add(new LocalizedKey(HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Blacklist.name(), this.translate(settings, "email.internaladdresses.blacklistoption", new Object[0])));
                optionList.add(new LocalizedKey(HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Whitelist.name(), this.translate(settings, "email.internaladdresses.whitelistoption", new Object[0])));
                optionList.add(new LocalizedKey(HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwn.name(), this.translate(settings, "email.internaladdresses.ownoption", new Object[0])));
                optionList.add(new LocalizedKey(HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwnAndWhitelist.name(), this.translate(settings, "email.internaladdresses.ownandwhitelistoption", new Object[0])));
                this.addSelectTo(configProperties, HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE.getKey(), settings.getValue(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE), "SimpleText", settings, optionList);
                this.addTableTo(configProperties, HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST.getKey(), "SimpleText", settings, this.getValuesFor(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST, settings), new ConfigAction[]{new ConfigAction(this.translate(settings, "email.internaladdresses.add", new Object[0]))}, new ConfigProperty[]{this.propWith("SimpleText", this.translate(settings, "internaladdress", new Object[0]))});
                break;
            }
            case "helpdesk.tickets.bundle": {
                this.addSelectTo(configProperties, HDConfigKeys.BUNDLE_BEHAVIOR.getKey(), String.valueOf(settings.getValue(HDConfigKeys.BUNDLE_BEHAVIOR)), "SimpleText", settings, this.getBundleBehaviorChoices(settings));
                break;
            }
            case "helpdesk.main.client.main.resources": {
                this.addSelectTo(configProperties, HDConfigKeys.PROCESSING_CONTENT_CHANGEABLE_WHEN_CLOSED, settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("0", HDConfigStructureProviderTicketSettings.this.translate(settings, "content.changeable.none", new Object[0])));
                        this.add(new LocalizedKey("1", HDConfigStructureProviderTicketSettings.this.translate(settings, "content.changeable.text", new Object[0])));
                        this.add(new LocalizedKey("2", HDConfigStructureProviderTicketSettings.this.translate(settings, "content.changeable.all", new Object[0])));
                    }
                });
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 128);
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 256);
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 65536);
                this.addBitMaskTo(configProperties, HDConfigKeys.CLIENT_START_OPTION, settings, 0x20000000);
                String value = settings.getValue(HDConfigKeys.CLIENT_EFFORTTIME_CONFIG);
                if (value == null) {
                    String clientOptions = settings.getValue(HDConfigKeys.CLIENT_START_OPTION);
                    try {
                        int vInteger = Integer.parseInt(clientOptions);
                        String clientOptionValue = "" + ((vInteger & 0x800000) == 0x800000);
                        value = clientOptionValue.equalsIgnoreCase(Boolean.FALSE.toString()) ? "1" : "0";
                    }
                    catch (NumberFormatException exc) {
                        LogManager.getConfigLogger().error((Throwable)exc);
                        value = "0";
                    }
                }
                this.addSelectTo(configProperties, HDConfigKeys.CLIENT_EFFORTTIME_CONFIG.getKey(), value, "FixNumber", settings, new ArrayList<LocalizedKey>(){
                    {
                        this.add(new LocalizedKey("0", HDConfigStructureProviderTicketSettings.this.translate(settings, "efforttime.mandatory", new Object[0])));
                        this.add(new LocalizedKey("1", HDConfigStructureProviderTicketSettings.this.translate(settings, "efforttime.optional", new Object[0])));
                        this.add(new LocalizedKey("2", HDConfigStructureProviderTicketSettings.this.translate(settings, "efforttime.hidden", new Object[0])));
                    }
                });
                this.addTo(configProperties, HDConfigKeys.CLIENT_EFFORTTIME_CHANGE, settings);
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator g = new ConditionGenerator();
        if (categoryKey.equals(CATEGORY_BEARBEITUNG)) {
            ConfigCondition effortTimeActive = g.createCondition().not(g.createCondition().property(HDConfigKeys.CLIENT_EFFORTTIME_CONFIG).equals().value((Object)"2"));
            actions.add(g.enableActionFor(effortTimeActive, HDConfigKeys.CLIENT_EFFORTTIME_CHANGE));
            actions.add(ConditionGenerator2.prop((ConfigKey)HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST).enableIf(new ConfigCondition(ConfigCondition.Operation.Or, List.of(ConditionGenerator2.prop((ConfigKey)HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE).equalTo((Object)HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Blacklist.name()), ConditionGenerator2.prop((ConfigKey)HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE).equalTo((Object)HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Whitelist.name()), ConditionGenerator2.prop((ConfigKey)HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE).equalTo((Object)HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwnAndWhitelist.name())))));
        }
    }

    protected void addBitMaskTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, int bitMask) {
        if (Arrays.asList(HDConfigStructureProvider.FLIPPED_BITS).contains(bitMask)) {
            this.addFlippedBitMaskTo(configProperties, configKey, settings, bitMask);
        } else {
            super.addBitMaskTo(configProperties, configKey, settings, bitMask);
        }
    }

    private List<LocalizedKey> getBundleBehaviorChoices(final ConfigStructureSettings settings) {
        return new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey(BundleBehavior.sameLocationOnly.name(), HDConfigStructureProviderTicketSettings.this.translate(settings, "tickets.bundle.samelocationonly", new Object[0])));
                this.add(new LocalizedKey(BundleBehavior.sameOwnerOnly.name(), HDConfigStructureProviderTicketSettings.this.translate(settings, "tickets.bundle.sameowneronly", new Object[0])));
                this.add(new LocalizedKey(BundleBehavior.sameEmailDomainOnly.name(), HDConfigStructureProviderTicketSettings.this.translate(settings, "tickets.bundle.samedomainonly", new Object[0])));
                this.add(new LocalizedKey(BundleBehavior.alwaysAllow.name(), HDConfigStructureProviderTicketSettings.this.translate(settings, "tickets.bundle.alwaysAllow", new Object[0])));
            }
        };
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="relative locations set by the admin are always based on app data folder")
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        block23: {
            block28: {
                ConfigValidator validator;
                block27: {
                    block26: {
                        block25: {
                            TicketIdDefList idDefList;
                            block24: {
                                validator = new ConfigValidator(messages, settings);
                                if (!CATEGORY_FREIFELDER.equals(categoryKey)) break block24;
                                String[][] changedValue = (String[][])settings.getChangedValue(HDConfigKeys.FREIFELDER, String[][].class);
                                FreifeldSettingList list = changedValue != null ? this.getFreifeldSettingsFromStringArrayArrayJson(changedValue) : (FreifeldSettingList)new Json().fromJson(settings.getValue(HDConfigKeys.FREIFELDER), FreifeldSettingList.class);
                                for (FreifeldSetting s2 : list) {
                                    FieldType fieldType;
                                    for (FreifeldSetting s22 : list) {
                                        if (s2 == s22 || !s2.getFreifeld().equals((Object)s22.getFreifeld())) continue;
                                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "NichtmehralseinmaldasgleicheFreifeldbitte", new Object[0]), HDConfigKeys.FREIFELDER.getKey()));
                                        return;
                                    }
                                    String fieldKey = null;
                                    switch (s2.getFreifeld()) {
                                        case auftrag1: {
                                            fieldKey = "custom1";
                                            break;
                                        }
                                        case auftrag2: {
                                            fieldKey = "custom2";
                                            break;
                                        }
                                        case auftrag3: {
                                            fieldKey = "custom3";
                                            break;
                                        }
                                        case auftrag4: {
                                            fieldKey = "custom4";
                                            break;
                                        }
                                        case auftrag5: {
                                            fieldKey = "custom5";
                                            break;
                                        }
                                        case auftrag6: {
                                            fieldKey = "custom6";
                                            break;
                                        }
                                        case auftrag7: {
                                            fieldKey = "custom7";
                                            break;
                                        }
                                    }
                                    if (fieldKey == null || (fieldType = Tickets.getFieldByKey(fieldKey).getFieldType()) instanceof FieldTypeString || fieldType instanceof FieldTypeSelect) continue;
                                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "freiFeldMussTextTypeHaben", new Object[]{Tickets.getFieldByKey(fieldKey).getLabel()}), HDConfigKeys.FREIFELDER.getKey()));
                                }
                                validator.checkNeedRestart(HDConfigKeys.FREIFELDER);
                                break block23;
                            }
                            if (!CATEGORY_BEARBEITUNG.equals(categoryKey)) break block25;
                            validator.validateNumberRange(HDConfigKeys.ENDUSER_ONLY_SHOW_FROM_TICKET_NUMBER, 1L, Integer.MAX_VALUE);
                            validator.validateNumberRange(HDConfigKeys.ASK_NEW_TICKET_DESTINATION, 0L, 2L);
                            validator.validateUnitNumberRangeWholeNumbers(HDConfigKeys.DEFAULT_TICKET_REACTIVATION_TIME, 0L, 1000L, "d");
                            validator.validateUnitNumberRangeWholeNumbers(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME, 1L, 1000L, "d");
                            validator.validateUnitNumberRangeWholeNumbers(HDConfigKeys.DEFAULT_RESUBMISSION_TIME, 1L, 1000L, "d");
                            String idList = settings.getChangedValue(HDConfigKeys.TICKET_ID_DEF_LIST.getKey());
                            if (idList != null && (idDefList = this.getTicketIdDefListFromValue(idList)).size() == 0) {
                                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "AtLeastOneIdRequired", new Object[0]), HDConfigKeys.TICKET_ID_DEF_LIST));
                            }
                            validator.validateNumberRange(HDConfigKeys.TICKET_START_TICKET_ID, 0L, 100000L);
                            break block23;
                        }
                        if (!"action.new".equals(categoryKey)) break block26;
                        validator.validateStringLength("AktBezeichnung", 0, 50);
                        String aktPauschale = settings.getChangedValue("AktPauschale");
                        if (aktPauschale == null || aktPauschale.isEmpty()) {
                            aktPauschale = "0";
                        }
                        validator.validateNumberRange("AktPauschale", aktPauschale, 0L, Long.MAX_VALUE);
                        break block23;
                    }
                    if (!"status.new".equals(categoryKey)) break block27;
                    validator.checkNotEmpty("StatusBezeichnung");
                    validator.validateStringLength("StatusBezeichnung", 0, 50);
                    if (!"true".equals(settings.getValue("isNewlyCreated"))) break block23;
                    String id = settings.getChangedValue("id");
                    validator.validateNumberRange("id", id, Integer.MIN_VALUE, 1000000L);
                    try {
                        if (Integer.parseInt(id) < 0) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customStatusIDMustNotBeNegative", new Object[0]), "id"));
                        }
                    }
                    catch (NumberFormatException idDefList) {
                        // empty catch block
                    }
                    String allidsJson = settings.getValue("allids");
                    List allids = (List)new Json().fromJson(allidsJson, (Type)new JsonParameterizedType(List.class, new Type[]{String.class}));
                    Set idSet = allids.stream().map(s -> Integer.valueOf(s)).collect(Collectors.toSet());
                    if (id != null && !id.trim().isEmpty()) {
                        try {
                            Integer idInt = Integer.valueOf(id);
                            if (idSet.contains(idInt)) {
                                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "statusIDAlreadyExists", new Object[0]), "id"));
                            }
                        }
                        catch (NumberFormatException idInt) {}
                    }
                    break block23;
                }
                if (!CATEGORY_ACTIONS.equals(categoryKey)) break block28;
                List changedValueRaw = (List)settings.getChangedValue("Actions", List.class);
                if (changedValueRaw == null) break block23;
                List oldList = ActionManager.getInstance().getAll(true);
                for (ActionVO actionVO : oldList) {
                    boolean anyMatch = changedValueRaw.stream().anyMatch(map -> Integer.parseInt((String)map.get("id")) == actionVO.getId());
                    if (anyMatch) continue;
                    validator.checkNeedRestart(HDConfigKeys.CLIENT_START_OPTION, "old", "new");
                    break block23;
                }
                break block23;
            }
            if ("stopwatchrule.new".equals(categoryKey)) {
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("ConditionType", settings.getChangedValue("ConditionType"));
                map2.put("ConditionParameter", settings.getChangedValue("ConditionParameter"));
                map2.put("ConditionParameterRess", settings.getChangedValue("ConditionParameterRess"));
                map2.put("Setting", settings.getChangedValue("Setting"));
                StopWatchList list = StopWatchConfig.getStopWatchSettingsFromConfigGUI(List.of(map2));
                for (StopWatchRule stopWatchRule : list) {
                    GUID groupId;
                    if (stopWatchRule.getCondition().getType() != ConditionType.TicketIsInResource && stopWatchRule.getCondition().getType() != ConditionType.UserIsInGroup || (groupId = stopWatchRule.getCondition().getParameter()) != null) continue;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "stopwatch.error.needparameter", new Object[]{this.translate(settings, "stopwatch.conditiontype." + stopWatchRule.getCondition().getType().name(), new Object[0])}), "ConditionParameter"));
                }
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.startsWith(HDConfigKeys.CLIENT_START_OPTION.getKey() + ".")) {
            String bitmask = key.substring((HDConfigKeys.CLIENT_START_OPTION.getKey() + ".").length());
            key = HDConfigKeys.CLIENT_START_OPTION.getKey();
            boolean booleanValue = Boolean.valueOf(value);
            int toOrToValue = Integer.parseInt(bitmask);
            if (Arrays.asList(HDConfigStructureProvider.FLIPPED_BITS).contains(toOrToValue)) {
                booleanValue = !booleanValue;
            }
            Integer currValue = null;
            try {
                currValue = Integer.valueOf(settings.getOriginalValue(HDConfigKeys.CLIENT_START_OPTION));
            }
            catch (NumberFormatException exc) {
                currValue = Integer.valueOf(HDConfigKeys.CLIENT_START_OPTION.getDefault());
            }
            value = booleanValue ? String.valueOf(currValue | toOrToValue) : ((currValue & toOrToValue) == toOrToValue ? String.valueOf(currValue - toOrToValue) : String.valueOf(currValue));
            settings.save(key, value);
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals(HDConfigKeys.FREIFELDER.getKey())) {
            String[][] rows = (String[][])new Json().fromJson(value, String[][].class);
            FreifeldSettingList list = this.getFreifeldSettingsFromStringArrayArrayJson(rows);
            settings.save(key, list.toString());
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals(HDConfigKeys.STOP_WATCH_RULES.getKey())) {
            List changedValueRaw = (List)settings.getChangedValue(HDConfigKeys.STOP_WATCH_RULES, List.class);
            StopWatchList list = StopWatchConfig.getStopWatchSettingsFromConfigGUI(changedValueRaw);
            settings.save(key, new Json().toJson((Object)list));
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals("Statuses")) {
            List changedValueRaw = (List)settings.getChangedValue("Statuses", List.class);
            if (changedValueRaw != null) {
                List<String> serializedImageData = TicketValueIconConfigProperty.getSerializedImageData(changedValueRaw);
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                    element.remove("allids");
                    element.remove("isNewlyCreated");
                }
                Json json = new Json();
                StatusList list = (StatusList)json.fromJson(json.toJson((Object)changedValueRaw), StatusList.class);
                StatusManager m = StatusManager.getInstance();
                List all = m.getAll(false);
                ArrayList<Integer> ids = new ArrayList<Integer>(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (StatusVO c : list) {
                    StatusVO old = (StatusVO)m.get(c.getId());
                    try {
                        String relativePath;
                        ids.remove((Object)c.getId());
                        if (old == null) {
                            m.add(c);
                        } else {
                            m.update(c);
                        }
                        if ((relativePath = TicketValueIconConfigProperty.storeIcons(serializedImageData, 0, c.getId(), c.getImageName())) == null) continue;
                        m.update(new StatusVO(c.getId(), c.getDisplayValue(), relativePath, c.isDeleted(), c.isInternal()));
                    }
                    catch (SQLException e) {
                        ids.add(c.getId());
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                ids.forEach(i -> {
                    try {
                        StatusVO p = (StatusVO)m.get((int)i);
                        m.update(new StatusVO(p.getId(), p.getDisplayValue(), p.getImageName(), true, p.isInternal()));
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                });
                return ConfigStructure.SaveState.SAVE;
            }
        } else if (key.equals("Actions")) {
            List changedValueRaw = (List)settings.getChangedValue("Actions", List.class);
            if (changedValueRaw != null) {
                for (Map element : changedValueRaw) {
                    element.remove("IsDefault");
                    element.remove("hide");
                    element.remove("isNewlyCreated");
                    element.remove("textRequired");
                    element.remove("canRequireText");
                    element.remove("canChangeStatus");
                }
                Json json = new Json();
                ActionList list = (ActionList)json.fromJson(json.toJson((Object)changedValueRaw), ActionList.class);
                ActionManager m = ActionManager.getInstance();
                List all = m.getAll(false);
                ArrayList<Integer> ids = new ArrayList<Integer>(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (ActionVO c : list) {
                    ActionVO old = (ActionVO)m.get(c.getId());
                    try {
                        ids.remove((Object)c.getId());
                        if (old == null) {
                            m.add(c);
                            continue;
                        }
                        m.update(c);
                    }
                    catch (SQLException e) {
                        ids.add(c.getId());
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                ids.forEach(i -> {
                    try {
                        ActionVO actionVO = (ActionVO)m.get((int)i);
                        if (!actionVO.isDeleted()) {
                            m.update(new ActionVO(actionVO.getId(), actionVO.getDisplayValue(), actionVO.getStatusID(), actionVO.isInternal(), actionVO.getBillingType(), actionVO.getLumpSumType(), actionVO.getFixedCharge(), true, actionVO.getSpecial(), actionVO.isHidden()));
                        }
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                });
                return ConfigStructure.SaveState.SAVE;
            }
        } else {
            if (key.equals(HDConfigKeys.TICKET_ID_DEF_LIST.getKey())) {
                TicketIdDefList list = this.getTicketIdDefListFromValue(value);
                if (list.size() == 0) {
                    list.add("TicketID");
                }
                settings.save(key, new Json().toJson((Object)list));
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST.getKey())) {
                String[][] rows = (String[][])new Json().fromJson(value, String[][].class);
                ArrayList list = new ArrayList();
                Arrays.asList(rows).stream().map(row -> row[0]).filter(row -> !row.isEmpty()).distinct().forEach(row -> list.add(row));
                settings.save(key, new Json().toJson(list));
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    private List<LocalizedKey> getAllDatabases(ConfigStructureSettings settings) {
        DatabaseConfigInfoList list = HDConfigStructureProvider.getDatabaseConfigInfoList(settings);
        return list.stream().map(c -> new LocalizedKey(c.getDbName(), c.getDbName())).collect(Collectors.toList());
    }

    private String getFirstFreeFreiFeld() {
        return Freifeld.auftrag1.name();
    }

    private List<LocalizedKey> getAllQueries() {
        HashSet<String> queriesToFilterOut = new HashSet<String>(Arrays.asList("AdminEdit_Daten1", "AdminEdit_IS", "BGBuendel", "BuendelSelektion", "ChangeUser", "DispatcherData", "GeraeteBestandSelect", "GeraeteBestandTest", "GeraeteDelete", "GeraeteUserChange", "ItilAllKnownProblems", "SetBuendelStatus", "User_ID", "UserBuendel", "UsersSelect"));
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement st = con.prepareStatement("select abfrageid, abfrage from tblQueries");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                String query = rs.getString(1);
                String sql = rs.getString(2);
                if (sql == null || sql.toLowerCase().startsWith("update") || sql.toLowerCase().startsWith("delete") || sql.toLowerCase().contains("?") || queriesToFilterOut.contains(query)) continue;
                result.add(new LocalizedKey(query, query));
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        return result;
    }

    private List<LocalizedKey> getFreiFeldColumnValues(@Nonnull String lang) {
        ArrayList<String> requestedColumns = new ArrayList<String>();
        for (Freifeld feld : Freifeld.values()) {
            requestedColumns.add(feld.name());
        }
        return HDConfigStructureProvider.getColumnValues(lang, requestedColumns);
    }

    private FreifeldSettingList getFreifeldSettingsFromStringArrayArrayJson(String[][] rows) {
        FreifeldSettingList list = new FreifeldSettingList();
        for (String[] row : rows) {
            FreifeldSetting setting = new FreifeldSetting(Freifeld.valueOf(row[0]));
            setting.setDatabase(row[1]);
            setting.setQueryName(row[2]);
            setting.setFreifeldType(FreifeldType.valueOf(row[3]));
            list.add(setting);
        }
        return list;
    }

    private String translate(ConfigStructureSettings settings, String[] t) {
        if (t != null && t.length > 0) {
            if (t.length == 1) {
                return this.translate(settings, t[0], new Object[0]);
            }
            return this.translate(settings, t[0], Arrays.copyOfRange(t, 1, t.length));
        }
        return null;
    }

    protected TicketIdDefList getTicketIdDefListFromValue(String value) {
        String[][] rows = (String[][])new Json().fromJson(value, String[][].class);
        TicketIdDefList list = new TicketIdDefList();
        Arrays.asList(rows).stream().map(row -> row[0]).filter(row -> !row.isEmpty()).distinct().forEach(row -> list.add(row));
        return list;
    }

    /*
     * Exception decompiling
     */
    List<String[]> getValuesFor(ConfigKey key, ConfigStructureSettings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ConfigProperty propWith(String type, String label) {
        return new ConfigProperty(0, "", type, label, null, null, null);
    }

    private static /* synthetic */ void lambda$getValuesFor$15(List result, Object value) {
        result.add(new String[]{value != null ? value.toString() : ""});
    }
}

