/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.ClassificationList;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonData
public class ClassificationListConfigProperty
extends ItemListConfigProperty {
    public ClassificationListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, "Classifications", "CLASSIFICATIONS", ClassificationListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{ClassificationListConfigProperty.getRowAction(settings, translator)});
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        List cls = (List)settings.getChangedValue("Classifications", List.class);
        if (cls != null) {
            cls.sort((c1, c2) -> ((String)c1.get("KlassenName")).compareToIgnoreCase((String)c2.get("KlassenName")));
            return cls;
        }
        List list = ClassificationManager.getInstance().getAll(true);
        ClassificationList cList = new ClassificationList();
        cList.addAll(list);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (ClassificationVO classification : cList) {
            HashMap<String, String> entry = ClassificationListConfigProperty.convertToHashmap(classification);
            if (classification.getId() == 0) {
                entry.put("hide", "true");
            }
            result.add(entry);
        }
        result.sort((o1, o2) -> ((String)o1.get("KlassenName")).compareToIgnoreCase((String)o2.get("KlassenName")));
        return result;
    }

    private static HashMap<String, String> convertToHashmap(ClassificationVO classification) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("KlassenName", classification.getDisplayValue());
        result.put("KlaImage", classification.getImageName());
        result.put("KlasseInfo", classification.getInfo());
        result.put("id", "" + classification.getId());
        result.put("hide", "false");
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    public static ClassificationList convertToList(HashMap<String, String>[] result) {
        ClassificationList map = new ClassificationList();
        for (HashMap<String, String> classification : result) {
            ClassificationVO info = ClassificationListConfigProperty.convertToEntry(classification);
            map.add(info);
        }
        return map;
    }

    private static ClassificationVO convertToEntry(HashMap<String, String> classificationMap) {
        String id = classificationMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.parseInt(id);
        return new ClassificationVO(idNum, classificationMap.get("KlassenName"), classificationMap.get("KlasseInfo"), classificationMap.get("KlaImage"));
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, Translator translator) {
        ConfigAction action = new ConfigAction("classification.new", translator.translate("AddClassification"));
        ConfigCategory category = new ConfigCategory(0, "classification.new", translator.translate("Classification"), "ticket.values.classifications");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "classification.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("classification.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(ClassificationListConfigProperty.propWith("SimpleText", translator.translate("KlassenName"), "KlassenName", ""));
        propertyList.add(ClassificationListConfigProperty.propWith("MultiLineText", translator.translate("KlasseInfo"), "KlasseInfo", ""));
        propertyList.add((Object)new TicketValueIconConfigProperty(0, translator.translate("KlaImage"), 3));
        propertyList.add(ClassificationListConfigProperty.propWith("Hidden", "id", "id", "-1"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

