/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.CategoryList;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonData
public class CategoryListConfigProperty
extends ItemListConfigProperty {
    public static PathNameResolver RESOURCE_RESOLVER = resourceID -> {
        UserGroupInfo resource = HDUsersAndGroups.getResource(resourceID);
        Object displayName = resource.getDisplayName();
        GUID parentID = resource.getParentID();
        while (parentID != null) {
            UserGroupInfo group = UserGroupManager.getInstance().getGroup(parentID);
            displayName = group.getDisplayName() + "/" + (String)displayName;
            parentID = group.getParentID();
        }
        return displayName;
    };

    private static String getFullPathName(int resourceID) {
        return RESOURCE_RESOLVER.getFullResourcePathName(resourceID);
    }

    public CategoryListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, "Categories", "CATEGORIES", CategoryListConfigProperty.getObjectListValue(settings, translator), null, new ConfigRowAction[0]);
        List objectListValue = (List)this.getValue();
        Set<String> allPaths = objectListValue.stream().map(m -> (String)m.get("path")).collect(Collectors.toSet());
        this.setRowActions(new ConfigRowAction[]{CategoryListConfigProperty.getRowAction(settings, translator, allPaths)});
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        List cats = (List)settings.getChangedValue("Categories", List.class);
        if (cats != null) {
            HashMap<Object, Map> idToValues = new HashMap<Object, Map>();
            block0: for (int i2 = 0; i2 < cats.size(); ++i2) {
                Map m2 = (Map)cats.get(i2);
                Object id2 = (String)m2.get("id");
                Integer idNum = Integer.valueOf((String)id2);
                String parentID = CategoryListConfigProperty.getParentId(m2);
                Object path = (String)m2.get("Betreff");
                String resID = (String)m2.get("ResID");
                String resIDKey = resID.startsWith("{") ? (String)((Map)new Json().fromJson(resID, Map.class)).get("key") : resID;
                boolean isEmptyRes = "0".equals(resIDKey);
                m2.put("inheritedResource", "" + isEmptyRes);
                m2.put("DisplayResID", isEmptyRes ? "{\"key\":\"0\", \"label\":\"\"}" : resID);
                String userInVis = (String)m2.get("UserInVis");
                m2.put("DisplayUserInVis", userInVis);
                m2.put("InheritUserInVis", "false");
                int level = 0;
                while (!"0".equals(parentID) && !"".equals(parentID)) {
                    String parentResID;
                    Map parentMap = (Map)idToValues.get(parentID);
                    if (parentMap == null) {
                        for (int j = 0; j < cats.size(); ++j) {
                            Map tmpCat = (Map)cats.get(j);
                            String idString = (String)tmpCat.get("id");
                            if (!parentID.equals(idString)) continue;
                            cats.remove(i2);
                            cats.add(j, m2);
                            --i2;
                            continue block0;
                        }
                        continue block0;
                    }
                    path = (String)parentMap.get("Betreff") + "\\" + (String)path;
                    String parentResIDKey = parentResID = (String)parentMap.get("ResID");
                    if (parentResID.startsWith("{")) {
                        parentResIDKey = (String)((Map)new Json().fromJson(parentResID, Map.class)).get("key");
                    }
                    if (isEmptyRes && !"0".equals(parentResIDKey)) {
                        m2.put("DisplayResID", parentResID);
                        isEmptyRes = false;
                    }
                    String parentUserInVis = (String)parentMap.get("UserInVis");
                    if ("false".equals(userInVis) && "true".equals(parentUserInVis)) {
                        m2.put("DisplayUserInVis", parentUserInVis);
                    }
                    if ("true".equals(parentUserInVis)) {
                        m2.put("InheritUserInVis", "true");
                    }
                    parentID = CategoryListConfigProperty.getParentId(parentMap);
                    ++level;
                }
                while (idToValues.containsKey(id2)) {
                    idNum = idNum - 1;
                    id2 = "" + idNum;
                }
                m2.put("id", id2);
                m2.put("level", "" + level);
                m2.put("path", path);
                idToValues.put(id2, m2);
            }
            Set allPaths = idToValues.values().stream().map(m -> (String)m.get("path")).collect(Collectors.toSet());
            idToValues.values().forEach(m -> {
                ArrayList pathsWithoutMyself = new ArrayList(allPaths);
                pathsWithoutMyself.remove(m.get("path"));
                String idListJson = new Json().toJson(pathsWithoutMyself);
                m.put("allcats", idListJson);
            });
            return idToValues.values().stream().sorted((c1, c2) -> CategoryVO.comparePaths((String)c1.get("path"), (String)c2.get("path"))).collect(Collectors.toList());
        }
        Map<Integer, String> allPathNames = CategoryManager.getInstance().getAllPathNames(true);
        allPathNames.remove(0);
        List list = CategoryManager.getInstance().getAll(true);
        List sortedIds = list.stream().sorted().map(FieldVO::getId).filter(id -> id != 0).collect(Collectors.toList());
        CategoryList cList = new CategoryList();
        cList.addAll(list);
        HashMap<Integer, CategoryVO> idToCategory = new HashMap<Integer, CategoryVO>();
        cList.forEach(c -> idToCategory.put(c.getId(), (CategoryVO)c));
        HashMap<CallSite, HashMap<String, String>> idToValues = new HashMap<CallSite, HashMap<String, String>>();
        for (CategoryVO category : cList) {
            if (category.getId() == 0) continue;
            String idListJson = new Json().toJson((Object)allPathNames.values().stream().filter(p -> !p.equals(category.getPath())).collect(Collectors.toCollection(HashSet::new)));
            HashMap<String, String> entry = CategoryListConfigProperty.convertToHashmap(idToCategory, category, translator);
            entry.put("isNewlyCreated", "false");
            entry.put("path", category.getPath());
            entry.put("allcats", idListJson);
            idToValues.put((CallSite)((Object)entry.get("id")), entry);
        }
        return sortedIds.stream().map(i -> (Map)idToValues.get("" + i)).collect(Collectors.toList());
    }

    private static String getParentId(Map<String, String> m) {
        String parentID = m.get("ParentID");
        if (parentID.startsWith("{")) {
            parentID = (String)((Map)new Json().fromJson(parentID, Map.class)).get("key");
        }
        return parentID;
    }

    private static HashMap<String, String> convertToHashmap(Map<Integer, CategoryVO> idToCategory, CategoryVO category, Translator translator) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + category.getId());
        result.put("Betreff", category.getDisplayValue());
        result.put("absender", category.getAbsender() == null ? "" : category.getAbsender());
        int parentCategoryID = category.getParentCategoryID();
        if (parentCategoryID == 0) {
            result.put("ParentID", new Json().toJson((Object)new LocalizedKey("0", "")));
        } else {
            result.put("ParentID", new Json().toJson((Object)new LocalizedKey("" + parentCategoryID, ((CategoryVO)CategoryManager.getInstance().get(parentCategoryID)).getDisplayValue())));
        }
        int resourceID = category.getResourceID();
        if (resourceID != 0) {
            result.put("ResID", new Json().toJson((Object)new LocalizedKey("" + resourceID, CategoryListConfigProperty.getFullPathName(resourceID))));
        } else {
            CategoryVO parent;
            boolean allAncestorsHaveNoResource = true;
            while (parentCategoryID != 0 && (parent = idToCategory.get(parentCategoryID)) != null) {
                allAncestorsHaveNoResource = allAncestorsHaveNoResource && parent.getResourceID() == 0;
                parentCategoryID = parent.getParentCategoryID();
            }
            if (allAncestorsHaveNoResource) {
                result.put("ResID", new Json().toJson((Object)new LocalizedKey("0", "")));
            } else {
                result.put("ResID", new Json().toJson((Object)new LocalizedKey("0", translator.translate("category.inheritFromParent"))));
            }
        }
        result.put("DisplayResID", (String)result.get("ResID"));
        result.put("DisplayUserInVis", (String)result.get("UserInVis"));
        result.put("InheritUserInVis", "false");
        result.put("inheritedResource", "" + (resourceID == 0));
        int parent = category.getParentCategoryID();
        int level = 0;
        boolean isHidden = category.isHidden();
        while (parent != 0) {
            CategoryVO categoryVO = (CategoryVO)CategoryManager.getInstance().get(parent);
            parent = categoryVO.getParentCategoryID();
            if (categoryVO.isHidden()) {
                result.put("InheritUserInVis", "true");
            }
            boolean bl = isHidden = isHidden || categoryVO.isHidden();
            if (resourceID == 0 && (resourceID = categoryVO.getResourceID()) != 0) {
                result.put("DisplayResID", new Json().toJson((Object)new LocalizedKey("" + resourceID, CategoryListConfigProperty.getFullPathName(resourceID))));
            }
            ++level;
        }
        result.put("level", "" + level);
        result.put("UserInVis", "" + category.isHidden());
        result.put("DisplayUserInVis", "" + isHidden);
        return result;
    }

    public static CategoryList convertToList(HashMap<String, String>[] result) {
        CategoryList map = new CategoryList();
        for (HashMap<String, String> category : result) {
            CategoryVO info = CategoryListConfigProperty.convertToEntry(category);
            map.add(info);
        }
        return map;
    }

    private static CategoryVO convertToEntry(HashMap<String, String> categoryMap) {
        String resIDString;
        String id = categoryMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.valueOf(id);
        String name = categoryMap.get("Betreff");
        String absender = categoryMap.get("absender");
        String parentIDString = categoryMap.get("ParentID");
        Integer parentId = null;
        if (parentIDString != null && !parentIDString.isEmpty()) {
            parentId = Integer.valueOf(parentIDString);
        }
        if ((resIDString = categoryMap.get("ResID")) == null || resIDString.isEmpty()) {
            resIDString = "0";
        }
        Integer resId = Integer.valueOf(resIDString);
        Boolean invisible = Boolean.valueOf(categoryMap.get("UserInVis"));
        return new CategoryVO(idNum, name, parentId, resId, invisible, false, absender);
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, Translator translator, Set<String> allcats) {
        int defaultIdForNew = -1;
        List cats = (List)settings.getChangedValue("Categories", List.class);
        if (cats != null) {
            defaultIdForNew = cats.stream().map(m -> Integer.valueOf((String)m.get("id"))).min(Comparator.naturalOrder()).orElse(0) - 1;
        }
        ConfigAction action = new ConfigAction("category.new", translator.translate("AddCategory"));
        ConfigCategory category = new ConfigCategory(0, "category.new", translator.translate("Category"), "ticket.values.categories");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "category.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("category.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        conditions.add(g.enableActionFor(g.createCondition().property("isNewlyCreated").equals().value((Object)"true"), "ParentID"));
        conditions.add(g.visibleActionFor(g.createCondition().property("InheritUserInVis").equals().value((Object)"false"), "UserInVis"));
        conditions.add(g.visibleActionFor(g.createCondition().property("InheritUserInVis").equals().value((Object)"true"), "DisplayUserInVis"));
        conditions.add(g.enableActionFor(ConfigCondition.FALSE, "DisplayUserInVis"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(CategoryListConfigProperty.propWith("SimpleText", translator.translate("Betreff"), "Betreff", ""));
        propertyList.add(CategoryListConfigProperty.propWith("SelectFiltered", translator.translate("ParentID"), "ParentID", "0"));
        propertyList.add(CategoryListConfigProperty.propWith("SelectFiltered", translator.translate("ResID"), "ResID", "0"));
        propertyList.add(CategoryListConfigProperty.propWith("SimpleText", translator.translate("absender"), "absender", ""));
        propertyList.add(new BooleanConfigProperty(0, "UserInVis", "Boolean", translator.translate("UserInVis"), null, null, (Object)"false"));
        propertyList.add(new BooleanConfigProperty(0, "DisplayUserInVis", "Boolean", translator.translate("UserInVisBecauseParent"), null, null, (Object)"false"));
        propertyList.add(CategoryListConfigProperty.propWith("Hidden", "id", "id", "" + defaultIdForNew));
        propertyList.add(CategoryListConfigProperty.propWith("Hidden", "isNewlyCreated", "isNewlyCreated", "true"));
        propertyList.add(CategoryListConfigProperty.propWith("Hidden", "InheritUserInVis", "InheritUserInVis", "false"));
        propertyList.add(CategoryListConfigProperty.propWith("Hidden", "allcats", "allcats", new Json().toJson(allcats)));
        propertyList.add(CategoryListConfigProperty.propWith("Hidden", "path", "path", settings.getValue("path")));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }

    public static interface PathNameResolver {
        public String getFullResourcePathName(int var1);
    }
}

